/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory;

import com._1c.chassis.gears.versions.SemanticVersion;
import com._1c.packaging.inventory.IMessagesList;
import com._1c.packaging.inventory.InventoryStructureException;
import javax.annotation.Nonnull;

public class BrokenComponentDependencyException
extends InventoryStructureException {
    private final String componentId;
    private final SemanticVersion componentVersion;
    private final String dependencyId;
    private final SemanticVersion dependencyVersion;

    public BrokenComponentDependencyException(String componentId, SemanticVersion componentVersion, String dependencyId, SemanticVersion dependencyVersion) {
        super(IMessagesList.Messages.brokenComponentDependency(componentId, componentVersion, dependencyId, dependencyVersion));
        this.componentId = componentId;
        this.componentVersion = componentVersion;
        this.dependencyId = dependencyId;
        this.dependencyVersion = dependencyVersion;
    }

    @Nonnull
    public String getComponentId() {
        return this.componentId;
    }

    @Nonnull
    public SemanticVersion getComponentVersion() {
        return this.componentVersion;
    }

    @Nonnull
    public String getDependencyId() {
        return this.dependencyId;
    }

    @Nonnull
    public SemanticVersion getDependencyVersion() {
        return this.dependencyVersion;
    }

    public String debugDescription() {
        StringBuilder sb = new StringBuilder("BrokenComponentDependencyException [");
        sb.append("Component ").append(this.componentId).append(':');
        sb.append(this.componentVersion);
        sb.append(" depends of an absent component ").append(this.dependencyId).append(':');
        sb.append(this.dependencyVersion).append(']');
        return sb.toString();
    }
}

