/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory;

import com._1c.packaging.inventory.IComponentInstallationValidationResult;
import com._1c.packaging.inventory.IMessagesList;
import com._1c.packaging.inventory.InventoryStructureException;
import com._1c.packaging.model.shared.ComponentKey;
import javax.annotation.Nonnull;

public class CannotInstallComponentException
extends InventoryStructureException {
    private final IComponentInstallationValidationResult installationError;
    private final ComponentKey installingComponentKey;

    public CannotInstallComponentException(IComponentInstallationValidationResult installationError, ComponentKey installingComponentKey) {
        super(IMessagesList.Messages.cannotInstallComponent(installingComponentKey, installationError.getTextErrorReport()));
        this.installationError = installationError;
        this.installingComponentKey = installingComponentKey;
    }

    @Nonnull
    public IComponentInstallationValidationResult getInstallationError() {
        return this.installationError;
    }

    @Nonnull
    public ComponentKey getInstallingComponentKey() {
        return this.installingComponentKey;
    }

    public String debugDescription() {
        StringBuilder sb = new StringBuilder("CannotInstallComponentException [");
        sb.append("installationError=[").append(this.installationError).append(']');
        sb.append(", installingComponentKey=[").append(this.installingComponentKey).append(']');
        sb.append(']');
        return sb.toString();
    }
}

