/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory;

import com._1c.packaging.inventory.IMessagesList;
import com._1c.packaging.inventory.IProductInstallationValidationResult;
import com._1c.packaging.inventory.InventoryStructureException;
import com._1c.packaging.model.shared.ProductKey;
import javax.annotation.Nonnull;

public class CannotInstallProductException
extends InventoryStructureException {
    private final IProductInstallationValidationResult installationError;
    private final ProductKey installingProductKey;

    public CannotInstallProductException(IProductInstallationValidationResult installationError, ProductKey installingProductKey) {
        super(IMessagesList.Messages.cannotInstallProduct(installingProductKey, installationError.getTextErrorReport()));
        this.installationError = installationError;
        this.installingProductKey = installingProductKey;
    }

    @Nonnull
    public IProductInstallationValidationResult getInstallationError() {
        return this.installationError;
    }

    @Nonnull
    public ProductKey getInstallingProductKey() {
        return this.installingProductKey;
    }

    public String debugDescription() {
        StringBuilder sb = new StringBuilder("CannotInstallProductException [");
        sb.append("installationError=[").append(this.installationError).append(']');
        sb.append(", installingProductKey=[").append(this.installingProductKey).append(']');
        sb.append(']');
        return sb.toString();
    }
}

