/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory;

import com._1c.packaging.model.shared.Architecture;
import com._1c.packaging.model.shared.ComponentKey;
import com._1c.packaging.model.shared.ProductKey;
import com.google.common.base.Preconditions;
import java.nio.file.Path;
import javax.annotation.Nonnull;

public final class InstalledFilesLayout {
    @Nonnull
    public static Path getProductDir(Path productsHome, ProductKey productKey) {
        Preconditions.checkArgument((productsHome != null ? 1 : 0) != 0, (Object)"productsHome must not be null");
        Preconditions.checkArgument((boolean)productsHome.isAbsolute(), (String)"productsHome is not absolute: %s", (Object)productsHome);
        Preconditions.checkArgument((productKey != null ? 1 : 0) != 0, (Object)"productKey must not be null");
        String dir = productKey.getId() + "-" + productKey.getVersion();
        if (productKey.getArchitecture() != Architecture.ANYARCH) {
            dir = dir + "-" + productKey.getArchitecture().getName();
        }
        return productsHome.resolve("products").resolve(dir);
    }

    @Nonnull
    public static Path getComponentDir(Path productsHome, ComponentKey componentKey) {
        Preconditions.checkArgument((productsHome != null ? 1 : 0) != 0, (Object)"productsHome must not be null");
        Preconditions.checkArgument((boolean)productsHome.isAbsolute(), (String)"productsHome is not absolute: %s", (Object)productsHome);
        Preconditions.checkArgument((componentKey != null ? 1 : 0) != 0, (Object)"componentKey must not be null");
        String dir = componentKey.getId() + "-" + componentKey.getVersion();
        if (componentKey.getArchitecture() != Architecture.ANYARCH) {
            dir = dir + "-" + componentKey.getArchitecture().getName();
        }
        return productsHome.resolve("components").resolve(dir);
    }

    private InstalledFilesLayout() {
    }
}

