/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory;

import com._1c.packaging.inventory.IMessagesList;
import com._1c.packaging.inventory.InventoryFileFormatException;
import java.nio.file.Path;
import javax.annotation.Nonnull;

public class InvalidValueException
extends InventoryFileFormatException {
    private final String attrName;
    private final String invalidValue;

    public InvalidValueException(Path file, String attrName, String invalidValue) {
        super(file, IMessagesList.Messages.invalidValue(file, attrName, invalidValue));
        this.attrName = attrName;
        this.invalidValue = invalidValue;
    }

    public InvalidValueException(Path file, String attrName, String invalidValue, Throwable cause) {
        super(file, IMessagesList.Messages.invalidValue(file, attrName, invalidValue), cause);
        this.attrName = attrName;
        this.invalidValue = invalidValue;
    }

    @Nonnull
    public String getInvalidValue() {
        return this.invalidValue;
    }

    @Nonnull
    public String getAttrName() {
        return this.attrName;
    }

    public String debugDescription() {
        StringBuilder sb = new StringBuilder("InvalidValueException [");
        sb.append("Attribute [").append(this.attrName).append("] in file [").append(this.getFile().toString());
        sb.append("] has invalid value [").append(this.invalidValue).append("]]");
        return sb.toString();
    }
}

