/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory;

import com._1c.chassis.gears.env.IEnvironment;
import com._1c.packaging.inventory.IInventoryDefaults;
import com._1c.packaging.inventory.InventoryType;
import com._1c.packaging.inventory.internal.OsPaths;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class InventoryDefaults
implements IInventoryDefaults {
    private final IEnvironment env;

    @Inject
    public InventoryDefaults(IEnvironment env) {
        this.env = env;
    }

    @Nonnull
    public Path centralInventoryPath() {
        return new OsPaths(this.env).getCentralInventoryPath();
    }

    @Nonnull
    public Path userInventoryPath() {
        return new OsPaths(this.env).getCurrentUserInventoryPath();
    }

    @Override
    @Nonnull
    public Path centralProductsHomePath() {
        return new OsPaths(this.env).getDefaultProductsHomePath(InventoryType.CENTRAL);
    }

    @Override
    @Nonnull
    public Path userProductsHomePath() {
        return new OsPaths(this.env).getDefaultProductsHomePath(InventoryType.USER);
    }

    @Override
    @Nonnull
    public Path productsHomePath(InventoryType type) {
        return new OsPaths(this.env).getDefaultProductsHomePath(type);
    }

    @Nonnull
    public Path inventoryPath(InventoryType type) {
        OsPaths osPaths = new OsPaths(this.env);
        return type == InventoryType.CENTRAL ? osPaths.getCentralInventoryPath() : osPaths.getCurrentUserInventoryPath();
    }
}

