/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory;

import com._1c.chassis.gears.env.IEnvironment;
import com._1c.packaging.inventory.IInventory;
import com._1c.packaging.inventory.InventoryDefaults;
import com._1c.packaging.inventory.InventoryType;
import com._1c.packaging.inventory.internal.Inventory;
import com._1c.packaging.inventory.internal.InventoryLocation;
import com._1c.packaging.inventory.internal.yaml.YamlPersister;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.concurrent.NotThreadSafe;
import javax.inject.Inject;

@NotThreadSafe
public class InventoryFactory {
    private final IEnvironment env;

    @Inject
    public InventoryFactory(IEnvironment env) {
        this.env = env;
    }

    public IInventory createCentralInventory() {
        InventoryDefaults def = new InventoryDefaults(this.env);
        Path inventoryLocDir = def.centralInventoryPath().resolve("inventory.loc");
        return this.createInventoryByLocation(inventoryLocDir, InventoryType.CENTRAL);
    }

    IInventory createCurrentUserInventory() {
        InventoryDefaults def = new InventoryDefaults(this.env);
        Path inventoryLocDir = def.userInventoryPath().resolve("inventory.loc");
        return this.createInventoryByLocation(inventoryLocDir, InventoryType.USER);
    }

    public IInventory createCentralInventoryAtSpecifiedLocation(Path inventoryDir) {
        InventoryLocation loc;
        Preconditions.checkArgument((inventoryDir != null ? 1 : 0) != 0, (Object)"inventoryDir must not be null");
        InventoryType type = InventoryType.CENTRAL;
        InventoryDefaults def = new InventoryDefaults(this.env);
        Path inventoryLocDir = def.inventoryPath(type);
        Path inventoryLocFile = inventoryLocDir.resolve("inventory.loc");
        YamlPersister persister = new YamlPersister();
        if (Files.exists(inventoryLocFile, new LinkOption[0])) {
            loc = persister.loadInventoryLocation(inventoryLocDir);
            if (!inventoryDir.toAbsolutePath().normalize().equals(loc.getRootPath())) {
                loc.setRootPath(inventoryDir);
                loc.setVersion(0);
            }
        } else {
            loc = new InventoryLocation(inventoryDir, 0);
        }
        persister.saveInventoryLocationTransactionally(inventoryLocDir, loc);
        Inventory ret = new Inventory(loc.getRootPath(), inventoryLocDir, loc.getVersion(), type, persister, this.env, def);
        ret.loadVersionsList(false);
        return ret;
    }

    @VisibleForTesting
    IInventory createInventoryByLocation(Path inventoryLocFile, InventoryType type) {
        int inventoryVersion;
        Path inventoryDir;
        Preconditions.checkArgument((inventoryLocFile != null ? 1 : 0) != 0, (Object)"inventoryLocFile must not be null");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type must not be null");
        Path inventoryLocDir = inventoryLocFile.getParent();
        if (Files.exists(inventoryLocFile, new LinkOption[0])) {
            InventoryLocation location = new YamlPersister().loadInventoryLocation(inventoryLocDir);
            inventoryDir = location.getRootPath();
            inventoryVersion = location.getVersion();
        } else {
            inventoryDir = inventoryLocDir.resolve("inventory");
            inventoryVersion = 0;
        }
        Inventory ret = new Inventory(inventoryDir, inventoryLocDir, inventoryVersion, type, new YamlPersister(), this.env, new InventoryDefaults(this.env));
        ret.loadVersionsList(false);
        return ret;
    }

    @VisibleForTesting
    void createInventoryForce(Path inventoryLocDir) {
        Preconditions.checkArgument((inventoryLocDir != null ? 1 : 0) != 0, (Object)"inventoryLocDir must not be null");
        InventoryLocation loc = new InventoryLocation(inventoryLocDir.resolve("inventory"), 0);
        new YamlPersister().saveInventoryLocationTransactionally(inventoryLocDir, loc);
    }
}

