/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory;

import com._1c.packaging.inventory.IMessagesList;
import com._1c.packaging.inventory.InventoryConsistencyException;
import java.nio.file.Path;
import javax.annotation.Nonnull;

public class InventoryFileCorruptedException
extends InventoryConsistencyException {
    private final String actualSha1;
    private final String etalonSha1;

    public InventoryFileCorruptedException(Path file, String actualSha1, String etalonSha1) {
        super(file, IMessagesList.Messages.inventoryFileCorrupted(file, actualSha1, etalonSha1));
        this.actualSha1 = actualSha1;
        this.etalonSha1 = etalonSha1;
    }

    @Nonnull
    public String getActualSha1() {
        return this.actualSha1;
    }

    @Nonnull
    public String getEtalonSha1() {
        return this.etalonSha1;
    }

    public String debugDescription() {
        StringBuilder sb = new StringBuilder("InventoryFileCorruptedException [");
        sb.append("file=[").append(this.getFile()).append("] has wong checksum:");
        sb.append(" actualSha1=[").append(this.actualSha1).append(']');
        sb.append(", etalonSha1=[").append(this.etalonSha1).append(']');
        sb.append(']');
        return sb.toString();
    }
}

