/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory;

import com._1c.packaging.inventory.IMessagesList;
import com._1c.packaging.inventory.InventoryException;
import java.nio.file.Path;
import javax.annotation.Nonnull;

public class InventoryLocationLockedException
extends InventoryException {
    private final Path file;

    public InventoryLocationLockedException(Path file) {
        super(IMessagesList.Messages.inventoryLocationLocked(file));
        this.file = file.toAbsolutePath().normalize();
    }

    @Nonnull
    public Path getFile() {
        return this.file;
    }

    public String debugDescription() {
        StringBuilder sb = new StringBuilder("InventoryLocationLockedException [");
        sb.append("file=[").append(this.file).append("] is locked. Try to reacquire lately.");
        return sb.toString();
    }
}

