/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory;

import com._1c.packaging.inventory.IComponent;
import com._1c.packaging.inventory.IDistro;
import com._1c.packaging.inventory.IInstallerComponent;
import com._1c.packaging.inventory.IInventoryMeta;
import com._1c.packaging.inventory.IInventoryVersion;
import com._1c.packaging.model.shared.ComponentKey;
import com._1c.packaging.model.shared.DistroKey;
import com._1c.packaging.model.shared.ProductKey;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class InventoryVersionsDiff {
    private final ComponentKey uninstalledInstaller;
    private final ComponentKey installedInstaller;
    private final Set<DistroKey> registeredDistros;
    private final Set<DistroKey> unregisteredDistros;
    private final Map<ProductKey, Set<ComponentKey>> installedProductsToInstalledComponents;
    private final Map<ProductKey, Set<ComponentKey>> uninstalledProductsToUninstalledComponents;
    private final Map<ProductKey, Set<ComponentKey>> modifiedProductsToInstalledComponents;
    private final Map<ProductKey, Set<ComponentKey>> modifiedProductsToUninstalledComponents;

    public static InventoryVersionsDiff create(@Nullable IInventoryVersion previousVersion, @Nullable IInventoryVersion currentVersion) {
        IInstallerComponent currentInstallerComponent = null;
        HashMap<ProductKey, HashSet<ComponentKey>> currentVersionProducts = new HashMap<ProductKey, HashSet<ComponentKey>>();
        HashSet<DistroKey> currentVersionDistros = new HashSet<DistroKey>();
        if (currentVersion != null) {
            currentInstallerComponent = InventoryVersionsDiff.populateVersionDistrosAndProductsAndGetInstaller(currentVersion, currentVersionProducts, currentVersionDistros);
        }
        IInstallerComponent previousInstallerComponent = null;
        HashMap<ProductKey, HashSet<ComponentKey>> previousVersionProducts = new HashMap<ProductKey, HashSet<ComponentKey>>();
        HashSet<DistroKey> previousVersionDistros = new HashSet<DistroKey>();
        if (previousVersion != null) {
            previousInstallerComponent = InventoryVersionsDiff.populateVersionDistrosAndProductsAndGetInstaller(previousVersion, previousVersionProducts, previousVersionDistros);
        }
        ComponentKey uninstalledInstallerKey = null;
        ComponentKey installedInstallerKey = null;
        if (previousInstallerComponent == null && currentInstallerComponent != null) {
            installedInstallerKey = currentInstallerComponent.getKey();
        } else if (previousInstallerComponent != null && currentInstallerComponent == null) {
            uninstalledInstallerKey = previousInstallerComponent.getKey();
        } else if (previousInstallerComponent != null && currentInstallerComponent != null && !previousInstallerComponent.getKey().equals((Object)currentInstallerComponent.getKey())) {
            uninstalledInstallerKey = previousInstallerComponent.getKey();
            installedInstallerKey = currentInstallerComponent.getKey();
        } else {
            uninstalledInstallerKey = null;
            installedInstallerKey = null;
        }
        Set<DistroKey> registeredDistros = currentVersionDistros.stream().filter(d -> !previousVersionDistros.contains(d)).collect(Collectors.toSet());
        Set<DistroKey> unregisteredDistros = previousVersionDistros.stream().filter(d -> !currentVersionDistros.contains(d)).collect(Collectors.toSet());
        Map<ProductKey, Set<ComponentKey>> installedProductsToInstalledComponents = currentVersionProducts.entrySet().stream().filter(e -> !previousVersionProducts.keySet().contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<ProductKey, Set<ComponentKey>> uninstalledProductsToUninstalledComponents = previousVersionProducts.entrySet().stream().filter(e -> !currentVersionProducts.keySet().contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Set probablyModifiedProducts = currentVersionProducts.keySet().stream().filter(pk -> previousVersionProducts.keySet().contains(pk)).collect(Collectors.toSet());
        Set<ProductKey> modifiedProducts = probablyModifiedProducts.stream().filter(pk -> !Sets.symmetricDifference((Set)((Set)currentVersionProducts.get(pk)), (Set)((Set)previousVersionProducts.get(pk))).isEmpty()).collect(Collectors.toSet());
        HashMap<ProductKey, Set<ComponentKey>> modifiedProductsToInstalledComponents = new HashMap<ProductKey, Set<ComponentKey>>();
        modifiedProducts.forEach(pk -> modifiedProductsToInstalledComponents.put((ProductKey)pk, Sets.difference((Set)((Set)currentVersionProducts.get(pk)), (Set)((Set)previousVersionProducts.get(pk))).copyInto(new HashSet())));
        HashMap<ProductKey, Set<ComponentKey>> modifiedProductsToUninstalledComponents = new HashMap<ProductKey, Set<ComponentKey>>();
        modifiedProducts.forEach(pk -> modifiedProductsToUninstalledComponents.put((ProductKey)pk, Sets.difference((Set)((Set)previousVersionProducts.get(pk)), (Set)((Set)currentVersionProducts.get(pk))).copyInto(new HashSet())));
        return new InventoryVersionsDiff(uninstalledInstallerKey, installedInstallerKey, registeredDistros, unregisteredDistros, installedProductsToInstalledComponents, uninstalledProductsToUninstalledComponents, modifiedProductsToInstalledComponents, modifiedProductsToUninstalledComponents);
    }

    @Nullable
    private static IInstallerComponent populateVersionDistrosAndProductsAndGetInstaller(IInventoryVersion version, Map<ProductKey, HashSet<ComponentKey>> versionProducts, Set<DistroKey> versionDistros) {
        IInventoryMeta metadata = version.getMetadataUninterruptibly();
        metadata.productsStream().forEach(p -> versionProducts.put(p.getKey(), new HashSet(p.getComponents().stream().map(IComponent::getKey).collect(Collectors.toSet()))));
        metadata.distrosStream().map(IDistro::getKey).forEach(versionDistros::add);
        return metadata.getInstallerComponent().orElse(null);
    }

    private InventoryVersionsDiff(@Nullable ComponentKey uninstalledInstaller, @Nullable ComponentKey installedInstaller, Set<DistroKey> registeredDistros, Set<DistroKey> unregisteredDistros, Map<ProductKey, Set<ComponentKey>> installedProductsToInstalledComponents, Map<ProductKey, Set<ComponentKey>> uninstalledProductsToUninstalledComponents, Map<ProductKey, Set<ComponentKey>> modifiedProductsToInstalledComponents, Map<ProductKey, Set<ComponentKey>> modifiedProductsToUninstalledComponents) {
        this.uninstalledInstaller = uninstalledInstaller;
        this.installedInstaller = installedInstaller;
        this.registeredDistros = Collections.unmodifiableSet(registeredDistros);
        this.unregisteredDistros = Collections.unmodifiableSet(unregisteredDistros);
        this.installedProductsToInstalledComponents = Collections.unmodifiableMap(installedProductsToInstalledComponents);
        this.uninstalledProductsToUninstalledComponents = Collections.unmodifiableMap(uninstalledProductsToUninstalledComponents);
        this.modifiedProductsToInstalledComponents = Collections.unmodifiableMap(modifiedProductsToInstalledComponents);
        this.modifiedProductsToUninstalledComponents = Collections.unmodifiableMap(modifiedProductsToUninstalledComponents);
    }

    public Optional<ComponentKey> getUninstalledInstaller() {
        return Optional.ofNullable(this.uninstalledInstaller);
    }

    public Optional<ComponentKey> getInstalledInstaller() {
        return Optional.ofNullable(this.installedInstaller);
    }

    public Set<DistroKey> getRegisteredDistros() {
        return this.registeredDistros;
    }

    public Set<DistroKey> getUnregisteredDistros() {
        return this.unregisteredDistros;
    }

    public Map<ProductKey, Set<ComponentKey>> getInstalledProductsToInstalledComponents() {
        return this.installedProductsToInstalledComponents;
    }

    public Map<ProductKey, Set<ComponentKey>> getUninstalledProductsToUninstalledComponents() {
        return this.uninstalledProductsToUninstalledComponents;
    }

    public Map<ProductKey, Set<ComponentKey>> getModifiedProductsToInstalledComponents() {
        return this.modifiedProductsToInstalledComponents;
    }

    public Map<ProductKey, Set<ComponentKey>> getModifiedProductsToUninstalledComponents() {
        return this.modifiedProductsToUninstalledComponents;
    }
}

