/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory;

import com._1c.packaging.inventory.IFileMeta;
import com._1c.packaging.inventory.IInstalledFilesContainer;
import com._1c.packaging.inventory.IUninterruptibleFileSnapshotVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public class StateCheckReport
implements IUninterruptibleFileSnapshotVisitor {
    private final List<String> contentChanged = new ArrayList<String>();
    private final List<String> absent = new ArrayList<String>();
    private final Map<String, Exception> errors = new TreeMap<String, Exception>();
    private final IInstalledFilesContainer container;

    public StateCheckReport(IInstalledFilesContainer container) {
        this.container = container;
    }

    @Override
    public void visit(String pathName, IFileMeta meta) {
        try {
            Optional<String> sha1 = this.container.getActualFileSha1Uninterruptibly(pathName);
            if (sha1.isPresent()) {
                if (!sha1.get().equals(meta.getSha1())) {
                    this.contentChanged.add(pathName);
                }
            } else {
                this.absent.add(pathName);
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                this.errors.put(pathName, new UnsupportedOperationException("Developer error: InterruptedException is not expected here", e));
            }
            this.errors.put(pathName, e);
        }
    }

    public boolean isAllFilesOk() {
        return this.contentChanged.isEmpty() && this.errors.isEmpty();
    }

    public Map<String, Exception> getErrors() {
        return Collections.unmodifiableMap(this.errors);
    }

    public List<String> getFilesWithContentChanged() {
        return Collections.unmodifiableList(this.contentChanged);
    }

    public List<String> getAbsentFiles() {
        return Collections.unmodifiableList(this.absent);
    }
}

