/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com._1c.chassis.gears.digest.FileDigester;
import com._1c.packaging.inventory.IComponent;
import com._1c.packaging.inventory.IInstallerComponent;
import com._1c.packaging.inventory.IProduct;
import com._1c.packaging.inventory.InventoryAccessDeniedException;
import com._1c.packaging.inventory.InventoryFileCorruptedException;
import com._1c.packaging.inventory.InventoryFileDoesNotExistException;
import com._1c.packaging.inventory.InventoryFileIoException;
import com._1c.packaging.inventory.internal.FilesSnapshot;
import com._1c.packaging.inventory.internal.IMessagesList;
import com._1c.packaging.inventory.internal.IPersister;
import com._1c.packaging.inventory.internal.InventoryLocation;
import com._1c.packaging.inventory.internal.InventoryMeta;
import com._1c.packaging.inventory.internal.InventoryVersion;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

class CheckingPersister
implements IPersister {
    private final IPersister adaptee;
    private final FilesSnapshot snapshot;
    private final Path versionRoot;

    CheckingPersister(IPersister adaptee, FilesSnapshot snapshot, Path versionRoot) {
        Preconditions.checkArgument((adaptee != null ? 1 : 0) != 0, (Object)"adaptee must not be null");
        Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (Object)"snapshot must not be null");
        Preconditions.checkArgument((versionRoot != null ? 1 : 0) != 0, (Object)"versionRoot must not be null");
        this.adaptee = adaptee;
        this.snapshot = snapshot;
        this.versionRoot = versionRoot;
    }

    @Override
    @Nonnull
    public InventoryLocation loadInventoryLocation(Path inventoryLocDir) {
        return this.adaptee.loadInventoryLocation(inventoryLocDir);
    }

    @Override
    public void saveInventoryLocationTransactionally(Path inventoryLocPath, InventoryLocation il) {
        this.adaptee.saveInventoryLocationTransactionally(inventoryLocPath, il);
    }

    @Override
    public void loadMeta(InventoryMeta im, Path file) throws InterruptedException {
        if (!Files.exists(file, new LinkOption[0])) {
            throw new InventoryFileDoesNotExistException(file);
        }
        this.checkSignature(file, true);
        this.checkInterruption(IMessagesList.Messages.metaLoadInterrupted());
        this.adaptee.loadMeta(im, file);
    }

    @Override
    public void loadMetaUninterruptibly(InventoryMeta im, Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            throw new InventoryFileDoesNotExistException(file);
        }
        this.checkSignature(file, false);
        this.adaptee.loadMetaUninterruptibly(im, file);
    }

    @Override
    public void loadDescriptions(InventoryMeta im, Path file, String lang) throws InterruptedException {
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        this.checkSignature(file, true);
        this.checkInterruption(IMessagesList.Messages.descriptionsLoadInterrupted());
        this.adaptee.loadDescriptions(im, file, lang);
    }

    @Override
    public void loadDescriptionsUninterruptibly(InventoryMeta im, Path file, String lang) {
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        this.checkSignature(file, false);
        this.adaptee.loadDescriptionsUninterruptibly(im, file, lang);
    }

    @Override
    public void saveComponentsAttributes(Set<IComponent> components, InventoryMeta im) throws InterruptedException {
        this.adaptee.saveComponentsAttributes(components, im);
        this.checkInterruption(IMessagesList.Messages.componentAttributesSaveInterrupted());
    }

    @Override
    public void saveComponentsAttributesUninterruptibly(Set<IComponent> components, InventoryMeta im) {
        this.adaptee.saveComponentsAttributesUninterruptibly(components, im);
    }

    @Override
    public void saveMeta(InventoryMeta im) {
        this.adaptee.saveMeta(im);
    }

    @Override
    public void saveDescriptions(InventoryMeta im, String lang) {
        this.adaptee.saveDescriptions(im, lang);
    }

    @Override
    public void saveComponentsSnapshot(Set<IComponent> components, InventoryMeta im) throws InterruptedException {
        this.adaptee.saveComponentsSnapshot(components, im);
    }

    @Override
    public void saveComponentsSnapshotUninterruptibly(Set<IComponent> components, InventoryMeta im) {
        this.adaptee.saveComponentsSnapshotUninterruptibly(components, im);
    }

    @Override
    public void saveInstallerComponentSnapshot(IInstallerComponent installerComponent, InventoryMeta meta) throws InterruptedException {
        this.adaptee.saveInstallerComponentSnapshot(installerComponent, meta);
    }

    @Override
    public void saveInstallerComponentSnapshotUninterruptibly(IInstallerComponent installerComponent, InventoryMeta meta) {
        this.adaptee.saveInstallerComponentSnapshotUninterruptibly(installerComponent, meta);
    }

    @Override
    public void saveInstallerComponentsAttributes(IInstallerComponent installerComponent, InventoryMeta meta) throws InterruptedException {
        this.adaptee.saveInstallerComponentsAttributes(installerComponent, meta);
    }

    @Override
    public void saveInstallerComponentsAttributesUninterruptibly(IInstallerComponent installerComponent, InventoryMeta meta) {
        this.adaptee.saveInstallerComponentsAttributesUninterruptibly(installerComponent, meta);
    }

    @Override
    public void loadComponentSnapshot(InventoryMeta im, Path file) throws InterruptedException {
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        this.checkSignature(file, true);
        this.checkInterruption(IMessagesList.Messages.componentsSnapshotLoadInterrupted());
        this.adaptee.loadComponentSnapshot(im, file);
    }

    @Override
    public void loadComponentSnapshotUninterruptibly(InventoryMeta im, Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        this.checkSignature(file, true);
        this.adaptee.loadComponentSnapshotUninterruptibly(im, file);
    }

    @Override
    public void loadComponentsAttributes(InventoryMeta im, Path file) throws InterruptedException {
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        this.checkSignature(file, true);
        this.checkInterruption(IMessagesList.Messages.componentsAttributesLoadInterrupted());
        this.adaptee.loadComponentsAttributes(im, file);
    }

    @Override
    public void loadComponentsAttributesUninterruptibly(InventoryMeta im, Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        this.checkSignature(file, true);
        this.adaptee.loadComponentsAttributesUninterruptibly(im, file);
    }

    @Override
    public void saveProductsSnapshot(Set<IProduct> products, Path file) throws InterruptedException {
        this.adaptee.saveProductsSnapshot(products, file);
    }

    @Override
    public void saveProductsSnapshotUninterruptibly(Set<IProduct> products, Path file) {
        this.adaptee.saveProductsSnapshotUninterruptibly(products, file);
    }

    @Override
    public void loadProductsSnapshot(InventoryMeta im, Path file) throws InterruptedException {
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        this.checkSignature(file, true);
        this.checkInterruption(IMessagesList.Messages.productSnapshotLoadInterrupted());
        this.adaptee.loadProductsSnapshot(im, file);
    }

    @Override
    public void loadProductsSnapshotUninterruptibly(InventoryMeta im, Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        this.checkSignature(file, true);
        this.adaptee.loadProductsSnapshotUninterruptibly(im, file);
    }

    @Override
    public void saveInventorySnapshot(Map<Path, String> crcs, InventoryVersion iv) {
        this.adaptee.saveInventorySnapshot(crcs, iv);
    }

    @Override
    public void loadInventorySnapshot(Path file, FilesSnapshot snapshot) {
        throw new UnsupportedOperationException("One cannot load snapshot via a Checking adapter");
    }

    private void checkSignature(Path file, boolean interruptible) {
        if (!this.snapshot.isEmpty()) {
            String actualSha1;
            String sha1;
            block8: {
                String relativePath = this.versionRoot.relativize(file).toString();
                sha1 = this.snapshot.getSha1(relativePath).orElseThrow(() -> new InventoryFileDoesNotExistException(file));
                try {
                    if (interruptible) {
                        try {
                            actualSha1 = new FileDigester().digestFile(file);
                            break block8;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                    actualSha1 = new FileDigester().digestFileUninterruptibly(file);
                }
                catch (AccessDeniedException e) {
                    throw new InventoryAccessDeniedException(file, (Throwable)e);
                }
                catch (IOException e) {
                    throw new InventoryFileIoException(file, e);
                }
            }
            if (!actualSha1.equals(sha1)) {
                throw new InventoryFileCorruptedException(file, actualSha1, sha1);
            }
        }
    }

    private void checkInterruption(String message) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException(message);
        }
    }
}

