/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com._1c.chassis.gears.bytesize.ByteSize;
import com._1c.chassis.gears.versions.SemanticVersion;
import com._1c.packaging.inventory.FileType;
import com._1c.packaging.inventory.IComponent;
import com._1c.packaging.inventory.IFileSnapshotVisitor;
import com._1c.packaging.inventory.IInstalledShortcutsVisitor;
import com._1c.packaging.inventory.IMutableComponent;
import com._1c.packaging.inventory.IProduct;
import com._1c.packaging.inventory.IUninterruptibleFileSnapshotVisitor;
import com._1c.packaging.inventory.InclusionType;
import com._1c.packaging.inventory.RingModuleInfo;
import com._1c.packaging.inventory.internal.ComponentData;
import com._1c.packaging.inventory.internal.Localization;
import com._1c.packaging.model.shared.Architecture;
import com._1c.packaging.model.shared.ComponentKey;
import com._1c.packaging.model.shared.OsType;
import com._1c.packaging.model.shared.ProductKey;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Component
implements IComponent,
IMutableComponent {
    private final ComponentKey key;
    private final IProduct product;
    private final ComponentData data;
    private final boolean required;
    private String groupName;

    Component(ComponentKey componentKey, IProduct product, ComponentData data, boolean required) {
        Preconditions.checkArgument((componentKey != null ? 1 : 0) != 0, (Object)"componentKey must not be null");
        Preconditions.checkArgument((product != null ? 1 : 0) != 0, (Object)"product must not be null");
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"data must not be null");
        this.key = componentKey;
        this.product = product;
        this.data = data;
        this.required = required;
    }

    @Nonnull
    public Localization getLocalization() {
        return this.data.localization();
    }

    @Override
    @Nonnull
    public ProductKey getProductKey() {
        return this.product.getKey();
    }

    @Override
    @Nonnull
    public ComponentKey getKey() {
        return this.key;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.key.getId();
    }

    @Override
    @Nonnull
    public SemanticVersion getVersion() {
        return this.key.getVersion();
    }

    @Override
    @Nonnull
    public OsType getOs() {
        return this.key.getOsType();
    }

    @Override
    @Nonnull
    public Architecture getArch() {
        return this.key.getArchitecture();
    }

    @Override
    @Nonnull
    public InclusionType getInclusionType() {
        return this.data.inclusionType();
    }

    @Override
    @Nonnull
    public ByteSize getSize() {
        return this.data.getSize();
    }

    @Override
    @Nonnull
    public Optional<String> getGroupId() {
        return Optional.ofNullable(this.groupName);
    }

    @Override
    @Nonnull
    public String getGroupName(String locale) {
        return this.data.localization().get(locale, "group-name", "");
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    @Nonnull
    public Collection<IComponent> getDependencies() {
        return Collections.unmodifiableCollection(this.data.dependencies().values());
    }

    @Override
    @Nonnull
    public List<RingModuleInfo> getRingModules() {
        return this.data.getRingModules();
    }

    @Override
    public void setRingModules(List<RingModuleInfo> ringModules) {
        this.data.setRingModules(ringModules);
    }

    @Override
    public boolean dependsOn(ComponentKey componentKey) {
        return this.data.dependencies().containsKey(componentKey);
    }

    @Override
    @Nonnull
    public String getName(String locale) {
        return this.data.localization().get(locale, "name", this.key.getId());
    }

    @Override
    @Nonnull
    public String getDescription(String locale) {
        return this.data.localization().get(locale, "description", "");
    }

    @Override
    @Nonnull
    public String getHomeUrl(String locale) {
        return this.data.localization().get(locale, "home-url", this.product.getHomeUrl(locale));
    }

    @Override
    public void setPaths(List<Path> paths) {
        this.data.setPaths(paths);
    }

    @Override
    public void setGroupName(@Nullable String groupName) {
        this.groupName = groupName;
    }

    @Override
    @Nonnull
    public List<Path> getPaths() {
        return this.data.getPaths();
    }

    @Override
    @Nonnull
    public String getVendor(String locale) {
        return this.data.localization().get(locale, "vendor", "");
    }

    @Override
    public void addFileMeta(String pathName, String sha1, FileType type, boolean modifiable) {
        this.data.installedFiles().addFileMeta(pathName, sha1, type, modifiable);
    }

    @Override
    public void addShortcutFileMeta(String knownFolderAbsolutePath, String relativePath) {
        this.data.addShortcut(knownFolderAbsolutePath, relativePath);
    }

    @Override
    public void snapshotAction(IFileSnapshotVisitor visitor) throws InterruptedException {
        this.data.installedFiles().snapshotAction(visitor);
    }

    @Override
    public void snapshotActionUninterruptibly(IUninterruptibleFileSnapshotVisitor visitor) {
        this.data.installedFiles().snapshotActionUninterruptibly(visitor);
    }

    @Override
    public void forEachShortcut(IInstalledShortcutsVisitor visitor) {
        this.data.forEachShortcut(visitor);
    }

    @Override
    public boolean hasShortcuts() {
        return this.data.hasShortcuts();
    }

    @Override
    @Nonnull
    public Optional<String> getActualFileSha1(String relativeFilePathName) throws InterruptedException {
        return this.data.installedFiles().getActualFileSha1(relativeFilePathName);
    }

    @Override
    @Nonnull
    public Optional<String> getActualFileSha1Uninterruptibly(String relativeFilePathName) {
        return this.data.installedFiles().getActualFileSha1Uninterruptibly(relativeFilePathName);
    }

    @Override
    public void addLocalization(String locale, String name, @Nullable String text) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)locale) ? 1 : 0) != 0, (Object)"locale must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name must not be null or empty");
        this.data.localization().set(locale, name, text);
    }

    @Override
    public void setNameLocalization(String locale, @Nullable String text) {
        this.addLocalization(locale, "name", text);
    }

    @Override
    public void setDescriptionLocalization(String locale, @Nullable String text) {
        this.addLocalization(locale, "description", text);
    }

    @Override
    public void setHomeUrlLocalization(String locale, @Nullable String text) {
        this.addLocalization(locale, "home-url", text);
    }

    @Override
    public void setVendorLocalization(String locale, @Nullable String text) {
        this.addLocalization(locale, "vendor", text);
    }

    @Override
    public void setGroupNameLocalization(String locale, @Nullable String text) {
        this.addLocalization(locale, "group-name", text);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Component [");
        sb.append("uid=[").append(this.key).append(']');
        sb.append(", inclusionType=[").append((Object)this.data.inclusionType()).append(']');
        sb.append(", groupName=[").append(this.groupName).append(']');
        StringJoiner deps = new StringJoiner(";");
        this.data.dependencies().keySet().forEach(dependencyKey -> deps.add(dependencyKey.toString()));
        sb.append(", dependencies=[").append(deps.toString()).append(']');
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void addDependencyIfAbsent(IMutableComponent component) {
        Preconditions.checkArgument((component != null ? 1 : 0) != 0, (Object)"component must not be null");
        Preconditions.checkArgument((boolean)component.view().getProductKey().equals((Object)this.product.getKey()), (String)"component %s does not belong to product %s", (Object)component.view().getKey(), (Object)this.product.getKey());
        Component newDep = (Component)component;
        this.data.dependencies().putIfAbsent(newDep.getKey(), newDep);
    }

    @Override
    public void removeDependencyIfPresent(IMutableComponent component) {
        Preconditions.checkArgument((component != null ? 1 : 0) != 0, (Object)"component must not be null");
        this.data.dependencies().remove(component.view().getKey());
    }

    @Override
    public void clearDependencies() {
        this.data.dependencies().clear();
    }

    @Override
    public IComponent view() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Component component = (Component)o;
        return this.key.equals((Object)component.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

