/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com._1c.chassis.gears.bytesize.ByteSize;
import com._1c.packaging.inventory.IInstalledShortcutsVisitor;
import com._1c.packaging.inventory.InclusionType;
import com._1c.packaging.inventory.InstalledFilesLayout;
import com._1c.packaging.inventory.RingModuleInfo;
import com._1c.packaging.inventory.internal.Component;
import com._1c.packaging.inventory.internal.IPersistentData;
import com._1c.packaging.inventory.internal.InstalledFilesContainerMixin;
import com._1c.packaging.inventory.internal.InstalledShortcut;
import com._1c.packaging.inventory.internal.InventoryVersion;
import com._1c.packaging.inventory.internal.Localization;
import com._1c.packaging.model.shared.ComponentKey;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;

class ComponentData
implements IPersistentData {
    private final ComponentKey key;
    private final InclusionType inclusionType;
    private final Map<ComponentKey, Component> dependencies = new LinkedHashMap<ComponentKey, Component>();
    private final Localization localization = new Localization();
    private final InstalledFilesContainerMixin installedFiles;
    private final Map<String, InstalledShortcut> shortcuts = new TreeMap<String, InstalledShortcut>();
    private final InventoryVersion inventoryVersion;
    private List<Path> paths;
    private List<RingModuleInfo> ringModules;
    private final ByteSize size;

    ComponentData(ComponentKey componentKey, InclusionType inclusionType, InventoryVersion inventoryVersion, ByteSize size) {
        Preconditions.checkArgument((componentKey != null ? 1 : 0) != 0, (Object)"componentKey must not be null");
        Preconditions.checkArgument((inclusionType != null ? 1 : 0) != 0, (Object)"inclusionType must not be null");
        Preconditions.checkArgument((inventoryVersion != null ? 1 : 0) != 0, (Object)"inventoryVersion must not be null");
        Preconditions.checkArgument((size != null ? 1 : 0) != 0, (Object)"size must not be null");
        this.key = componentKey;
        this.inclusionType = inclusionType;
        this.inventoryVersion = inventoryVersion;
        this.installedFiles = new InstalledFilesContainerMixin(this::resolveComponentFile);
        this.size = size;
    }

    @Nonnull
    InclusionType inclusionType() {
        return this.inclusionType;
    }

    @Nonnull
    Map<ComponentKey, Component> dependencies() {
        return this.dependencies;
    }

    @Nonnull
    Localization localization() {
        return this.localization;
    }

    @Nonnull
    InstalledFilesContainerMixin installedFiles() {
        return this.installedFiles;
    }

    void addShortcut(String knownFolderAbsolutePath, String relativePath) {
        InstalledShortcut s = new InstalledShortcut(knownFolderAbsolutePath, relativePath);
        this.shortcuts.put(s.getIdentifier(), s);
    }

    void forEachShortcut(IInstalledShortcutsVisitor visitor) {
        this.shortcuts.values().forEach(s -> visitor.visit(s.getKnownFolderName(), s.getRelativePath()));
    }

    boolean hasShortcuts() {
        return !this.shortcuts.isEmpty();
    }

    void setPaths(List<Path> paths) {
        Preconditions.checkArgument((paths != null ? 1 : 0) != 0, (Object)"paths must be not null");
        ArrayList<Path> normalizedPaths = new ArrayList<Path>();
        for (Path path : paths) {
            normalizedPaths.add(path.normalize());
        }
        this.paths = ImmutableList.copyOf(normalizedPaths);
    }

    @Nonnull
    List<Path> getPaths() {
        if (this.paths == null) {
            this.paths = Collections.emptyList();
        }
        return this.paths;
    }

    @Nonnull
    List<RingModuleInfo> getRingModules() {
        if (this.ringModules == null) {
            this.ringModules = Collections.emptyList();
        }
        return this.ringModules;
    }

    void setRingModules(List<RingModuleInfo> ringModules) {
        Preconditions.checkArgument((ringModules != null ? 1 : 0) != 0, (Object)"ringModules must be not null");
        this.ringModules = ImmutableList.copyOf(ringModules);
    }

    @Nonnull
    ByteSize getSize() {
        return this.size;
    }

    @Override
    public void deleteData() {
        this.inventoryVersion.getMutableMetadata().clearComponentVersionData(this.key);
    }

    private Path resolveComponentFile(String relativeFilePathName) {
        try {
            Path productsHome = this.inventoryVersion.getMetadata().getProductsHome();
            return InstalledFilesLayout.getComponentDir(productsHome, this.key).resolve(relativeFilePathName);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
    }
}

