/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com._1c.chassis.gears.env.IEnvironment;
import com._1c.chassis.gears.env.OsType;
import com._1c.packaging.inventory.IComponent;
import com._1c.packaging.inventory.IComponentInstallationValidationResult;
import com._1c.packaging.inventory.IMutableComponent;
import com._1c.packaging.inventory.InclusionType;
import com._1c.packaging.inventory.internal.IMessagesList;
import com._1c.packaging.inventory.internal.InventoryMeta;
import com._1c.packaging.inventory.internal.TargetArchitectureRule;
import com._1c.packaging.inventory.internal.TargetOsRule;
import com._1c.packaging.model.shared.Architecture;
import com._1c.packaging.model.shared.ComponentKey;
import com._1c.packaging.model.shared.ProductKey;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ComponentInstallationValidator {
    private final IEnvironment env;
    private final TargetOsRule targetOsRule;
    private final TargetArchitectureRule targetArchitectureRule;

    ComponentInstallationValidator(IEnvironment env) {
        this.env = env;
        this.targetOsRule = new TargetOsRule(env);
        this.targetArchitectureRule = new TargetArchitectureRule(env);
    }

    IComponentInstallationValidationResult canInstallComponent(InventoryMeta meta, ProductKey productKey, ComponentKey componentKey, IMutableComponent.IRequiredAttributes attributes) {
        boolean componentIdProhibited = componentKey.getId().equals("1c-enterprise-installer");
        List componentsWithSameId = meta.componentsStream().filter(c -> c.getId().equals(componentKey.getId())).collect(Collectors.toList());
        IComponent duplicate = componentsWithSameId.stream().filter(c -> c.getProductKey().equals((Object)productKey)).filter(c -> c.getVersion().equals((Object)componentKey.getVersion()) && c.getOs().equals((Object)componentKey.getOsType()) && c.getArch().equals((Object)componentKey.getArchitecture())).findAny().orElse(null);
        boolean wrongOs = !this.targetOsRule.satisfied(componentKey.getOsType());
        boolean wrongArch = !this.targetArchitectureRule.satisfied(componentKey.getArchitecture());
        Predicate<IComponent> anyAndSpecArchFilter = c -> c.getArch().equals((Object)Architecture.ANYARCH) && !componentKey.getArchitecture().equals((Object)Architecture.ANYARCH) || !c.getArch().equals((Object)Architecture.ANYARCH) && componentKey.getArchitecture().equals((Object)Architecture.ANYARCH);
        IComponent anyAndSpecArch = componentsWithSameId.stream().filter(c -> c.getVersion().equals((Object)componentKey.getVersion())).filter(anyAndSpecArchFilter).findAny().orElse(null);
        Predicate<IComponent> anyAndSpecOsFilter = c -> c.getOs().equals((Object)com._1c.packaging.model.shared.OsType.ANYOS) && !componentKey.getOsType().equals((Object)com._1c.packaging.model.shared.OsType.ANYOS) || !c.getOs().equals((Object)com._1c.packaging.model.shared.OsType.ANYOS) && componentKey.getOsType().equals((Object)com._1c.packaging.model.shared.OsType.ANYOS);
        IComponent anyAndSpecOs = componentsWithSameId.stream().filter(c -> c.getVersion().equals((Object)componentKey.getVersion())).filter(anyAndSpecOsFilter).findAny().orElse(null);
        List<IComponent> multiversionConflict = attributes.getInclusionType() == InclusionType.MULTIVERSION ? componentsWithSameId.stream().filter(c -> c.getProductKey().equals((Object)productKey)).filter(c -> c.getOs().equals((Object)componentKey.getOsType())).filter(c -> c.getArch().equals((Object)componentKey.getArchitecture())).filter(c -> !c.getVersion().equals((Object)componentKey.getVersion())).filter(c -> c.getInclusionType() != InclusionType.MULTIVERSION).collect(Collectors.toList()) : (attributes.getInclusionType() == InclusionType.SINGLETON ? Collections.emptyList() : componentsWithSameId.stream().filter(c -> c.getProductKey().equals((Object)productKey)).filter(c -> !c.getVersion().equals((Object)componentKey.getVersion())).collect(Collectors.toList()));
        return new ComponentInstallationValidationResultImpl(duplicate, wrongOs, wrongArch, anyAndSpecArch, anyAndSpecOs, multiversionConflict, componentIdProhibited, componentKey, this.env.getOsType());
    }

    private static final class ComponentInstallationValidationResultImpl
    implements IComponentInstallationValidationResult {
        private final IComponent duplicate;
        private final boolean wrongOs;
        private final boolean wrongArch;
        private final IComponent anyAndSpecArch;
        private final IComponent anyAndSpecOs;
        private final List<IComponent> multiversionConflict;
        private final boolean componentIdProhibited;
        private final ComponentKey installingComponent;
        private final OsType osType;

        ComponentInstallationValidationResultImpl(@Nullable IComponent duplicate, boolean wrongOs, boolean wrongArch, @Nullable IComponent anyAndSpecArch, @Nullable IComponent anyAndSpecOs, List<IComponent> multiversionConflict, boolean componentIdProhibited, ComponentKey installingComponent, OsType osType) {
            this.duplicate = duplicate;
            this.wrongOs = wrongOs;
            this.wrongArch = wrongArch;
            this.anyAndSpecArch = anyAndSpecArch;
            this.anyAndSpecOs = anyAndSpecOs;
            this.multiversionConflict = ImmutableList.copyOf(multiversionConflict);
            this.componentIdProhibited = componentIdProhibited;
            this.installingComponent = installingComponent;
            this.osType = osType;
        }

        @Override
        @Nonnull
        public Optional<IComponent> getDuplicate() {
            return Optional.ofNullable(this.duplicate);
        }

        @Override
        public boolean isWrongOs() {
            return this.wrongOs;
        }

        @Override
        public boolean isWrongArch() {
            return this.wrongArch;
        }

        @Override
        @Nonnull
        public Optional<IComponent> getAnyAndSpecArch() {
            return Optional.ofNullable(this.anyAndSpecArch);
        }

        @Override
        @Nonnull
        public Optional<IComponent> getAnyAndSpecOs() {
            return Optional.ofNullable(this.anyAndSpecOs);
        }

        @Override
        @Nonnull
        public List<IComponent> getVersionConflictingComponents() {
            return this.multiversionConflict;
        }

        @Override
        public boolean isComponentIdProhibited() {
            return this.componentIdProhibited;
        }

        @Override
        public boolean isInstallationOk() {
            return this.duplicate == null && !this.wrongOs && !this.wrongArch && this.anyAndSpecArch == null && this.anyAndSpecOs == null && this.multiversionConflict.isEmpty() && !this.componentIdProhibited;
        }

        @Override
        @Nonnull
        public String getTextErrorReport() {
            if (this.isInstallationOk()) {
                return IMessagesList.Messages.ok();
            }
            ArrayList<String> messages = new ArrayList<String>();
            if (this.duplicate != null) {
                messages.add(IMessagesList.Messages.sameComponentAlreadyInstalled(this.duplicate.getKey()));
            }
            if (this.wrongOs) {
                com._1c.packaging.model.shared.OsType currentOs = com._1c.packaging.model.shared.OsType.fromGears((OsType)this.osType);
                messages.add(IMessagesList.Messages.cannotInstallOnOsOtherThenCurrentMachine(currentOs.getDisplayName()));
            }
            if (this.wrongArch) {
                messages.add(IMessagesList.Messages.cannotInstallOnArchMismatch());
            }
            if (this.anyAndSpecOs != null) {
                messages.add(IMessagesList.Messages.cannotInstallAnyAndSpecialOsAtOnce(this.anyAndSpecOs.getOs().getDisplayName()));
            }
            if (this.anyAndSpecArch != null) {
                messages.add(IMessagesList.Messages.cannotInstallAnyAndSpecialArchAtOnce(this.anyAndSpecArch.getArch().getName()));
            }
            if (!this.multiversionConflict.isEmpty()) {
                String keys = this.multiversionConflict.stream().map(c -> c.getKey().toString()).collect(Collectors.joining(", "));
                messages.add(IMessagesList.Messages.componentVersionsConflict(this.installingComponent, keys));
            }
            if (this.componentIdProhibited) {
                messages.add(IMessagesList.Messages.componentIdProhibited(this.installingComponent.getId()));
            }
            Preconditions.checkState((!messages.isEmpty() ? 1 : 0) != 0, (String)"Error report problem. Report state is %s", (Object)this);
            return messages.stream().collect(Collectors.joining(System.lineSeparator()));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ComponentInstallationValidationResultImpl [");
            sb.append("installationOk=[").append(this.isInstallationOk()).append(']');
            sb.append(", duplicate=[").append(this.duplicate).append(']');
            sb.append(", wrongOs=[").append(this.wrongOs).append(']');
            sb.append(", wrongArch=[").append(this.wrongArch).append(']');
            sb.append(", anyAndSpecArch=[").append(this.anyAndSpecArch).append(']');
            sb.append(", anyAndSpecOs=[").append(this.anyAndSpecOs).append(']');
            sb.append(']');
            return sb.toString();
        }
    }
}

