/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com._1c.chassis.gears.bytesize.ByteSize;
import com._1c.packaging.inventory.IMutableComponent;
import com._1c.packaging.inventory.InclusionType;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class ComponentRequiredAttributes
implements IMutableComponent.IRequiredAttributes {
    private final InclusionType inclusionType;
    private final boolean required;
    private final ByteSize size;

    ComponentRequiredAttributes(InclusionType inclusionType, boolean required, ByteSize size) {
        this.inclusionType = inclusionType;
        this.required = required;
        this.size = size;
    }

    @Override
    @Nonnull
    public InclusionType getInclusionType() {
        return this.inclusionType;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public ByteSize getSize() {
        return this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ComponentAttributes [");
        sb.append("inclusionType=[").append((Object)this.inclusionType).append(']');
        sb.append(", required=[").append(this.required).append(']');
        sb.append(", size=[").append(this.size).append(']');
        sb.append(']');
        return sb.toString();
    }

    public static class ComponentRequiredAttributesBuilder
    implements IMutableComponent.IRequiredAttributesBuilder {
        private InclusionType inclusionType;
        private boolean required;
        private ByteSize size;

        @Override
        @Nonnull
        public IMutableComponent.IRequiredAttributesBuilder inclusionType(InclusionType type) {
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"inclusionType must not be null");
            this.inclusionType = type;
            return this;
        }

        @Override
        @Nonnull
        public IMutableComponent.IRequiredAttributesBuilder required(boolean required) {
            this.required = required;
            return this;
        }

        @Override
        @Nonnull
        public IMutableComponent.IRequiredAttributesBuilder size(ByteSize size) {
            Preconditions.checkArgument((size != null ? 1 : 0) != 0, (Object)"size must not be null");
            this.size = size;
            return this;
        }

        @Override
        @Nonnull
        public IMutableComponent.IRequiredAttributes build() {
            Preconditions.checkState((this.inclusionType != null ? 1 : 0) != 0, (Object)"inclusionType must not be null");
            Preconditions.checkState((this.size != null ? 1 : 0) != 0, (Object)"size must not be null");
            return new ComponentRequiredAttributes(this.inclusionType, this.required, this.size);
        }
    }
}

