/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DirectoryUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryUtils.class);

    public static void deleteEmptyDirectories(Path start, Path root) throws IOException {
        Path p = start;
        while (p.startsWith(root)) {
            if (Files.exists(p, new LinkOption[0])) {
                try (Stream<Path> content = Files.list(p);){
                    Optional<Path> any = content.findAny();
                    if (any.isPresent()) break;
                    Files.delete(p);
                }
            }
            p = p.getParent();
        }
    }

    public static void copyDirectories(final Path source, final Path target, final Set<String> excludedFileNames) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                LOGGER.debug("Creating directory: {}", (Object)dir);
                Files.createDirectories(target.resolve(source.relativize(dir)), new FileAttribute[0]);
                LOGGER.debug("Status: {}", (Object)Files.exists(dir, new LinkOption[0]));
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!excludedFileNames.contains(file.getFileName().toString())) {
                    Path tgt = target.resolve(source.relativize(file));
                    Files.copy(file, tgt, new CopyOption[0]);
                    LOGGER.debug("File copied: {} -> {} ({})", new Object[]{file, tgt, Files.exists(tgt, new LinkOption[0])});
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private DirectoryUtils() {
    }
}

