/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com._1c.chassis.gears.env.IEnvironment;
import com._1c.chassis.gears.versions.SemanticVersion;
import com._1c.packaging.inventory.CannotInstallProductException;
import com._1c.packaging.inventory.IDistro;
import com._1c.packaging.inventory.IDistroSource;
import com._1c.packaging.inventory.IMutableDistro;
import com._1c.packaging.inventory.IMutableProduct;
import com._1c.packaging.inventory.IProduct;
import com._1c.packaging.inventory.IProductInstallationValidationResult;
import com._1c.packaging.inventory.InventoryStructureException;
import com._1c.packaging.inventory.internal.InventoryVersion;
import com._1c.packaging.inventory.internal.Localization;
import com._1c.packaging.inventory.internal.Product;
import com._1c.packaging.inventory.internal.ProductData;
import com._1c.packaging.inventory.internal.ProductInstallationValidator;
import com._1c.packaging.model.shared.Architecture;
import com._1c.packaging.model.shared.DistroKey;
import com._1c.packaging.model.shared.OsType;
import com._1c.packaging.model.shared.ProductKey;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Distro
implements IDistro,
IMutableDistro {
    private final DistroKey key;
    private final InventoryVersion inventoryVersion;
    private final Map<ProductKey, Product> products = new LinkedHashMap<ProductKey, Product>();
    private final Localization localization = new Localization();
    private final ProductInstallationValidator validator;
    private final IEnvironment env;
    private IDistroSource source;

    Distro(DistroKey distroKey, InventoryVersion inventoryVersion, IEnvironment env) {
        Preconditions.checkArgument((distroKey != null ? 1 : 0) != 0, (Object)"distroKey must not be null");
        Preconditions.checkArgument((inventoryVersion != null ? 1 : 0) != 0, (Object)"inventoryVersion must not be null");
        Preconditions.checkArgument((env != null ? 1 : 0) != 0, (Object)"env must not be null");
        this.key = distroKey;
        this.inventoryVersion = inventoryVersion;
        this.validator = new ProductInstallationValidator(env);
        this.env = env;
    }

    public Localization getLocalization() {
        return this.localization;
    }

    @Override
    @Nonnull
    public DistroKey getKey() {
        return this.key;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.key.getId();
    }

    @Override
    @Nonnull
    public SemanticVersion getVersion() {
        return this.key.getVersion();
    }

    @Override
    @Nonnull
    public OsType getOs() {
        return this.key.getOsType();
    }

    @Override
    @Nonnull
    public Architecture getArch() {
        return this.key.getArchitecture();
    }

    @Override
    @Nullable
    public IDistroSource getSource() {
        return this.source;
    }

    @Override
    public void setSource(@Nullable IDistroSource source) {
        this.source = source;
    }

    @Override
    public IMutableProduct installProductIfAbsent(ProductKey productKey, IMutableProduct.IRequiredAttributes attributes) throws InventoryStructureException {
        Preconditions.checkArgument((productKey != null ? 1 : 0) != 0, (Object)"productKey must not be null");
        Preconditions.checkArgument((attributes != null ? 1 : 0) != 0, (Object)"attributes must not be null");
        Product ret = this.products.get(productKey);
        if (ret == null) {
            IProductInstallationValidationResult result = this.canInstallProduct(productKey, attributes);
            if (result.isInstallationOk()) {
                ret = this.addProduct(productKey, attributes);
            } else {
                throw new CannotInstallProductException(result, productKey);
            }
        }
        return ret;
    }

    public Product addProduct(ProductKey productKey, IMutableProduct.IRequiredAttributes attributes) {
        Preconditions.checkArgument((productKey != null ? 1 : 0) != 0, (Object)"productKey must not be null");
        ProductData productData = this.inventoryVersion.getMutableMetadata().acquireProductData(productKey, attributes);
        Product product = new Product(productKey, this, this.inventoryVersion, this.env, productData);
        this.products.put(productKey, product);
        return product;
    }

    @Override
    public Optional<IMutableProduct> getMutableProduct(ProductKey productKey) {
        Preconditions.checkArgument((productKey != null ? 1 : 0) != 0, (Object)"productKey must not be null");
        return Optional.ofNullable(this.products.get(productKey));
    }

    @Override
    public void uninstallProductIfPresent(ProductKey productKey) {
        Preconditions.checkArgument((productKey != null ? 1 : 0) != 0, (Object)"productKey must not be null");
        Product p = this.products.remove(productKey);
        if (p != null) {
            this.inventoryVersion.getMutableMetadata().releaseProductData(productKey);
        }
    }

    @Override
    public IDistro view() {
        return this;
    }

    @Override
    @Nonnull
    public IProductInstallationValidationResult canInstallProduct(ProductKey productKey, IMutableProduct.IRequiredAttributes attributes) {
        Preconditions.checkArgument((productKey != null ? 1 : 0) != 0, (Object)"productKey must not be null");
        Preconditions.checkArgument((attributes != null ? 1 : 0) != 0, (Object)"attributes must not be null");
        return this.validator.canInstallProduct(this.inventoryVersion.getMutableMetadata(), this.key, productKey, attributes);
    }

    @Override
    @Nonnull
    public Collection<IProduct> getProducts() {
        return ImmutableList.copyOf(this.products.values());
    }

    @Override
    @Nonnull
    public String getName(String locale) {
        return this.localization.get(locale, "name", this.key.getId());
    }

    @Override
    @Nonnull
    public String getDescription(String locale) {
        return this.localization.get(locale, "description", "");
    }

    @Override
    @Nonnull
    public String getHomeUrl(String locale) {
        return this.localization.get(locale, "home-url", "");
    }

    @Override
    @Nonnull
    public String getVendor(String locale) {
        return this.localization.get(locale, "vendor", "");
    }

    @Override
    public void addLocalization(String locale, String name, @Nullable String text) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)locale) ? 1 : 0) != 0, (Object)"locale must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name must not be null or empty");
        if (text != null) {
            this.localization.set(locale, name, text);
        }
    }

    @Override
    public void setNameLocalization(String locale, @Nullable String text) {
        this.addLocalization(locale, "name", text);
    }

    @Override
    public void setDescriptionLocalization(String locale, @Nullable String text) {
        this.addLocalization(locale, "description", text);
    }

    @Override
    public void setHomeUrlLocalization(String locale, @Nullable String text) {
        this.addLocalization(locale, "home-url", text);
    }

    @Override
    public void setVendorLocalization(String locale, @Nullable String text) {
        this.addLocalization(locale, "vendor", text);
    }

    @Override
    @Nonnull
    public Optional<IProduct> findProduct(ProductKey productKey) {
        Preconditions.checkArgument((productKey != null ? 1 : 0) != 0, (Object)"productKey must not be null");
        return Optional.ofNullable(this.products.get(productKey));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Distro [");
        sb.append("uid=[").append(this.key).append(']');
        sb.append(", source=[").append(this.source).append(']');
        sb.append(", products=[").append(this.products).append(']');
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Distro distro = (Distro)o;
        return this.key.equals((Object)distro.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    void uninstall() {
        this.products.keySet().forEach(productKey -> this.inventoryVersion.getMutableMetadata().releaseProductData((ProductKey)productKey));
        this.products.clear();
    }
}

