/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com._1c.packaging.inventory.IDistroSource;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class DistroSource
implements IDistroSource {
    private final IDistroSource.SourceType type;
    private final String path;

    public static IDistroSource ofFile(@Nullable String path) {
        return new DistroSource(IDistroSource.SourceType.FILE, path);
    }

    public static IDistroSource of(IDistroSource.SourceType type, @Nullable String path) {
        return new DistroSource(type, path);
    }

    private DistroSource(IDistroSource.SourceType type, @Nullable String path) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type must not be null");
        this.type = type;
        this.path = path;
    }

    @Override
    @Nonnull
    public IDistroSource.SourceType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public String getPath() {
        return this.path;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DistroSource [");
        sb.append("type=[").append((Object)this.type).append(']');
        sb.append(", path=[").append(this.path).append(']');
        sb.append(']');
        return sb.toString();
    }
}

