/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com._1c.packaging.inventory.FileType;
import com._1c.packaging.inventory.IFileMeta;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
final class FileMeta
implements IFileMeta {
    private final String sha1;
    private final FileType type;
    private final boolean modifiable;

    FileMeta(String sha1, FileType type, boolean modifiable) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sha1) ? 1 : 0) != 0, (Object)"sha1 must not be null or empty");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type must not be null");
        this.sha1 = sha1;
        this.type = type;
        this.modifiable = modifiable;
    }

    @Override
    @Nonnull
    public String getSha1() {
        return this.sha1;
    }

    @Override
    @Nonnull
    public FileType getType() {
        return this.type;
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FileMeta [");
        sb.append("sha1=[").append(this.sha1).append(']');
        sb.append(", type=[").append((Object)this.type).append(']');
        sb.append(", modifiable=[").append(this.modifiable).append(']');
        sb.append(']');
        return sb.toString();
    }
}

