/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FileMutex {
    private final Object internalMonitor = new Object();
    private final Path f;
    private FileChannel channel;
    private FileLock lock;

    public FileMutex(Path f) {
        this.f = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock() throws IOException {
        FileChannel ch = FileChannel.open(this.f, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        Object object = this.internalMonitor;
        synchronized (object) {
            if (this.tryLockChannel(ch)) {
                this.channel = ch;
                return true;
            }
        }
        ch.close();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException, IOException {
        long deadline = System.nanoTime() + unit.toNanos(time);
        FileChannel ch = FileChannel.open(this.f, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        do {
            Object object = this.internalMonitor;
            synchronized (object) {
                if (this.tryLockChannel(ch)) {
                    this.channel = ch;
                    return true;
                }
            }
            Thread.sleep(10L);
        } while (System.nanoTime() - deadline <= 0L);
        ch.close();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() throws IOException {
        IOException lockReleaseEx = null;
        IOException channelCloseEx = null;
        Object object = this.internalMonitor;
        synchronized (object) {
            if (this.lock != null) {
                try {
                    this.lock.release();
                }
                catch (ClosedChannelException closedChannelException) {
                }
                catch (IOException e) {
                    lockReleaseEx = e;
                }
                this.lock = null;
            }
            if (this.channel != null) {
                try {
                    this.channel.close();
                }
                catch (IOException e) {
                    channelCloseEx = e;
                }
                this.channel = null;
            }
        }
        if (channelCloseEx != null) {
            if (lockReleaseEx != null) {
                channelCloseEx.addSuppressed(lockReleaseEx);
            }
            throw channelCloseEx;
        }
        if (lockReleaseEx != null) {
            throw lockReleaseEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHoldingLock() {
        Object object = this.internalMonitor;
        synchronized (object) {
            return this.lock != null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FileMutex [");
        sb.append("f=[").append(this.f).append(']');
        sb.append(", [").append(this.isHoldingLock() ? "holding a lock" : "not holding a lock").append(']');
        sb.append(']');
        return sb.toString();
    }

    private boolean tryLockChannel(FileChannel ch) throws IOException {
        try {
            this.lock = ch.tryLock();
            return this.lock != null;
        }
        catch (OverlappingFileLockException e) {
            return false;
        }
    }
}

