/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public class FilesSnapshot {
    private final Map<String, String> files = new TreeMap<String, String>();

    @Nonnull
    public Optional<String> getSha1(String fileName) {
        return Optional.ofNullable(this.files.get(fileName));
    }

    public void set(String name, String sha1) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name must not be null or empty");
        this.files.put(name, sha1);
    }

    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FilesSnapshot [");
        sb.append("files.size=[").append(this.files.size()).append(']');
        sb.append(']');
        return sb.toString();
    }
}

