/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com._1c.chassis.gears.digest.FileDigester;
import com._1c.packaging.inventory.FileType;
import com._1c.packaging.inventory.IFileMeta;
import com._1c.packaging.inventory.IFileSnapshotVisitor;
import com._1c.packaging.inventory.IInstalledFilesContainer;
import com._1c.packaging.inventory.IMutableInstalledFilesContainer;
import com._1c.packaging.inventory.IUninterruptibleFileSnapshotVisitor;
import com._1c.packaging.inventory.InventoryAccessDeniedException;
import com._1c.packaging.inventory.InventoryFileIoException;
import com._1c.packaging.inventory.internal.FileMeta;
import com._1c.packaging.inventory.internal.IMessagesList;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class InstalledFilesContainerMixin
implements IInstalledFilesContainer,
IMutableInstalledFilesContainer {
    private final Function<String, Path> relativePathResolver;
    private final Map<String, IFileMeta> files = new TreeMap<String, IFileMeta>();

    InstalledFilesContainerMixin(Function<String, Path> relativePathResolver) {
        Preconditions.checkArgument((relativePathResolver != null ? 1 : 0) != 0, (Object)"relativePathResolver must not be null");
        this.relativePathResolver = relativePathResolver;
    }

    @Override
    @Nonnull
    public Optional<String> getActualFileSha1(String relativeFilePathName) throws InterruptedException {
        Optional<String> result = this.getActualFileSha1Internal(relativeFilePathName, true);
        Preconditions.checkState((result != null || result == null && Thread.currentThread().isInterrupted() ? 1 : 0) != 0, (Object)"Interruptible version must return Optional<String> or null after interruption.");
        this.checkInterruption(IMessagesList.Messages.actualFileSha1CalculationInterrupted());
        return result;
    }

    @Override
    public void snapshotAction(IFileSnapshotVisitor visitor) throws InterruptedException {
        Preconditions.checkArgument((visitor != null ? 1 : 0) != 0, (Object)"visitor must not be null");
        for (Map.Entry<String, IFileMeta> f : this.files.entrySet()) {
            if (Thread.interrupted()) {
                throw new InterruptedException(IMessagesList.Messages.filesProcessingInterrupted());
            }
            visitor.visit(f.getKey(), f.getValue());
        }
    }

    @Override
    @Nonnull
    public Optional<String> getActualFileSha1Uninterruptibly(String relativeFilePathName) {
        Optional<String> result = this.getActualFileSha1Internal(relativeFilePathName, false);
        Preconditions.checkState((result != null ? 1 : 0) != 0, (Object)"Non interruptible version must always return Optional<String>.");
        return result;
    }

    @Override
    public void snapshotActionUninterruptibly(IUninterruptibleFileSnapshotVisitor visitor) {
        Preconditions.checkArgument((visitor != null ? 1 : 0) != 0, (Object)"visitor must not be null");
        this.files.forEach(visitor::visit);
    }

    @Override
    public void addFileMeta(String pathName, String sha1, FileType type, boolean modifiable) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)pathName) ? 1 : 0) != 0, (Object)"pathName must not be null or empty");
        this.files.put(InstalledFilesContainerMixin.normalizeRelativePath(pathName), new FileMeta(sha1, type, modifiable));
    }

    @Nullable
    private Optional<String> getActualFileSha1Internal(String relativeFilePathName, boolean interruptible) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)relativeFilePathName) ? 1 : 0) != 0, (Object)"relativeFilePathName must not be null or empty");
        Path path = this.relativePathResolver.apply(InstalledFilesContainerMixin.toPlatformRelativePath(InstalledFilesContainerMixin.normalizeRelativePath(relativeFilePathName)));
        if (Files.exists(path, new LinkOption[0])) {
            try {
                if (interruptible) {
                    try {
                        return Optional.of(new FileDigester().digestFile(path));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                }
                return Optional.of(new FileDigester().digestFileUninterruptibly(path));
            }
            catch (AccessDeniedException e) {
                throw new InventoryAccessDeniedException(path, (Throwable)e);
            }
            catch (IOException e) {
                throw new InventoryFileIoException(path, e);
            }
        }
        return Optional.empty();
    }

    private void checkInterruption(String message) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException(message);
        }
    }

    private static String normalizeRelativePath(String path) {
        String p = path.replace('\\', '/');
        p = CharMatcher.anyOf((CharSequence)"/").collapseFrom((CharSequence)p, '/');
        int start = p.charAt(0) == '/' ? 1 : 0;
        int end = p.charAt(p.length() - 1) == '/' ? p.length() - 1 : p.length();
        p = p.substring(start, end);
        Preconditions.checkArgument((!p.isEmpty() ? 1 : 0) != 0, (String)"invalid relative path: %s", (Object)path);
        return p;
    }

    private static String toPlatformRelativePath(String relativePath) {
        return relativePath.replace('/', File.separatorChar);
    }
}

