/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com._1c.chassis.gears.versions.SemanticVersion;
import com._1c.packaging.inventory.FileType;
import com._1c.packaging.inventory.IFileSnapshotVisitor;
import com._1c.packaging.inventory.IInstalledShortcutsVisitor;
import com._1c.packaging.inventory.IInstallerComponent;
import com._1c.packaging.inventory.IMutableInstallerComponent;
import com._1c.packaging.inventory.IUninterruptibleFileSnapshotVisitor;
import com._1c.packaging.inventory.InstalledFilesLayout;
import com._1c.packaging.inventory.internal.InstalledFilesContainerMixin;
import com._1c.packaging.inventory.internal.InstalledShortcut;
import com._1c.packaging.inventory.internal.InventoryMeta;
import com._1c.packaging.model.shared.Architecture;
import com._1c.packaging.model.shared.ComponentKey;
import com._1c.packaging.model.shared.OsType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public class InstallerComponent
implements IInstallerComponent,
IMutableInstallerComponent {
    private final ComponentKey key;
    private final InventoryMeta meta;
    private final InstalledFilesContainerMixin installedFiles;
    private final List<InstalledShortcut> shortcuts = new ArrayList<InstalledShortcut>();
    private List<Path> paths;

    InstallerComponent(SemanticVersion version, OsType os, Architecture arch, InventoryMeta meta) {
        this.meta = meta;
        this.key = new ComponentKey("1c-enterprise-installer", version, os, arch);
        this.installedFiles = new InstalledFilesContainerMixin(this::resolveInstallerFile);
    }

    @Override
    @Nonnull
    public ComponentKey getKey() {
        return this.key;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.key.getId();
    }

    @Override
    @Nonnull
    public SemanticVersion getVersion() {
        return this.key.getVersion();
    }

    @Override
    @Nonnull
    public OsType getOs() {
        return this.key.getOsType();
    }

    @Override
    @Nonnull
    public Architecture getArch() {
        return this.key.getArchitecture();
    }

    @Override
    public void setPaths(List<Path> paths) {
        Preconditions.checkArgument((paths != null ? 1 : 0) != 0, (Object)"paths must be not null");
        ArrayList<Path> normalizedPaths = new ArrayList<Path>();
        for (Path path : paths) {
            normalizedPaths.add(path.normalize());
        }
        this.paths = ImmutableList.copyOf(normalizedPaths);
    }

    @Override
    @Nonnull
    public List<Path> getPaths() {
        if (this.paths == null) {
            this.paths = Collections.emptyList();
        }
        return this.paths;
    }

    @Override
    @Nonnull
    public Optional<String> getActualFileSha1(String relativeFilePathName) throws InterruptedException {
        return this.installedFiles.getActualFileSha1(relativeFilePathName);
    }

    @Override
    @Nonnull
    public Optional<String> getActualFileSha1Uninterruptibly(String relativeFilePathName) {
        return this.installedFiles.getActualFileSha1Uninterruptibly(relativeFilePathName);
    }

    @Override
    public void snapshotAction(IFileSnapshotVisitor visitor) throws InterruptedException {
        this.installedFiles.snapshotAction(visitor);
    }

    @Override
    public void snapshotActionUninterruptibly(IUninterruptibleFileSnapshotVisitor visitor) {
        this.installedFiles.snapshotActionUninterruptibly(visitor);
    }

    public String toString() {
        return "InstallerComponent [key=[" + this.key + ']' + ']';
    }

    @Override
    public void addFileMeta(String pathName, String sha1, FileType type, boolean modifiable) {
        this.installedFiles.addFileMeta(pathName, sha1, type, modifiable);
    }

    @Override
    public void addShortcutFileMeta(String knownFolderAbsolutePath, String relativePath) {
        this.shortcuts.add(new InstalledShortcut(knownFolderAbsolutePath, relativePath));
    }

    @Override
    public void forEachShortcut(IInstalledShortcutsVisitor visitor) {
        this.shortcuts.forEach(s -> visitor.visit(s.getKnownFolderName(), s.getRelativePath()));
    }

    @Override
    public boolean hasShortcuts() {
        return !this.shortcuts.isEmpty();
    }

    @Override
    @Nonnull
    public IInstallerComponent view() {
        return this;
    }

    private Path resolveInstallerFile(String relativeFilePathName) {
        Path productsHome = this.meta.getProductsHome();
        return InstalledFilesLayout.getComponentDir(productsHome, this.key).resolve(relativeFilePathName);
    }
}

