/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com._1c.chassis.gears.env.IEnvironment;
import com._1c.chassis.gears.env.OsType;
import com._1c.packaging.inventory.IInstallerComponent;
import com._1c.packaging.inventory.IInstallerComponentInstallationValidationResult;
import com._1c.packaging.inventory.internal.IMessagesList;
import com._1c.packaging.inventory.internal.InventoryMeta;
import com._1c.packaging.inventory.internal.TargetArchitectureRule;
import com._1c.packaging.inventory.internal.TargetOsRule;
import com._1c.packaging.model.shared.ComponentKey;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class InstallerComponentInstallationValidator {
    private final IEnvironment env;
    private final TargetOsRule targetOsRule;
    private final TargetArchitectureRule targetArchitectureRule;

    InstallerComponentInstallationValidator(IEnvironment env) {
        this.env = env;
        this.targetOsRule = new TargetOsRule(env);
        this.targetArchitectureRule = new TargetArchitectureRule(env);
    }

    IInstallerComponentInstallationValidationResult canInstallInstallerComponent(InventoryMeta meta, ComponentKey componentKey) {
        Preconditions.checkState((boolean)componentKey.getId().equals("1c-enterprise-installer"), (String)"invalid installerId: %s", (Object)componentKey.getId());
        IInstallerComponent duplicate = meta.getInstallerComponent().orElse(null);
        boolean wrongOs = !this.targetOsRule.satisfied(componentKey.getOsType());
        boolean wrongArch = !this.targetArchitectureRule.satisfied(componentKey.getArchitecture());
        return new InstallerComponentInstallationValidationResultImpl(duplicate, wrongOs, wrongArch, this.env.getOsType());
    }

    private static final class InstallerComponentInstallationValidationResultImpl
    implements IInstallerComponentInstallationValidationResult {
        private final IInstallerComponent duplicate;
        private final boolean wrongOs;
        private final boolean wrongArch;
        private final OsType osType;

        InstallerComponentInstallationValidationResultImpl(@Nullable IInstallerComponent duplicate, boolean wrongOs, boolean wrongArch, OsType osType) {
            this.duplicate = duplicate;
            this.wrongOs = wrongOs;
            this.wrongArch = wrongArch;
            this.osType = osType;
        }

        @Override
        @Nonnull
        public Optional<IInstallerComponent> getDuplicate() {
            return Optional.ofNullable(this.duplicate);
        }

        @Override
        public boolean isWrongOs() {
            return this.wrongOs;
        }

        @Override
        public boolean isWrongArch() {
            return this.wrongArch;
        }

        @Override
        public boolean isInstallationOk() {
            return this.duplicate == null && !this.wrongOs && !this.wrongArch;
        }

        @Override
        @Nonnull
        public String getTextErrorReport() {
            if (this.isInstallationOk()) {
                return IMessagesList.Messages.ok();
            }
            ArrayList<String> messages = new ArrayList<String>();
            if (this.duplicate != null) {
                messages.add(IMessagesList.Messages.sameComponentAlreadyInstalled(this.duplicate.getKey()));
            }
            if (this.wrongOs) {
                com._1c.packaging.model.shared.OsType currentOs = com._1c.packaging.model.shared.OsType.fromGears((OsType)this.osType);
                messages.add(IMessagesList.Messages.cannotInstallOnOsOtherThenCurrentMachine(currentOs.getDisplayName()));
            }
            if (this.wrongArch) {
                messages.add(IMessagesList.Messages.cannotInstallOnArchMismatch());
            }
            Preconditions.checkState((!messages.isEmpty() ? 1 : 0) != 0, (String)"Error report problem. Report state is %s", (Object)this);
            return messages.stream().collect(Collectors.joining(System.lineSeparator()));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("InstallerComponentInstallationValidationResultImpl [");
            sb.append("installationOk=[").append(this.isInstallationOk()).append(']');
            sb.append(", duplicate=[").append(this.duplicate).append(']');
            sb.append(", wrongOs=[").append(this.wrongOs).append(']');
            sb.append(", wrongArch=[").append(this.wrongArch).append(']');
            sb.append(']');
            return sb.toString();
        }
    }
}

