/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com._1c.packaging.inventory.IInventoryMaintanance;
import com._1c.packaging.inventory.IInventoryVersion;
import com._1c.packaging.inventory.internal.Inventory;
import com.google.common.base.Preconditions;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class InventoryMaintanance
implements IInventoryMaintanance {
    private final Inventory inventory;

    InventoryMaintanance(Inventory inventory) {
        this.inventory = inventory;
    }

    @Override
    @Nonnull
    public Map<Integer, Path> findVersionsDirs(List<Integer> versionNumbers) {
        Preconditions.checkArgument((versionNumbers != null ? 1 : 0) != 0, (Object)"versionNumbers must not be null.");
        HashMap<Integer, Path> existentVersionToDir = new HashMap<Integer, Path>();
        for (Integer versionNumber : versionNumbers) {
            Path inventoryVersionDirPath = this.inventory.getVersions().stream().filter(v -> v.getVersion() == versionNumber.intValue()).findFirst().map(IInventoryVersion::getPath).orElseGet(() -> this.inventory.getRootPath().resolve("v" + versionNumber));
            if (!Files.exists(inventoryVersionDirPath, new LinkOption[0])) continue;
            existentVersionToDir.put(versionNumber, inventoryVersionDirPath);
        }
        return existentVersionToDir;
    }
}

