/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com._1c.chassis.gears.bytesize.ByteSize;
import com._1c.chassis.gears.env.IEnvironment;
import com._1c.chassis.gears.io.FileUtil;
import com._1c.chassis.gears.versions.SemanticVersion;
import com._1c.packaging.inventory.CannotInstallInstallerComponentException;
import com._1c.packaging.inventory.Feature;
import com._1c.packaging.inventory.IComponent;
import com._1c.packaging.inventory.IDistro;
import com._1c.packaging.inventory.IInstallerComponent;
import com._1c.packaging.inventory.IInstallerComponentInstallationValidationResult;
import com._1c.packaging.inventory.IInventoryMeta;
import com._1c.packaging.inventory.IMutableDistro;
import com._1c.packaging.inventory.IMutableInstallerComponent;
import com._1c.packaging.inventory.IMutableInventoryMeta;
import com._1c.packaging.inventory.IMutableProduct;
import com._1c.packaging.inventory.IProduct;
import com._1c.packaging.inventory.InclusionType;
import com._1c.packaging.inventory.InventoryAccessDeniedException;
import com._1c.packaging.inventory.InventoryFileIoException;
import com._1c.packaging.inventory.internal.ComponentData;
import com._1c.packaging.inventory.internal.DirectoryUtils;
import com._1c.packaging.inventory.internal.Distro;
import com._1c.packaging.inventory.internal.IPersistentData;
import com._1c.packaging.inventory.internal.InstallerComponent;
import com._1c.packaging.inventory.internal.InstallerComponentInstallationValidator;
import com._1c.packaging.inventory.internal.InventoryVersion;
import com._1c.packaging.inventory.internal.ProductData;
import com._1c.packaging.model.shared.Architecture;
import com._1c.packaging.model.shared.ComponentKey;
import com._1c.packaging.model.shared.DistroKey;
import com._1c.packaging.model.shared.OsType;
import com._1c.packaging.model.shared.ProductKey;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class InventoryMeta
implements IInventoryMeta,
IMutableInventoryMeta {
    private final InventoryVersion inventoryVersion;
    private final List<IDistro> distros = new ArrayList<IDistro>();
    private final Set<String> loadedLocales = new HashSet<String>();
    private final InstallerComponentInstallationValidator installerValidator;
    private final IEnvironment env;
    private final Map<ProductKey, ObjectRef<ProductData>> products = new HashMap<ProductKey, ObjectRef<ProductData>>();
    private final Map<ComponentKey, ObjectRef<ComponentData>> components = new HashMap<ComponentKey, ObjectRef<ComponentData>>();
    private Path productsHome;
    private SemanticVersion metadataFormatVersion;
    private ZonedDateTime createdAt;
    private String createdBy;
    private InstallerComponent installer;
    private Set<Feature> features;

    public InventoryMeta(InventoryVersion version, Path productsHome, IEnvironment env, Set<Feature> features) {
        Preconditions.checkArgument((version != null ? 1 : 0) != 0, (Object)"version must not be null");
        Preconditions.checkArgument((productsHome != null ? 1 : 0) != 0, (Object)"productsHome must not be null");
        Preconditions.checkArgument((env != null ? 1 : 0) != 0, (Object)"env must not be null");
        Preconditions.checkArgument((features != null ? 1 : 0) != 0, (Object)"features must not be null");
        this.inventoryVersion = version;
        this.productsHome = productsHome;
        this.installerValidator = new InstallerComponentInstallationValidator(env);
        this.env = env;
        this.features = ImmutableSet.copyOf(features);
    }

    @Override
    @Nonnull
    public List<IDistro> getDistros() {
        return new ArrayList<IDistro>(this.distros);
    }

    @Override
    @Nonnull
    public Optional<IDistro> findDistro(DistroKey distroKey) {
        Preconditions.checkArgument((distroKey != null ? 1 : 0) != 0, (Object)"distroKey must not be null");
        return this.getDistro(distroKey, IDistro.class);
    }

    @Override
    @Nonnull
    public Optional<IInstallerComponent> getInstallerComponent() {
        return this.installer != null ? Optional.of(this.installer.view()) : Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<IMutableInstallerComponent> getMutableInstallerComponent() {
        return Optional.ofNullable(this.installer);
    }

    @Override
    @Nonnull
    public Set<Feature> getFeatures() {
        return this.features;
    }

    @Override
    @Nonnull
    public IMutableInstallerComponent installInstallerComponentIfAbsent(SemanticVersion version, OsType os, Architecture arch) {
        Preconditions.checkArgument((version != null ? 1 : 0) != 0, (Object)"version must not be null");
        Preconditions.checkArgument((os != null ? 1 : 0) != 0, (Object)"os must not be null");
        Preconditions.checkArgument((arch != null ? 1 : 0) != 0, (Object)"arch must not be null");
        ComponentKey installerKey = new ComponentKey("1c-enterprise-installer", version, os, arch);
        if (this.installer != null && this.installer.getKey().equals((Object)installerKey)) {
            return this.installer;
        }
        IInstallerComponentInstallationValidationResult result = this.installerValidator.canInstallInstallerComponent(this, installerKey);
        if (result.isInstallationOk()) {
            this.installer = new InstallerComponent(version, os, arch, this);
            return this.installer;
        }
        throw new CannotInstallInstallerComponentException(result, installerKey);
    }

    @Nonnull
    public InstallerComponent setInstallerComponent(SemanticVersion version, OsType os, Architecture arch) {
        this.installer = new InstallerComponent(version, os, arch, this);
        return this.installer;
    }

    @Override
    public void uninstallInstallerComponentIfPresent() {
        if (this.installer != null) {
            this.clearComponentVersionData(this.installer.getKey());
            this.installer = null;
        }
    }

    void clearComponentVersionData(ComponentKey componentKey) {
        Path componentRootPath = this.inventoryVersion.getComponentsDir().resolve(componentKey.getId());
        Path dir = componentRootPath.resolve(componentKey.getArchitecture().getName()).resolve(componentKey.getVersion().toString());
        try {
            FileUtil.delete((Path)dir, (int)50, (long)50L, (TimeUnit)TimeUnit.MILLISECONDS, (FileVisitOption[])new FileVisitOption[0]);
            DirectoryUtils.deleteEmptyDirectories(dir.getParent(), componentRootPath);
        }
        catch (AccessDeniedException e) {
            throw new InventoryAccessDeniedException(dir, (Throwable)e);
        }
        catch (IOException e) {
            throw new InventoryFileIoException(dir, e);
        }
    }

    @Nonnull
    public Optional<String> readComponentVersionDataItem(String dataItemName, String id, SemanticVersion version, Architecture arch) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"id must not be null or empty");
        Preconditions.checkArgument((version != null ? 1 : 0) != 0, (Object)"version must not be null");
        Preconditions.checkArgument((arch != null ? 1 : 0) != 0, (Object)"arch must not be null");
        return this.readComponentVersionDataItem(dataItemName, StandardCharsets.UTF_8, id, version, arch);
    }

    @Override
    @Nonnull
    public Stream<IDistro> distrosStream() {
        return this.distros.stream();
    }

    @Override
    @Nonnull
    public Stream<IProduct> productsStream() {
        return this.distros.stream().flatMap(d -> d.getProducts().stream());
    }

    @Override
    @Nonnull
    public Stream<IComponent> componentsStream() {
        return this.distros.stream().flatMap(d -> d.getProducts().stream()).flatMap(p -> p.getComponents().stream());
    }

    @Override
    public boolean componentExists(ComponentKey componentKey) {
        Preconditions.checkArgument((componentKey != null ? 1 : 0) != 0, (Object)" componentkey must be not null");
        return this.componentsStream().anyMatch(c -> c.getKey().equals((Object)componentKey));
    }

    @Override
    public boolean productExists(ProductKey productKey) {
        Preconditions.checkArgument((productKey != null ? 1 : 0) != 0, (Object)" productKey must be not null");
        return this.productsStream().anyMatch(c -> c.getKey().equals((Object)productKey));
    }

    @Nonnull
    public Optional<String> readComponentVersionDataItem(String dataItemName, Charset charset, String id, SemanticVersion version, Architecture arch) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"id must not be null or empty");
        Preconditions.checkArgument((version != null ? 1 : 0) != 0, (Object)"version must not be null");
        Preconditions.checkArgument((arch != null ? 1 : 0) != 0, (Object)"arch must not be null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"charset must not be null");
        boolean installed = this.isComponentInstalled(id, version, arch);
        if (!installed) {
            String msg = "Component " + id + ":" + version + ":" + arch + " is not installed";
            throw new IllegalArgumentException(msg);
        }
        Path dir = this.getComponentRootPath(id).resolve(arch.getName()).resolve(version.toString());
        return this.readFileContent(dataItemName, dir, charset);
    }

    @Nonnull
    public Optional<String> readComponentCommonDataItem(String dataItemName, Charset charset, String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"id must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dataItemName) ? 1 : 0) != 0, (Object)"dataItemName must not be null or empty");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"charset must not be null");
        Path dir = this.getComponentRootPath(id);
        return this.readFileContent(dataItemName, dir, charset);
    }

    @Nonnull
    public Optional<String> readComponentCommonDataItem(String dataItemName, String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"id must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dataItemName) ? 1 : 0) != 0, (Object)"dataItemName must not be null or empty");
        return this.readComponentCommonDataItem(dataItemName, StandardCharsets.UTF_8, id);
    }

    @Override
    public void registerLocale(String locale) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)locale) ? 1 : 0) != 0, (Object)"locale must not be null or empty");
        this.loadedLocales.add(locale);
    }

    public void writeComponentVersionDataItem(String dataItemName, String id, SemanticVersion version, Architecture arch, String content) {
        this.writeComponentVersionDataItem(dataItemName, StandardCharsets.UTF_8, id, version, arch, content);
    }

    public void writeComponentVersionDataItem(String dataItemName, Charset charset, String id, SemanticVersion version, Architecture arch, String content) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dataItemName) ? 1 : 0) != 0, (Object)"dataItemName must not be null or empty");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"charset must not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"id must not be null or empty");
        Preconditions.checkArgument((version != null ? 1 : 0) != 0, (Object)"version must not be null");
        Preconditions.checkArgument((arch != null ? 1 : 0) != 0, (Object)"arch must not be null");
        Preconditions.checkArgument((content != null ? 1 : 0) != 0, (Object)"content must not be null");
        boolean installed = this.isComponentInstalled(id, version, arch);
        if (!installed) {
            String msg = "Component " + id + ":" + version + ":" + arch + " is not installed";
            throw new IllegalArgumentException(msg);
        }
        Path dir = this.getComponentRootPath(id).resolve(arch.getName()).resolve(version.toString());
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Path file = dir.resolve(dataItemName);
            com.google.common.io.Files.write((byte[])content.getBytes(charset), (File)file.toFile());
        }
        catch (AccessDeniedException e) {
            throw new InventoryAccessDeniedException(dir, (Throwable)e);
        }
        catch (IOException e) {
            throw new InventoryFileIoException(dir, e);
        }
    }

    public void writeComponentCommonDataItem(String dataItemName, String id, String content) {
        this.writeComponentCommonDataItem(dataItemName, StandardCharsets.UTF_8, id, content);
    }

    public void writeComponentCommonDataItem(String dataItemName, Charset charset, String id, String content) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dataItemName) ? 1 : 0) != 0, (Object)"dataItemName must not be null or empty");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"charset must not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"id must not be null or empty");
        Preconditions.checkArgument((content != null ? 1 : 0) != 0, (Object)"content must not be null");
        Path dir = this.getComponentRootPath(id);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Path file = dir.resolve(dataItemName);
            com.google.common.io.Files.write((byte[])content.getBytes(charset), (File)file.toFile());
        }
        catch (AccessDeniedException e) {
            throw new InventoryAccessDeniedException(dir, (Throwable)e);
        }
        catch (IOException e) {
            throw new InventoryFileIoException(dir, e);
        }
    }

    public void deleteComponentVersionDataItem(String dataItemName, String id, SemanticVersion version, Architecture arch) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dataItemName) ? 1 : 0) != 0, (Object)"dataItemName must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"id must not be null or empty");
        Preconditions.checkArgument((version != null ? 1 : 0) != 0, (Object)"version must not be null");
        Preconditions.checkArgument((arch != null ? 1 : 0) != 0, (Object)"arch must not be null");
        Path dir = this.getComponentRootPath(id).resolve(arch.getName()).resolve(version.toString());
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Path file = dir.resolve(dataItemName);
            FileUtil.delete((Path)file, (int)50, (long)50L, (TimeUnit)TimeUnit.MILLISECONDS, (FileVisitOption[])new FileVisitOption[0]);
        }
        catch (AccessDeniedException e) {
            throw new InventoryAccessDeniedException(dir, (Throwable)e);
        }
        catch (IOException e) {
            throw new InventoryFileIoException(dir, e);
        }
    }

    public void deleteComponentCommonDataItem(String dataItemName, String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dataItemName) ? 1 : 0) != 0, (Object)"dataItemName must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"id must not be null or empty");
        Path dir = this.getComponentRootPath(id);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Path file = dir.resolve(dataItemName);
            FileUtil.delete((Path)file, (int)50, (long)50L, (TimeUnit)TimeUnit.MILLISECONDS, (FileVisitOption[])new FileVisitOption[0]);
        }
        catch (AccessDeniedException e) {
            throw new InventoryAccessDeniedException(dir, (Throwable)e);
        }
        catch (IOException e) {
            throw new InventoryFileIoException(dir, e);
        }
    }

    @Override
    @Nonnull
    public IInstallerComponentInstallationValidationResult canInstallInstallerComponent(SemanticVersion version, OsType os, Architecture arch) {
        Preconditions.checkArgument((version != null ? 1 : 0) != 0, (Object)"version must not be null");
        Preconditions.checkArgument((os != null ? 1 : 0) != 0, (Object)"os must not be null");
        Preconditions.checkArgument((arch != null ? 1 : 0) != 0, (Object)"arch must not be null");
        return this.installerValidator.canInstallInstallerComponent(this, new ComponentKey("1c-enterprise-installer", version, os, arch));
    }

    @Override
    @Nonnull
    public SemanticVersion getMetadataFormatVersion() {
        return this.metadataFormatVersion;
    }

    public void setMetadataFormatVersion(SemanticVersion metadataFormatVersion) {
        this.metadataFormatVersion = metadataFormatVersion;
    }

    @Override
    @Nonnull
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(ZonedDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Override
    @Nonnull
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Override
    @Nonnull
    public Path getProductsHome() {
        return this.productsHome;
    }

    @Override
    public void setProductsHome(Path productsHome) {
        Preconditions.checkArgument((productsHome != null ? 1 : 0) != 0, (Object)"productsHome must not be null");
        this.productsHome = productsHome.toAbsolutePath().normalize();
    }

    public void setFeatures(Set<Feature> features) {
        Preconditions.checkArgument((features != null ? 1 : 0) != 0, (Object)"features must not be null");
        this.features = ImmutableSet.copyOf(features);
    }

    @Override
    @Nonnull
    public IMutableDistro installDistroIfAbsent(DistroKey distroKey) {
        Preconditions.checkArgument((distroKey != null ? 1 : 0) != 0, (Object)"distroKey must not be null");
        return this.getDistro(distroKey, IMutableDistro.class).orElseGet(() -> this.addDistro(distroKey));
    }

    @Nonnull
    public Distro addDistro(DistroKey distroKey) {
        Distro d = new Distro(distroKey, this.inventoryVersion, this.env);
        this.distros.add(d);
        return d;
    }

    @Override
    @Nonnull
    public Optional<IMutableDistro> getMutableDistro(DistroKey distroKey) {
        Preconditions.checkArgument((distroKey != null ? 1 : 0) != 0, (Object)"distroKey must not be null");
        return this.getDistro(distroKey, IMutableDistro.class);
    }

    @Override
    public void uninstallDistroIfPresent(DistroKey distroKey) {
        Preconditions.checkArgument((distroKey != null ? 1 : 0) != 0, (Object)"distroKey must not be null");
        Optional<Distro> od = this.getDistro(distroKey, Distro.class);
        if (od.isPresent()) {
            Distro d = od.get();
            this.distros.remove(d);
            d.uninstall();
        }
    }

    @Override
    @Nonnull
    public IInventoryMeta view() {
        return this;
    }

    @Override
    @Nonnull
    public InventoryVersion getVersion() {
        return this.inventoryVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("InventoryMeta [");
        sb.append(", version=[").append(this.inventoryVersion).append(']');
        sb.append(", metadataFormatVersion=[").append(this.metadataFormatVersion).append(']');
        sb.append(", createdAt=[").append(this.createdAt).append(']');
        sb.append(", createdBy=[").append(this.createdBy).append(']');
        sb.append(", productsHome=[").append(this.productsHome).append(']');
        sb.append(", distros=[").append(this.distros).append(']');
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryMeta that = (InventoryMeta)o;
        return this.inventoryVersion == that.inventoryVersion;
    }

    public int hashCode() {
        return Objects.hash(this.inventoryVersion);
    }

    boolean isLocaleLoaded(String locale) {
        return this.loadedLocales.contains(locale);
    }

    @Nonnull
    Set<String> getLoadedLocales() {
        return Collections.unmodifiableSet(this.loadedLocales);
    }

    @Nonnull
    ProductData acquireProductData(ProductKey productKey, IMutableProduct.IRequiredAttributes attributes) {
        return this.acquireObjectRef(this.products, productKey, () -> new ProductData(productKey, this.inventoryVersion, attributes));
    }

    @Nonnull
    ComponentData acquireComponentData(ComponentKey componentKey, InclusionType inclusionType, ByteSize size) {
        return this.acquireObjectRef(this.components, componentKey, () -> new ComponentData(componentKey, inclusionType, this.inventoryVersion, size));
    }

    void releaseProductData(ProductKey productKey) {
        this.releaseObjectRef(this.products, productKey);
    }

    void releaseComponentData(ComponentKey componentKey) {
        this.releaseObjectRef(this.components, componentKey);
    }

    @Nonnull
    private <K, V> V acquireObjectRef(Map<K, ObjectRef<V>> refs, K key, Supplier<V> factory) {
        ObjectRef ref = refs.computeIfAbsent(key, __ -> new ObjectRef(factory.get()));
        ref.addRef();
        return ref.getRef();
    }

    private <K, V extends IPersistentData> void releaseObjectRef(Map<K, ObjectRef<V>> refs, K key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key must not be null");
        ObjectRef<V> ref = refs.get(key);
        ref.removeRef();
        if (!ref.hasRefs()) {
            ((IPersistentData)ref.getRef()).deleteData();
        }
    }

    private boolean isComponentInstalled(String id, SemanticVersion version, Architecture arch) {
        return this.distros.stream().flatMap(d -> d.getProducts().stream()).flatMap(p -> p.getComponents().stream()).anyMatch(c -> c.getId().equals(id) && c.getVersion().equals((Object)version) && c.getArch().equals((Object)arch));
    }

    @Nonnull
    private Optional<String> readFileContent(String fileName, Path dir, Charset charset) {
        Path file = dir.resolve(fileName);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                String content = com.google.common.io.Files.asCharSource((File)file.toFile(), (Charset)charset).read();
                return Optional.of(content);
            }
            catch (AccessDeniedException e) {
                throw new InventoryAccessDeniedException(file, (Throwable)e);
            }
            catch (IOException e) {
                throw new InventoryFileIoException(file, e);
            }
        }
        return Optional.empty();
    }

    @Nonnull
    private Path getComponentRootPath(String id) {
        return this.inventoryVersion.getComponentsDir().resolve(id);
    }

    @Nonnull
    private <T> Optional<T> getDistro(DistroKey distroKey, Class<T> resultType) {
        return this.distros.stream().filter(d -> d.getKey().equals((Object)distroKey)).findAny().map(resultType::cast);
    }

    private static final class ObjectRef<V> {
        private final V ref;
        private int refCount;

        private ObjectRef(V ref) {
            Preconditions.checkArgument((ref != null ? 1 : 0) != 0, (Object)"ref must not be null");
            this.ref = ref;
        }

        void addRef() {
            ++this.refCount;
        }

        void removeRef() {
            Preconditions.checkState((this.refCount > 0 ? 1 : 0) != 0, (Object)"refCount already 0");
            --this.refCount;
        }

        boolean hasRefs() {
            return this.refCount > 0;
        }

        V getRef() {
            return this.ref;
        }
    }
}

