/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com._1c.chassis.gears.digest.FileDigester;
import com._1c.chassis.gears.env.IEnvironment;
import com._1c.packaging.inventory.IInventoryDefaults;
import com._1c.packaging.inventory.IInventoryMeta;
import com._1c.packaging.inventory.IInventoryVersion;
import com._1c.packaging.inventory.IMutableInventoryVersion;
import com._1c.packaging.inventory.InventoryAccessDeniedException;
import com._1c.packaging.inventory.InventoryFileCorruptedException;
import com._1c.packaging.inventory.InventoryFileDoesNotExistException;
import com._1c.packaging.inventory.InventoryFileIoException;
import com._1c.packaging.inventory.InventoryFileIsEmptyException;
import com._1c.packaging.inventory.InventoryFileTooBigException;
import com._1c.packaging.inventory.InventoryStructureException;
import com._1c.packaging.inventory.InventoryType;
import com._1c.packaging.inventory.internal.CheckingPersister;
import com._1c.packaging.inventory.internal.DirectoryUtils;
import com._1c.packaging.inventory.internal.FilesSnapshot;
import com._1c.packaging.inventory.internal.IMessagesList;
import com._1c.packaging.inventory.internal.Inventory;
import com._1c.packaging.inventory.internal.InventoryMeta;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryVersion
implements IInventoryVersion,
IMutableInventoryVersion {
    private static final Logger LOGGER = LoggerFactory.getLogger(InventoryVersion.class);
    private final IEnvironment environment;
    private final IInventoryDefaults inventoryDefaults;
    private final InventoryType inventoryType;
    private final int version;
    private final Path path;
    private final Inventory inv;
    private final FilesSnapshot snapshot = new FilesSnapshot();
    private InventoryMeta meta;
    private boolean componentSnapshotsLoaded;
    private boolean componentAttributesLoaded;
    private boolean productSnapshotsLoaded;

    InventoryVersion(IEnvironment environment, IInventoryDefaults inventoryDefaults, InventoryType type, Path path, int version, Inventory inv) {
        this.environment = environment;
        this.inventoryDefaults = inventoryDefaults;
        this.inventoryType = type;
        this.path = path.toAbsolutePath().normalize();
        this.version = version;
        this.inv = inv;
    }

    InventoryVersion(IEnvironment environment, IInventoryDefaults inventoryDefaults, InventoryType type, Path path, Inventory inv) {
        this.environment = environment;
        this.inventoryDefaults = inventoryDefaults;
        this.inventoryType = type;
        this.path = path.toAbsolutePath().normalize();
        this.inv = inv;
        String ver = path.getFileName().toString();
        Preconditions.checkArgument((ver.charAt(0) == 'v' ? 1 : 0) != 0, (Object)"versionPath must start with \"v\"");
        this.version = Integer.parseInt(ver.substring(1));
    }

    @Override
    @Nonnull
    public Path getPath() {
        return this.path;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean isActive() {
        return this.version == this.inv.getCurrentVersionNumber();
    }

    @Override
    @Nonnull
    public IInventoryMeta getMetadata() throws InterruptedException {
        return this.getMetadata("en");
    }

    @Override
    @Nonnull
    public IInventoryMeta getMetadataUninterruptibly() {
        return this.getMetadataUninterruptibly("en");
    }

    @Override
    public void loadComponentSnapshots() throws InterruptedException {
        this.getMetadata();
        this.loadAllComponentsSnapshots(this.getComponentsDir(), true);
        this.checkInterruption(IMessagesList.Messages.componentsSnapshotLoadInterrupted());
    }

    @Override
    public void loadComponentSnapshotsUninterruptibly() {
        this.getMetadataUninterruptibly();
        this.loadAllComponentsSnapshots(this.getComponentsDir(), false);
    }

    @Override
    public void loadProductSnapshots() throws InterruptedException {
        this.getMetadata();
        this.loadAllProductsSnapshots(this.getProductsDir(), true);
        this.checkInterruption(IMessagesList.Messages.productSnapshotLoadInterrupted());
    }

    @Override
    public void loadProductSnapshotsUninterruptibly() {
        this.getMetadataUninterruptibly();
        this.loadAllProductsSnapshots(this.getProductsDir(), false);
    }

    @Override
    public void loadComponentAttributes() throws InterruptedException {
        this.getMetadata();
        this.loadAllComponentsAttributes(this.getComponentsDir(), true);
        this.checkInterruption(IMessagesList.Messages.attributesMetadataLoadInterrupted());
    }

    @Override
    public void loadComponentAttributesUninterruptibly() {
        this.getMetadataUninterruptibly();
        this.loadAllComponentsAttributes(this.getComponentsDir(), false);
    }

    @Override
    @Nonnull
    public IInventoryMeta getMetadata(String locale) throws InterruptedException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)locale) ? 1 : 0) != 0, (Object)"locale must not be null or empty");
        return this.getMetadataInternal(locale, true);
    }

    @Override
    @Nonnull
    public IInventoryMeta getMetadataUninterruptibly(String locale) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)locale) ? 1 : 0) != 0, (Object)"locale must not be null or empty");
        try {
            return this.getMetadataInternal(locale, false);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Developer error. Interruption is not expected here.", e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("InventoryVersion [");
        sb.append("path=[").append(this.path).append(']');
        sb.append(", version=[").append(this.version).append(']');
        if (this.isActive()) {
            sb.append(", ACTIVE");
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryVersion that = (InventoryVersion)o;
        return this.version == that.version && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.version);
    }

    @Override
    @Nonnull
    public InventoryMeta getMutableMetadata() {
        Preconditions.checkState((this.meta != null ? 1 : 0) != 0, (Object)"not initialized");
        return this.meta;
    }

    @Override
    public IInventoryVersion view() {
        return this;
    }

    public Path getComponentsDir() {
        return this.path.resolve("installed").resolve("components");
    }

    public Path getProductsDir() {
        return this.path.resolve("installed").resolve("products");
    }

    void checkConsistency(boolean interruptible) {
        if (this.snapshot.isEmpty()) {
            String actualCrc;
            Path list;
            String crc;
            block8: {
                crc = this.getEtalonCrc();
                list = this.path.resolve("inventory-list.yml");
                try {
                    if (interruptible) {
                        try {
                            actualCrc = new FileDigester().digestFile(list);
                            break block8;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                    actualCrc = new FileDigester().digestFileUninterruptibly(list);
                }
                catch (AccessDeniedException e) {
                    throw new InventoryAccessDeniedException(list, (Throwable)e);
                }
                catch (IOException e) {
                    throw new InventoryFileIoException(list, e);
                }
            }
            LOGGER.debug("inventory-list.yml: etalonCrc=[{}]; actualCrc=[{}]", (Object)crc, (Object)actualCrc);
            if (!actualCrc.equalsIgnoreCase(crc)) {
                throw new InventoryFileCorruptedException(list, actualCrc, crc);
            }
            this.inv.getPersister().loadInventorySnapshot(this.path.resolve("inventory-list.yml"), this.snapshot);
            LOGGER.debug("Snapshot = {}", (Object)this.snapshot);
        }
    }

    void loadAllLocales(Path descrDir) throws InterruptedException {
        LOGGER.debug(descrDir.toString());
        ArrayList<String> locales = new ArrayList<String>();
        try {
            DirectoryStream<Path> str = Files.newDirectoryStream(descrDir);
            Object object = null;
            try {
                for (Path p : str) {
                    LOGGER.debug(p.getFileName().toString());
                    boolean matches = p.getFileName().toString().matches("description_.+yml");
                    if (!matches) continue;
                    locales.add(p.getFileName().toString().substring("description_".length(), p.getFileName().toString().length() - ".yml".length()));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (str != null) {
                    if (object != null) {
                        try {
                            str.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        str.close();
                    }
                }
            }
        }
        catch (AccessDeniedException e) {
            throw new InventoryAccessDeniedException(descrDir, (Throwable)e);
        }
        catch (IOException e) {
            throw new InventoryFileIoException(descrDir, e);
        }
        CheckingPersister p = new CheckingPersister(this.inv.getPersister(), this.snapshot, this.path);
        for (String locale : locales) {
            p.loadDescriptions(this.meta, descrDir.resolve("description_" + locale + ".yml"), locale);
        }
    }

    void loadAllComponentsSnapshots(Path componentsDir, boolean interruptible) {
        if (!this.componentSnapshotsLoaded) {
            List cds;
            LOGGER.debug("Loading component snapshots {}", (Object)componentsDir.toString());
            CheckingPersister persister = new CheckingPersister(this.inv.getPersister(), this.snapshot, this.path);
            try (Stream<Path> list = Files.list(componentsDir);){
                cds = list.filter(p -> Files.isDirectory(p, new LinkOption[0])).collect(Collectors.toList());
            }
            catch (AccessDeniedException e) {
                throw new InventoryAccessDeniedException(componentsDir, (Throwable)e);
            }
            catch (IOException e) {
                throw new InventoryFileIoException(componentsDir, e);
            }
            for (Path cd : cds) {
                if (interruptible) {
                    try {
                        persister.loadComponentSnapshot(this.meta, cd.resolve("snapshot.yml"));
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                persister.loadComponentSnapshotUninterruptibly(this.meta, cd.resolve("snapshot.yml"));
            }
            LOGGER.debug("Component snapshots loaded");
            this.componentSnapshotsLoaded = true;
        }
    }

    void loadAllComponentsAttributes(Path componentsDir, boolean interruptible) {
        if (!this.componentAttributesLoaded) {
            List cds;
            LOGGER.debug("Loading component attributes {}", (Object)componentsDir.toString());
            CheckingPersister persister = new CheckingPersister(this.inv.getPersister(), this.snapshot, this.path);
            try (Stream<Path> list = Files.list(componentsDir);){
                cds = list.filter(p -> Files.isDirectory(p, new LinkOption[0])).collect(Collectors.toList());
            }
            catch (AccessDeniedException e) {
                throw new InventoryAccessDeniedException(componentsDir, (Throwable)e);
            }
            catch (IOException e) {
                throw new InventoryFileIoException(componentsDir, e);
            }
            for (Path cd : cds) {
                if (interruptible) {
                    try {
                        persister.loadComponentsAttributes(this.meta, cd.resolve("attributes.yml"));
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                persister.loadComponentsAttributesUninterruptibly(this.meta, cd.resolve("attributes.yml"));
            }
            LOGGER.debug("Component attributes loaded");
            this.componentAttributesLoaded = true;
        }
    }

    void loadAllProductsSnapshots(Path productDir, boolean interruptible) {
        if (!this.productSnapshotsLoaded) {
            List pds;
            LOGGER.debug("Loading product snapshots {}", (Object)productDir.toString());
            CheckingPersister persister = new CheckingPersister(this.inv.getPersister(), this.snapshot, this.path);
            try (Stream<Path> list = Files.list(productDir);){
                pds = list.filter(p -> Files.isDirectory(p, new LinkOption[0])).collect(Collectors.toList());
            }
            catch (AccessDeniedException e) {
                throw new InventoryAccessDeniedException(productDir, (Throwable)e);
            }
            catch (IOException e) {
                throw new InventoryFileIoException(productDir, e);
            }
            for (Path pd : pds) {
                if (interruptible) {
                    try {
                        persister.loadProductsSnapshot(this.meta, pd.resolve("snapshot.yml"));
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                persister.loadProductsSnapshotUninterruptibly(this.meta, pd.resolve("snapshot.yml"));
            }
            LOGGER.debug("Product snapshots loaded");
            this.productSnapshotsLoaded = true;
        }
    }

    void copyComponentFiles(Path componentsDir) {
        List cds;
        Path tgtComponentsDir = this.getComponentsDir();
        try {
            Files.createDirectories(tgtComponentsDir, new FileAttribute[0]);
            try (Stream<Path> list = Files.list(componentsDir);){
                cds = list.filter(p -> Files.isDirectory(p, new LinkOption[0])).collect(Collectors.toList());
            }
        }
        catch (AccessDeniedException e) {
            throw new InventoryAccessDeniedException(tgtComponentsDir, (Throwable)e);
        }
        catch (IOException e) {
            throw new InventoryFileIoException(tgtComponentsDir, e);
        }
        for (Path cd : cds) {
            Path dir = tgtComponentsDir.resolve(cd.getFileName());
            try {
                DirectoryUtils.copyDirectories(cd, dir, Sets.newHashSet((Object[])new String[]{"snapshot.yml", "attributes.yml"}));
            }
            catch (AccessDeniedException e) {
                throw InventoryVersion.wrapAccessDeniedException(e, cd, dir);
            }
            catch (IOException e) {
                throw new InventoryFileIoException(dir, e);
            }
        }
    }

    IInventoryMeta readMetadata(Path src) throws InterruptedException {
        Preconditions.checkState((this.meta == null ? 1 : 0) != 0, (Object)"Metadata already read");
        CheckingPersister persister = new CheckingPersister(this.inv.getPersister(), this.snapshot, this.path);
        Path file = src.resolve("installed").resolve("inventory.yml");
        this.meta = new InventoryMeta(this, this.inventoryDefaults.productsHomePath(this.inventoryType), this.environment, Sets.newHashSet());
        persister.loadMeta(this.meta, file);
        return this.meta;
    }

    void setMeta(InventoryMeta meta) {
        Preconditions.checkState((this.meta == null ? 1 : 0) != 0, (Object)"already initialized");
        this.meta = meta;
    }

    void writeCrc(boolean interruptible) {
        try {
            String versionCrc;
            Map<Path, String> actualCrcs = this.getActualCrcMap(interruptible);
            this.inv.getPersister().saveInventorySnapshot(actualCrcs, this);
            Path list = this.path.resolve("inventory-list.yml");
            FileDigester fd = new FileDigester();
            try {
                versionCrc = interruptible ? fd.digestFile(list) : fd.digestFileUninterruptibly(list);
            }
            catch (AccessDeniedException e) {
                throw new InventoryAccessDeniedException(list, (Throwable)e);
            }
            catch (IOException e) {
                throw new InventoryFileIoException(list, e);
            }
            Path crc = this.path.resolve("inventory-list.hash");
            try {
                com.google.common.io.Files.write((byte[])versionCrc.getBytes(StandardCharsets.UTF_8), (File)crc.toFile());
            }
            catch (AccessDeniedException e) {
                throw new InventoryAccessDeniedException(crc, (Throwable)e);
            }
            catch (IOException e) {
                throw new InventoryFileIoException(crc, e);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private Map<Path, String> getActualCrcMap(boolean interruptible) throws InterruptedException {
        FileDigester df = new FileDigester();
        try {
            if (interruptible) {
                return df.digestDirInDetails(this.path);
            }
            return df.digestDirInDetailsUninterruptibly(this.path);
        }
        catch (AccessDeniedException e) {
            throw new InventoryAccessDeniedException(this.path, (Throwable)e);
        }
        catch (IOException e) {
            throw new InventoryFileIoException(this.path, e);
        }
    }

    private String getEtalonCrc() throws InventoryStructureException {
        List lines;
        long size;
        Path crc = this.path.resolve("inventory-list.hash");
        if (!Files.exists(crc, new LinkOption[0])) {
            throw new InventoryFileDoesNotExistException(crc);
        }
        try {
            size = Files.size(crc);
            if (size > 10000L) {
                throw new InventoryFileTooBigException(crc, size);
            }
            lines = com.google.common.io.Files.readLines((File)crc.toFile(), (Charset)StandardCharsets.UTF_8);
        }
        catch (AccessDeniedException e) {
            throw new InventoryAccessDeniedException(crc, (Throwable)e);
        }
        catch (IOException e) {
            throw new InventoryFileIoException(crc, e);
        }
        if (lines.size() > 1) {
            throw new InventoryFileTooBigException(crc, size);
        }
        if (lines.size() < 1) {
            throw new InventoryFileIsEmptyException(crc);
        }
        return (String)lines.get(0);
    }

    private IInventoryMeta getMetadataInternal(String locale, boolean interruptible) throws InterruptedException {
        if (this != this.inv.getEditingVersion()) {
            this.checkConsistency(interruptible);
            if (interruptible && Thread.interrupted()) {
                throw new InterruptedException(IMessagesList.Messages.metadataExtractionInterrupted());
            }
        }
        CheckingPersister p = new CheckingPersister(this.inv.getPersister(), this.snapshot, this.path);
        if (this.meta == null) {
            Path file = this.path.resolve("installed").resolve("inventory.yml");
            this.meta = new InventoryMeta(this, this.inventoryDefaults.productsHomePath(this.inventoryType), this.environment, Sets.newHashSet());
            if (interruptible) {
                p.loadMeta(this.meta, file);
            } else {
                p.loadMetaUninterruptibly(this.meta, file);
            }
            Path descrDir = this.path.resolve("installed").resolve("descriptions");
            if (interruptible) {
                p.loadDescriptions(this.meta, descrDir.resolve("description_en.yml"), "en");
            } else {
                p.loadDescriptionsUninterruptibly(this.meta, descrDir.resolve("description_en.yml"), "en");
            }
            if (!"en".equals(locale)) {
                if (interruptible) {
                    p.loadDescriptions(this.meta, descrDir.resolve("description_" + locale + ".yml"), locale);
                } else {
                    p.loadDescriptionsUninterruptibly(this.meta, descrDir.resolve("description_" + locale + ".yml"), locale);
                }
            }
        } else if (!this.meta.isLocaleLoaded(locale)) {
            Path descrDir = this.path.resolve("installed").resolve("descriptions");
            if (interruptible) {
                p.loadDescriptions(this.meta, descrDir.resolve("description_" + locale + ".yml"), locale);
            } else {
                p.loadDescriptionsUninterruptibly(this.meta, descrDir.resolve("description_" + locale + ".yml"), locale);
            }
        }
        return this.meta;
    }

    private void checkInterruption(String message) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException(message);
        }
    }

    private static InventoryAccessDeniedException wrapAccessDeniedException(AccessDeniedException e, Path src, Path trg) {
        if (!Files.isReadable(src)) {
            throw new InventoryAccessDeniedException(src, (Throwable)e);
        }
        if (Files.exists(trg, new LinkOption[0]) && !Files.isWritable(trg) || !Files.isWritable(trg.getParent())) {
            throw new InventoryAccessDeniedException(trg, (Throwable)e);
        }
        throw new IllegalStateException("Unexpected reasons for AccessDeniedException", e);
    }
}

