/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Localization {
    public static final String NAME_PARAM = "name";
    public static final String DESCRIPTION_PARAM = "description";
    public static final String HOME_URL_PARAM = "home-url";
    public static final String VENDOR_PARAM = "vendor";
    public static final String GROUP_NAME_PARAM = "group-name";
    static final String DEFAULT_LOCALE = "en";
    private final Map<String, Map<String, String>> vals = new HashMap<String, Map<String, String>>();

    @Nullable
    public Map<String, String> getLocale(String locale) {
        Map<String, String> m = this.vals.get(locale);
        return m != null ? Collections.unmodifiableMap(m) : null;
    }

    @Nonnull
    public String get(String locale, String name, @Nullable String def) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)locale) ? 1 : 0) != 0, (Object)"locale must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name must not be null or empty");
        Map<String, String> l = this.vals.get(locale);
        if (l == null) {
            l = this.vals.get(DEFAULT_LOCALE);
        }
        String ret = null;
        if (l != null) {
            ret = l.get(name);
        }
        if (ret == null) {
            ret = def;
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public void set(String locale, String name, @Nullable String text) {
        Map l = this.vals.computeIfAbsent(locale, s -> new HashMap());
        l.put(name, text);
    }
}

