/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com._1c.chassis.gears.env.IEnvironment;
import com._1c.chassis.gears.env.OsType;
import com._1c.packaging.inventory.InventoryCannotReadEnvironmentVariableException;
import com._1c.packaging.inventory.InventoryType;
import com.google.common.base.Strings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import javax.annotation.Nonnull;

public class OsPaths {
    private final IEnvironment env;

    public OsPaths(IEnvironment env) {
        this.env = env;
    }

    @Nonnull
    public Path getCentralInventoryPath() {
        return Paths.get(this.getProgramDataPath(), new String[0]).resolve("1C").resolve("1CE");
    }

    @Nonnull
    public Path getCurrentUserInventoryPath() {
        Path p = Paths.get(this.getApplicationDataStorePath(), new String[0]);
        p = this.env.getOsType() == OsType.LINUX ? p.resolve(".1C") : p.resolve("1C");
        return p.resolve("1CE");
    }

    @Nonnull
    public Path getDefaultProductsHomePath(InventoryType type) {
        String base;
        switch (type) {
            case USER: {
                base = this.getUserProductsHomePath();
                break;
            }
            case CENTRAL: {
                base = this.getProgramFilesPath();
                break;
            }
            default: {
                throw new IllegalStateException("InventoryType enum was extended but this switch was not");
            }
        }
        return Paths.get(base, new String[0]).resolve("1C").resolve("1CE");
    }

    @Nonnull
    private String getProgramDataPath() {
        OsType os = this.env.getOsType();
        switch (os) {
            case LINUX: {
                return "/etc";
            }
            case WINDOWS: {
                return this.getMandatoryEnvProperty("ProgramData");
            }
            case MAC_OS: {
                return "/Library/Application Support";
            }
        }
        throw new IllegalStateException("Unknown OS");
    }

    @Nonnull
    private String getProgramFilesPath() {
        OsType os = this.env.getOsType();
        switch (os) {
            case LINUX: {
                return "/opt";
            }
            case WINDOWS: {
                return this.getMandatoryEnvProperty("ProgramFiles");
            }
            case MAC_OS: {
                return "/Applications";
            }
        }
        throw new IllegalStateException("Unknown OS");
    }

    @Nonnull
    private String getUserProductsHomePath() {
        OsType os = this.env.getOsType();
        switch (os) {
            case LINUX: {
                return this.getUserHome();
            }
            case MAC_OS: {
                return this.getUserHome() + "/Applications";
            }
            case WINDOWS: {
                return this.getMandatoryEnvProperty("LOCALAPPDATA");
            }
        }
        throw new IllegalStateException("Unknown OS");
    }

    @Nonnull
    private String getApplicationDataStorePath() {
        OsType os = this.env.getOsType();
        switch (os) {
            case LINUX: {
                return this.getUserHome();
            }
            case MAC_OS: {
                return this.getUserHome() + "/Library/Application Support";
            }
            case WINDOWS: {
                return this.getMandatoryEnvProperty("LOCALAPPDATA");
            }
        }
        throw new IllegalStateException("Unknown OS");
    }

    @Nonnull
    private String getUserHome() {
        return AccessController.doPrivileged(() -> System.getProperty("user.home"));
    }

    @Nonnull
    private String getMandatoryEnvProperty(String name) {
        String v = AccessController.doPrivileged(() -> this.env.getEnv(name));
        if (Strings.isNullOrEmpty((String)v)) {
            throw new InventoryCannotReadEnvironmentVariableException(name);
        }
        return v;
    }
}

