/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com._1c.chassis.gears.bytesize.ByteSize;
import com._1c.chassis.gears.env.IEnvironment;
import com._1c.chassis.gears.versions.FullSemanticVersionComparator;
import com._1c.chassis.gears.versions.SemanticVersion;
import com._1c.packaging.inventory.CannotInstallComponentException;
import com._1c.packaging.inventory.FileType;
import com._1c.packaging.inventory.IComponent;
import com._1c.packaging.inventory.IComponentInstallationValidationResult;
import com._1c.packaging.inventory.IDistro;
import com._1c.packaging.inventory.IFileSnapshotVisitor;
import com._1c.packaging.inventory.IInstalledShortcutsVisitor;
import com._1c.packaging.inventory.IMutableComponent;
import com._1c.packaging.inventory.IMutableDistro;
import com._1c.packaging.inventory.IMutableProduct;
import com._1c.packaging.inventory.IProduct;
import com._1c.packaging.inventory.IUninterruptibleFileSnapshotVisitor;
import com._1c.packaging.inventory.InclusionType;
import com._1c.packaging.inventory.internal.Component;
import com._1c.packaging.inventory.internal.ComponentData;
import com._1c.packaging.inventory.internal.ComponentInstallationValidator;
import com._1c.packaging.inventory.internal.InventoryMeta;
import com._1c.packaging.inventory.internal.InventoryVersion;
import com._1c.packaging.inventory.internal.Localization;
import com._1c.packaging.inventory.internal.ProductData;
import com._1c.packaging.model.shared.Architecture;
import com._1c.packaging.model.shared.ComponentKey;
import com._1c.packaging.model.shared.CopyrightPeriod;
import com._1c.packaging.model.shared.DistroKey;
import com._1c.packaging.model.shared.OsType;
import com._1c.packaging.model.shared.ProductKey;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Product
implements IProduct,
IMutableProduct {
    private final ProductKey key;
    private final IDistro distro;
    private final InventoryVersion inventoryVersion;
    private final ComponentInstallationValidator validator;
    private final ProductData data;
    private final Map<ComponentKey, IMutableComponent> oldSingletons = new HashMap<ComponentKey, IMutableComponent>();
    private final FullSemanticVersionComparator versionComparator = new FullSemanticVersionComparator();

    Product(ProductKey productKey, IDistro distro, InventoryVersion inventoryVersion, IEnvironment env, ProductData data) {
        Preconditions.checkArgument((productKey != null ? 1 : 0) != 0, (Object)"productKey must not be null");
        Preconditions.checkArgument((distro != null ? 1 : 0) != 0, (Object)"distro must not be null");
        Preconditions.checkArgument((inventoryVersion != null ? 1 : 0) != 0, (Object)"inventoryVersion must not be null");
        Preconditions.checkArgument((env != null ? 1 : 0) != 0, (Object)"env must not be null");
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"data must not be null");
        this.key = productKey;
        this.distro = distro;
        this.inventoryVersion = inventoryVersion;
        this.validator = new ComponentInstallationValidator(env);
        this.data = data;
    }

    @Nonnull
    public Localization getLocalization() {
        return this.data.localization();
    }

    @Override
    @Nonnull
    public DistroKey getDistroKey() {
        return this.distro.getKey();
    }

    @Override
    @Nonnull
    public ProductKey getKey() {
        return this.key;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.key.getId();
    }

    @Override
    @Nonnull
    public SemanticVersion getVersion() {
        return this.key.getVersion();
    }

    @Override
    @Nonnull
    public OsType getOs() {
        return this.key.getOsType();
    }

    @Override
    @Nonnull
    public Architecture getArch() {
        return this.key.getArchitecture();
    }

    @Override
    @Nonnull
    public ByteSize getOwnSize() {
        return this.data.getOwnSize();
    }

    @Override
    @Nonnull
    public Collection<IComponent> getComponents() {
        return ImmutableList.copyOf(this.data.components().values());
    }

    @Override
    @Nonnull
    public Optional<IComponent> findComponent(ComponentKey componentKey) {
        Preconditions.checkArgument((componentKey != null ? 1 : 0) != 0, (Object)"componentKey must not be null");
        return Optional.ofNullable(this.data.components().get(componentKey));
    }

    @Override
    @Nonnull
    public CopyrightPeriod getCopyrightPeriod() {
        return this.data.getCopyrightPeriod();
    }

    @Override
    @Nonnull
    public String getName(String locale) {
        return this.data.localization().get(locale, "name", this.key.getId());
    }

    @Override
    @Nonnull
    public String getDescription(String locale) {
        return this.data.localization().get(locale, "description", "");
    }

    @Override
    @Nonnull
    public String getHomeUrl(String locale) {
        return this.data.localization().get(locale, "home-url", this.distro.getHomeUrl(locale));
    }

    @Override
    @Nonnull
    public String getVendor(String locale) {
        return this.data.localization().get(locale, "vendor", "");
    }

    @Override
    @Nonnull
    public ZonedDateTime getInstalledAt() {
        return this.data.getInstalledAt();
    }

    @Override
    @Nullable
    public String getLogoImagePath() {
        return this.data.getLogoImagePath();
    }

    @Override
    @Nonnull
    public Set<String> getComponentGroupNames() {
        return Collections.unmodifiableSet(this.data.components().values().stream().map(Component::getGroupId).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet()));
    }

    @Override
    @Nonnull
    public Set<IComponent> getComponentsInGroup(String groupName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupName) ? 1 : 0) != 0, (Object)"groupName must not be null or empty");
        return Collections.unmodifiableSet(this.data.components().values().stream().filter(c -> c.getGroupId().isPresent() && c.getGroupId().get().equals(groupName)).collect(Collectors.toSet()));
    }

    @Override
    public void setLogoImagePath(@Nullable String logoImagePath) {
        this.data.setLogoImagePath(logoImagePath);
    }

    @Override
    public void addLocalization(String locale, String name, @Nullable String text) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)locale) ? 1 : 0) != 0, (Object)"locale must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name must not be null or empty");
        if (text != null) {
            this.data.localization().set(locale, name, text);
        }
    }

    @Override
    public void setNameLocalization(String locale, @Nullable String text) {
        this.addLocalization(locale, "name", text);
    }

    @Override
    public void setDescriptionLocalization(String locale, @Nullable String text) {
        this.addLocalization(locale, "description", text);
    }

    @Override
    public void setHomeUrlLocalization(String locale, @Nullable String text) {
        this.addLocalization(locale, "home-url", text);
    }

    @Override
    public void setVendorLocalization(String locale, @Nullable String text) {
        this.addLocalization(locale, "vendor", text);
    }

    @Override
    public void addFileMeta(String pathName, String sha1, FileType type, boolean modifiable) {
        this.data.installedFiles().addFileMeta(pathName, sha1, type, modifiable);
    }

    @Override
    public void addShortcutFileMeta(String knownFolderAbsolutePath, String relativePath) {
        this.data.addShortcut(knownFolderAbsolutePath, relativePath);
    }

    @Override
    public void snapshotAction(IFileSnapshotVisitor visitor) throws InterruptedException {
        this.data.installedFiles().snapshotAction(visitor);
    }

    @Override
    public void snapshotActionUninterruptibly(IUninterruptibleFileSnapshotVisitor visitor) {
        this.data.installedFiles().snapshotActionUninterruptibly(visitor);
    }

    @Override
    public void forEachShortcut(IInstalledShortcutsVisitor visitor) {
        this.data.forEachShortcut(visitor);
    }

    @Override
    public boolean hasShortcuts() {
        return this.data.hasShortcuts();
    }

    @Override
    @Nonnull
    public Optional<String> getActualFileSha1(String relativeFilePathName) throws InterruptedException {
        return this.data.installedFiles().getActualFileSha1(relativeFilePathName);
    }

    @Override
    @Nonnull
    public Optional<String> getActualFileSha1Uninterruptibly(String relativeFilePathName) {
        return this.data.installedFiles().getActualFileSha1Uninterruptibly(relativeFilePathName);
    }

    @Override
    @Nonnull
    public IMutableComponent installComponentIfAbsent(ComponentKey componentKey, IMutableComponent.IRequiredAttributes attributes) {
        Preconditions.checkArgument((componentKey != null ? 1 : 0) != 0, (Object)"componentKey must not be null");
        Preconditions.checkArgument((attributes != null ? 1 : 0) != 0, (Object)"attributes must not be null");
        Component component = this.data.components().get(componentKey);
        if (component != null) {
            return component;
        }
        IComponentInstallationValidationResult result = this.validator.canInstallComponent(this.inventoryVersion.getMutableMetadata(), this.key, componentKey, attributes);
        if (result.isInstallationOk()) {
            if (attributes.getInclusionType() == InclusionType.SINGLETON) {
                ComponentKey newComponentKey = this.replaceSingletonIfNecessary(componentKey, attributes);
                Optional<IMutableComponent> c = this.getMutableComponent(newComponentKey);
                if (c.isPresent()) {
                    return c.get();
                }
                if (this.oldSingletons.containsKey(newComponentKey)) {
                    IMutableComponent old = this.oldSingletons.get(newComponentKey);
                    ComponentData oldComponentData = this.inventoryVersion.getMutableMetadata().acquireComponentData(newComponentKey, old.view().getInclusionType(), old.view().getSize());
                    Component oldCompInNewProduct = new Component(newComponentKey, this, oldComponentData, attributes.isRequired());
                    this.data.components().put(newComponentKey, oldCompInNewProduct);
                    return oldCompInNewProduct;
                }
            }
            return this.addComponent(componentKey, attributes);
        }
        throw new CannotInstallComponentException(result, componentKey);
    }

    public Component addComponent(ComponentKey componentKey, IMutableComponent.IRequiredAttributes attributes) {
        Preconditions.checkArgument((componentKey != null ? 1 : 0) != 0, (Object)"componentKey must not be null");
        Preconditions.checkArgument((attributes != null ? 1 : 0) != 0, (Object)"inclusionType must not be null");
        ComponentData componentData = this.inventoryVersion.getMutableMetadata().acquireComponentData(componentKey, attributes.getInclusionType(), attributes.getSize());
        Component component = new Component(componentKey, this, componentData, attributes.isRequired());
        this.data.components().put(componentKey, component);
        return component;
    }

    @Override
    @Nonnull
    public Optional<IMutableComponent> getMutableComponent(ComponentKey componentKey) {
        Preconditions.checkArgument((componentKey != null ? 1 : 0) != 0, (Object)"componentKey must not be null");
        return Optional.ofNullable(this.data.components().get(componentKey));
    }

    @Override
    public void uninstallComponentIfPresent(ComponentKey componentKey) {
        Preconditions.checkArgument((componentKey != null ? 1 : 0) != 0, (Object)"componentKey must not be null");
        IComponent c = this.data.components().remove(componentKey);
        if (c != null) {
            this.inventoryVersion.getMutableMetadata().releaseComponentData(componentKey);
        }
    }

    @Override
    @Nonnull
    public IComponentInstallationValidationResult canInstallComponent(ComponentKey componentKey, IMutableComponent.IRequiredAttributes attributes) {
        Preconditions.checkArgument((componentKey != null ? 1 : 0) != 0, (Object)"componentKey must not be null");
        Preconditions.checkArgument((attributes != null ? 1 : 0) != 0, (Object)"attributes must not be null");
        return this.validator.canInstallComponent(this.inventoryVersion.getMutableMetadata(), this.key, componentKey, attributes);
    }

    @Override
    @Nonnull
    public IProduct view() {
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Product [");
        sb.append("uid=[").append(this.key).append(']');
        sb.append(", components=[").append(this.data.components()).append(']');
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Product product = (Product)o;
        return this.key.equals((Object)product.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    ProductData getData() {
        return this.data;
    }

    private ComponentKey replaceSingletonIfNecessary(ComponentKey componentKey, IMutableComponent.IRequiredAttributes attributes) {
        Optional<ComponentKey> replacedComponentKey = this.replaceSingletonInAllProductsIfNecessary(componentKey, attributes);
        if (replacedComponentKey.isPresent() && !replacedComponentKey.get().equals((Object)componentKey)) {
            return replacedComponentKey.get();
        }
        return componentKey;
    }

    private Optional<ComponentKey> replaceSingletonInAllProductsIfNecessary(ComponentKey newKey, IMutableComponent.IRequiredAttributes attributes) {
        Preconditions.checkArgument((newKey != null ? 1 : 0) != 0, (Object)"newKey must be not null");
        Preconditions.checkArgument((attributes != null ? 1 : 0) != 0, (Object)"attributes must be not null");
        Preconditions.checkArgument((attributes.getInclusionType() == InclusionType.SINGLETON ? 1 : 0) != 0, (Object)"inclusionType must be singleton for replacement");
        this.checkSingletonPreInstallation(newKey, attributes);
        Optional<ComponentKey> result = Optional.empty();
        InventoryMeta meta = this.inventoryVersion.getMutableMetadata();
        for (IDistro someDistro : meta.view().getDistros()) {
            for (IProduct product : someDistro.getProducts()) {
                Optional<IComponent> component = this.getSingletonComponent(product, newKey);
                if (!component.isPresent()) continue;
                ComponentKey oldKey = component.get().getKey();
                if (this.versionComparator.compare(oldKey.getVersion(), newKey.getVersion()) > 0) {
                    this.oldSingletons.put(oldKey, this.inventoryVersion.getMutableMetadata().getMutableDistro(someDistro.getKey()).get().getMutableProduct(product.getKey()).get().getMutableComponent(oldKey).get());
                    return Optional.of(oldKey);
                }
                IMutableDistro mutableDistro = meta.getMutableDistro(someDistro.getKey()).get();
                IMutableProduct mutableProduct = mutableDistro.getMutableProduct(product.getKey()).get();
                result = Optional.of(newKey);
                IMutableComponent mutableComponent = mutableProduct.getMutableComponent(oldKey).get();
                IMutableComponent.IRequiredAttributes attrs = IMutableComponent.attributesBuilder().inclusionType(InclusionType.SINGLETON).required(component.get().isRequired()).size(attributes.getSize()).build();
                Product pr = (Product)product;
                pr.getData().components().remove(oldKey);
                meta.releaseComponentData(oldKey);
                HashSet componentsWithRemovedDependency = new HashSet();
                pr.getData().components().values().forEach(c -> {
                    if (c.view().dependsOn(((IComponent)component.get()).getKey())) {
                        c.removeDependencyIfPresent(mutableComponent);
                        componentsWithRemovedDependency.add(c);
                    }
                });
                Component replacement = pr.addComponent(newKey, attrs);
                component.get().getGroupId().ifPresent(replacement::setGroupName);
                pr.getData().components().values().forEach(c -> {
                    if (componentsWithRemovedDependency.contains(c)) {
                        c.addDependencyIfAbsent(replacement);
                    }
                });
            }
        }
        return result;
    }

    private void checkSingletonPreInstallation(ComponentKey newKey, IMutableComponent.IRequiredAttributes attributes) {
        this.inventoryVersion.getMutableMetadata().productsStream().forEach(product -> {
            IComponentInstallationValidationResult validationResult;
            if (!product.findComponent(newKey).isPresent() && !(validationResult = this.validator.canInstallComponent(this.inventoryVersion.getMutableMetadata(), product.getKey(), newKey, attributes)).isInstallationOk()) {
                throw new CannotInstallComponentException(validationResult, newKey);
            }
        });
    }

    private Optional<IComponent> getSingletonComponent(IProduct product, ComponentKey key) {
        return product.getComponents().stream().filter(c -> c.getId().equals(key.getId())).filter(c -> c.getOs().equals((Object)key.getOsType())).filter(c -> c.getArch().equals((Object)key.getArchitecture())).findAny();
    }
}

