/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com._1c.chassis.gears.bytesize.ByteSize;
import com._1c.packaging.inventory.IInstalledShortcutsVisitor;
import com._1c.packaging.inventory.IMutableProduct;
import com._1c.packaging.inventory.InstalledFilesLayout;
import com._1c.packaging.inventory.internal.Component;
import com._1c.packaging.inventory.internal.IPersistentData;
import com._1c.packaging.inventory.internal.InstalledFilesContainerMixin;
import com._1c.packaging.inventory.internal.InstalledShortcut;
import com._1c.packaging.inventory.internal.InventoryVersion;
import com._1c.packaging.inventory.internal.Localization;
import com._1c.packaging.model.shared.ComponentKey;
import com._1c.packaging.model.shared.CopyrightPeriod;
import com._1c.packaging.model.shared.ProductKey;
import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ProductData
implements IPersistentData {
    private final ProductKey key;
    private final Map<ComponentKey, Component> components = new LinkedHashMap<ComponentKey, Component>();
    private final Localization localization = new Localization();
    private final InventoryVersion inventoryVersion;
    private final InstalledFilesContainerMixin installedFiles;
    private final List<InstalledShortcut> shortcuts = new ArrayList<InstalledShortcut>();
    private final CopyrightPeriod copyrightPeriod;
    private final ByteSize ownSize;
    private final ZonedDateTime installedAt;
    private String logoImagePath;

    ProductData(ProductKey productKey, InventoryVersion inventoryVersion, IMutableProduct.IRequiredAttributes attributes) {
        Preconditions.checkArgument((productKey != null ? 1 : 0) != 0, (Object)"productKey must not be null");
        Preconditions.checkArgument((inventoryVersion != null ? 1 : 0) != 0, (Object)"inventoryVersion must not be null");
        Preconditions.checkArgument((attributes != null ? 1 : 0) != 0, (Object)"attributes must not be null");
        this.key = productKey;
        this.inventoryVersion = inventoryVersion;
        this.installedFiles = new InstalledFilesContainerMixin(this::resolveProductFile);
        this.copyrightPeriod = attributes.getCopyrightPeriod();
        this.ownSize = attributes.getOwnSize();
        this.installedAt = attributes.getInstalledAt();
    }

    @Nonnull
    Map<ComponentKey, Component> components() {
        return this.components;
    }

    @Nonnull
    Localization localization() {
        return this.localization;
    }

    @Nonnull
    InstalledFilesContainerMixin installedFiles() {
        return this.installedFiles;
    }

    void addShortcut(String knownFolderAbsolutePath, String relativePath) {
        this.shortcuts.add(new InstalledShortcut(knownFolderAbsolutePath, relativePath));
    }

    void forEachShortcut(IInstalledShortcutsVisitor visitor) {
        this.shortcuts.forEach(s -> visitor.visit(s.getKnownFolderName(), s.getRelativePath()));
    }

    boolean hasShortcuts() {
        return !this.shortcuts.isEmpty();
    }

    @Nonnull
    ByteSize getOwnSize() {
        return this.ownSize;
    }

    @Nonnull
    public CopyrightPeriod getCopyrightPeriod() {
        return this.copyrightPeriod;
    }

    @Nonnull
    ZonedDateTime getInstalledAt() {
        return this.installedAt;
    }

    @Nullable
    String getLogoImagePath() {
        return this.logoImagePath;
    }

    void setLogoImagePath(@Nullable String logoImagePath) {
        this.logoImagePath = logoImagePath;
    }

    @Override
    public void deleteData() {
        this.components.keySet().forEach(componentKey -> this.inventoryVersion.getMutableMetadata().releaseComponentData((ComponentKey)componentKey));
        this.components.clear();
    }

    private Path resolveProductFile(String relativeFilePathName) {
        try {
            Path productsHome = this.inventoryVersion.getMetadata().getProductsHome();
            return InstalledFilesLayout.getProductDir(productsHome, this.key).resolve(relativeFilePathName);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ProductData [");
        sb.append("key=[").append(this.key).append(']');
        sb.append(", copyrightPeriod=[").append(this.copyrightPeriod).append(']');
        sb.append(", ownSize=[").append(this.ownSize).append(']');
        sb.append(", logoImagePath=[").append(this.logoImagePath).append(']');
        String keys = this.components.keySet().stream().map(ComponentKey::toString).collect(Collectors.joining("; "));
        sb.append(", components=[").append(keys).append("], installedAt=[").append(this.installedAt);
        sb.append("]]");
        return sb.toString();
    }
}

