/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com._1c.chassis.gears.env.IEnvironment;
import com._1c.chassis.gears.env.OsType;
import com._1c.packaging.inventory.IMutableProduct;
import com._1c.packaging.inventory.IProduct;
import com._1c.packaging.inventory.IProductInstallationValidationResult;
import com._1c.packaging.inventory.internal.IMessagesList;
import com._1c.packaging.inventory.internal.InventoryMeta;
import com._1c.packaging.inventory.internal.TargetArchitectureRule;
import com._1c.packaging.inventory.internal.TargetOsRule;
import com._1c.packaging.model.shared.Architecture;
import com._1c.packaging.model.shared.DistroKey;
import com._1c.packaging.model.shared.ProductKey;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ProductInstallationValidator {
    private final IEnvironment env;
    private final TargetOsRule targetOsRule;
    private final TargetArchitectureRule targetArchitectureRule;

    ProductInstallationValidator(IEnvironment env) {
        this.env = env;
        this.targetOsRule = new TargetOsRule(env);
        this.targetArchitectureRule = new TargetArchitectureRule(env);
    }

    IProductInstallationValidationResult canInstallProduct(InventoryMeta meta, DistroKey distroKey, ProductKey productKey, IMutableProduct.IRequiredAttributes attributes) {
        List productsWithSameId = meta.productsStream().filter(p -> p.getId().equals(productKey.getId())).collect(Collectors.toList());
        IProduct duplicate = productsWithSameId.stream().filter(p -> p.getDistroKey().equals((Object)distroKey)).filter(p -> p.getVersion().equals((Object)productKey.getVersion()) && p.getOs().equals((Object)productKey.getOsType()) && p.getArch().equals((Object)productKey.getArchitecture())).findAny().orElse(null);
        boolean wrongOs = !this.targetOsRule.satisfied(productKey.getOsType());
        boolean wrongArch = !this.targetArchitectureRule.satisfied(productKey.getArchitecture());
        Predicate<IProduct> anyAndSpecArchFilter = p -> p.getArch().equals((Object)Architecture.ANYARCH) && !productKey.getArchitecture().equals((Object)Architecture.ANYARCH) || !p.getArch().equals((Object)Architecture.ANYARCH) && productKey.getArchitecture().equals((Object)Architecture.ANYARCH);
        IProduct anyAndSpecArch = productsWithSameId.stream().filter(p -> p.getVersion().equals((Object)productKey.getVersion())).filter(anyAndSpecArchFilter).findAny().orElse(null);
        Predicate<IProduct> anyAndSpecOsFilter = p -> p.getOs().equals((Object)com._1c.packaging.model.shared.OsType.ANYOS) && !productKey.getOsType().equals((Object)com._1c.packaging.model.shared.OsType.ANYOS) || !p.getOs().equals((Object)com._1c.packaging.model.shared.OsType.ANYOS) && productKey.getOsType().equals((Object)com._1c.packaging.model.shared.OsType.ANYOS);
        IProduct anyAndSpecOs = productsWithSameId.stream().filter(p -> p.getVersion().equals((Object)productKey.getVersion())).filter(anyAndSpecOsFilter).findAny().orElse(null);
        return new ProductInstallationValidationResultImpl(duplicate, wrongOs, wrongArch, anyAndSpecArch, anyAndSpecOs, this.env.getOsType());
    }

    private static final class ProductInstallationValidationResultImpl
    implements IProductInstallationValidationResult {
        private final IProduct duplicate;
        private final boolean wrongOs;
        private final boolean wrongArch;
        private final IProduct anyAndSpecArch;
        private final IProduct anyAndSpecOs;
        private final OsType osType;

        ProductInstallationValidationResultImpl(@Nullable IProduct duplicate, boolean wrongOs, boolean wrongArch, @Nullable IProduct anyAndSpecArch, @Nullable IProduct anyAndSpecOs, OsType osType) {
            this.duplicate = duplicate;
            this.wrongOs = wrongOs;
            this.wrongArch = wrongArch;
            this.anyAndSpecArch = anyAndSpecArch;
            this.anyAndSpecOs = anyAndSpecOs;
            this.osType = osType;
        }

        @Override
        @Nonnull
        public Optional<IProduct> getDuplicate() {
            return Optional.ofNullable(this.duplicate);
        }

        @Override
        public boolean isWrongOs() {
            return this.wrongOs;
        }

        @Override
        public boolean isWrongArch() {
            return this.wrongArch;
        }

        @Override
        @Nonnull
        public Optional<IProduct> getAnyAndSpecArch() {
            return Optional.ofNullable(this.anyAndSpecArch);
        }

        @Override
        @Nonnull
        public Optional<IProduct> getAnyAndSpecOs() {
            return Optional.ofNullable(this.anyAndSpecOs);
        }

        @Override
        public boolean isInstallationOk() {
            return this.duplicate == null && !this.wrongOs && !this.wrongArch && this.anyAndSpecArch == null && this.anyAndSpecOs == null;
        }

        @Override
        @Nonnull
        public String getTextErrorReport() {
            if (this.isInstallationOk()) {
                return IMessagesList.Messages.ok();
            }
            ArrayList<String> messages = new ArrayList<String>();
            if (this.duplicate != null) {
                messages.add(IMessagesList.Messages.sameProductAlreadyInstalled(this.duplicate.getKey()));
            }
            if (this.wrongOs) {
                com._1c.packaging.model.shared.OsType currentOs = com._1c.packaging.model.shared.OsType.fromGears((OsType)this.osType);
                messages.add(IMessagesList.Messages.cannotInstallOnOsOtherThenCurrentMachine(currentOs.getDisplayName()));
            }
            if (this.wrongArch) {
                messages.add(IMessagesList.Messages.cannotInstallOnArchMismatch());
            }
            if (this.anyAndSpecOs != null) {
                messages.add(IMessagesList.Messages.cannotInstallAnyAndSpecialOsAtOnce(this.anyAndSpecOs.getOs().getDisplayName()));
            }
            if (this.anyAndSpecArch != null) {
                messages.add(IMessagesList.Messages.cannotInstallAnyAndSpecialArchAtOnce(this.anyAndSpecArch.getArch().getName()));
            }
            Preconditions.checkState((!messages.isEmpty() ? 1 : 0) != 0, (String)"Error report problem. Report state is %s", (Object)this);
            return messages.stream().collect(Collectors.joining(System.lineSeparator()));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ProductInstallationValidationResultImpl [");
            sb.append("installationOk=[").append(this.isInstallationOk()).append(']');
            sb.append(", duplicate=[").append(this.duplicate).append(']');
            sb.append(", wrongOs=[").append(this.wrongOs).append(']');
            sb.append(", wrongArch=[").append(this.wrongArch).append(']');
            sb.append(", anyAndSpecArch=[").append(this.anyAndSpecArch).append(']');
            sb.append(", anyAndSpecOs=[").append(this.anyAndSpecOs).append(']');
            sb.append(']');
            return sb.toString();
        }
    }
}

