/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com._1c.chassis.gears.bytesize.ByteSize;
import com._1c.packaging.inventory.IMutableProduct;
import com._1c.packaging.model.shared.CopyrightPeriod;
import com.google.common.base.Preconditions;
import java.time.ZonedDateTime;
import javax.annotation.Nonnull;

public final class ProductRequiredAttributes
implements IMutableProduct.IRequiredAttributes {
    private final CopyrightPeriod cp;
    private final ByteSize ownSize;
    private final ZonedDateTime installedAt;

    private ProductRequiredAttributes(ProductRequiredAttributesBuilder b) {
        this.cp = b.cp;
        this.ownSize = b.ownSize;
        this.installedAt = b.installedAt;
    }

    @Override
    @Nonnull
    public CopyrightPeriod getCopyrightPeriod() {
        return this.cp;
    }

    @Override
    @Nonnull
    public ByteSize getOwnSize() {
        return this.ownSize;
    }

    @Override
    @Nonnull
    public ZonedDateTime getInstalledAt() {
        return this.installedAt;
    }

    public String toString() {
        return "ProductRequiredAttributes{cp=" + this.cp + ", ownSize=" + this.ownSize + ", installedAt=" + this.installedAt + '}';
    }

    public static class ProductRequiredAttributesBuilder
    implements IMutableProduct.IRequiredAttributesBuilder {
        private CopyrightPeriod cp;
        private ByteSize ownSize;
        private ZonedDateTime installedAt = ZonedDateTime.now();

        @Override
        @Nonnull
        public IMutableProduct.IRequiredAttributesBuilder copyrightPeriod(CopyrightPeriod copyrightPeriod) {
            Preconditions.checkArgument((copyrightPeriod != null ? 1 : 0) != 0, (Object)"copyrightPeriod must not be null");
            this.cp = copyrightPeriod;
            return this;
        }

        @Override
        @Nonnull
        public IMutableProduct.IRequiredAttributesBuilder ownSize(ByteSize ownSize) {
            Preconditions.checkArgument((ownSize != null ? 1 : 0) != 0, (Object)"ownSize must not be null");
            this.ownSize = ownSize;
            return this;
        }

        @Override
        @Nonnull
        public IMutableProduct.IRequiredAttributesBuilder ownSize(String ownSize) {
            this.ownSize = ByteSize.fromString((String)ownSize);
            return this;
        }

        @Override
        @Nonnull
        public IMutableProduct.IRequiredAttributesBuilder copyrightPeriod(String copyrightPeriod) {
            this.cp = CopyrightPeriod.fromRangeString((String)copyrightPeriod);
            return this;
        }

        @Override
        @Nonnull
        public IMutableProduct.IRequiredAttributesBuilder installedAt(ZonedDateTime installedAt) {
            Preconditions.checkArgument((installedAt != null ? 1 : 0) != 0, (Object)"installedAt must not be null");
            this.installedAt = installedAt;
            return this;
        }

        @Override
        @Nonnull
        public IMutableProduct.IRequiredAttributes build() {
            Preconditions.checkState((this.cp != null ? 1 : 0) != 0, (Object)"copyrightPeriod must not be null");
            Preconditions.checkState((this.ownSize != null ? 1 : 0) != 0, (Object)"ownSize must not be null");
            Preconditions.checkState((this.installedAt != null ? 1 : 0) != 0, (Object)"installedAt must not be null");
            return new ProductRequiredAttributes(this);
        }
    }
}

