/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.annotation.Nonnull;

public final class TransactionalFileReader {
    private final Path base;
    private final String name;
    private String content;

    public static TransactionalFileReader createFileForReading(Path base, String name) {
        return new TransactionalFileReader(base, name);
    }

    private TransactionalFileReader(Path base, String name) {
        Preconditions.checkArgument((base != null ? 1 : 0) != 0, (Object)"base must not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name must not be null or empty");
        this.base = base;
        this.name = name;
    }

    public String read() throws IOException {
        Preconditions.checkState((this.content == null ? 1 : 0) != 0, (Object)("File " + this.name + " has already read"));
        Path file = this.base.resolve(this.name);
        Path tmp = this.base.resolve(this.name + ".tmp");
        try {
            this.content = Files.asCharSource((File)file.toFile(), (Charset)StandardCharsets.UTF_8).read();
        }
        catch (FileNotFoundException e) {
            this.content = Files.asCharSource((File)tmp.toFile(), (Charset)StandardCharsets.UTF_8).read();
        }
        return this.content;
    }

    @Nonnull
    public String getContent() throws IllegalStateException {
        Preconditions.checkState((this.content != null ? 1 : 0) != 0, (Object)("File " + this.name + " is not read yet"));
        return this.content;
    }
}

