/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

public final class TransactionalFileWriter {
    private final Path base;
    private final String name;
    private final String content;
    private boolean written;

    public static TransactionalFileWriter createFileForWriting(Path base, String name, String content) {
        return new TransactionalFileWriter(base, name, content);
    }

    private TransactionalFileWriter(Path base, String name, String content) {
        Preconditions.checkArgument((base != null ? 1 : 0) != 0, (Object)"base must not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)content) ? 1 : 0) != 0, (Object)"content must not be null or empty");
        this.base = base;
        this.name = name;
        this.content = content;
    }

    public void write() throws IOException {
        Preconditions.checkState((!this.written ? 1 : 0) != 0, (Object)("File " + this.name + " has already been written"));
        Path f = this.base.resolve(this.name);
        Path tmp = this.base.resolve(this.name + ".tmp");
        this.execIgnoringAbsence(() -> {
            if (!Files.exists(f, new LinkOption[0]) && Files.exists(tmp, new LinkOption[0])) {
                Files.move(tmp, f, StandardCopyOption.ATOMIC_MOVE);
            }
        });
        com.google.common.io.Files.write((byte[])this.content.getBytes(StandardCharsets.UTF_8), (File)tmp.toFile());
        this.execIgnoringAbsence(() -> Files.delete(f));
        Files.move(tmp, f, StandardCopyOption.ATOMIC_MOVE);
        this.written = true;
    }

    private void execIgnoringAbsence(IThrowingRunnable r) throws IOException {
        try {
            r.run();
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    private static interface IThrowingRunnable {
        public void run() throws IOException;
    }
}

