/*
 * Decompiled with CFR 0.152.
 */
package com._1c.packaging.inventory.internal.yaml;

import com._1c.chassis.gears.bytesize.ByteSize;
import com._1c.chassis.gears.digest.FileDigester;
import com._1c.chassis.gears.versions.SemanticVersion;
import com._1c.packaging.inventory.AttributeDoesNotExistException;
import com._1c.packaging.inventory.BrokenComponentDependencyException;
import com._1c.packaging.inventory.Feature;
import com._1c.packaging.inventory.FileType;
import com._1c.packaging.inventory.IComponent;
import com._1c.packaging.inventory.IDistro;
import com._1c.packaging.inventory.IDistroSource;
import com._1c.packaging.inventory.IFileMeta;
import com._1c.packaging.inventory.IFileSnapshotVisitor;
import com._1c.packaging.inventory.IInstallerComponent;
import com._1c.packaging.inventory.IMutableComponent;
import com._1c.packaging.inventory.IMutableInstalledFilesContainer;
import com._1c.packaging.inventory.IMutableInstallerComponent;
import com._1c.packaging.inventory.IMutableProduct;
import com._1c.packaging.inventory.IMutableShortcutsContainer;
import com._1c.packaging.inventory.IProduct;
import com._1c.packaging.inventory.IUninterruptibleFileSnapshotVisitor;
import com._1c.packaging.inventory.InclusionType;
import com._1c.packaging.inventory.InvalidValueException;
import com._1c.packaging.inventory.InvalidVersionFormatException;
import com._1c.packaging.inventory.InventoryAccessDeniedException;
import com._1c.packaging.inventory.InventoryFileFormatException;
import com._1c.packaging.inventory.InventoryFileIoException;
import com._1c.packaging.inventory.InventoryFileIsEmptyException;
import com._1c.packaging.inventory.InventoryFileTooBigException;
import com._1c.packaging.inventory.InventoryLocationLockedException;
import com._1c.packaging.inventory.InventoryLocationReadInterruptedException;
import com._1c.packaging.inventory.InventoryStructureException;
import com._1c.packaging.inventory.RingModuleInfo;
import com._1c.packaging.inventory.internal.Component;
import com._1c.packaging.inventory.internal.Distro;
import com._1c.packaging.inventory.internal.DistroSource;
import com._1c.packaging.inventory.internal.FilesSnapshot;
import com._1c.packaging.inventory.internal.IPersister;
import com._1c.packaging.inventory.internal.InventoryLocation;
import com._1c.packaging.inventory.internal.InventoryMeta;
import com._1c.packaging.inventory.internal.InventoryVersion;
import com._1c.packaging.inventory.internal.Localization;
import com._1c.packaging.inventory.internal.Product;
import com._1c.packaging.inventory.internal.TransactionalFileWriter;
import com._1c.packaging.inventory.internal.yaml.IMessagesList;
import com._1c.packaging.model.shared.Architecture;
import com._1c.packaging.model.shared.ComponentKey;
import com._1c.packaging.model.shared.CopyrightPeriod;
import com._1c.packaging.model.shared.DistroKey;
import com._1c.packaging.model.shared.OsType;
import com._1c.packaging.model.shared.ProductKey;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class YamlPersister
implements IPersister {
    private static final List<String> NON_RESOLVED_TAGS = Arrays.asList(Tag.TIMESTAMP.getValue(), Tag.BOOL.getValue(), Tag.FLOAT.getValue(), Tag.INT.getValue(), Tag.STR.getValue());
    private static final Logger LOGGER = LoggerFactory.getLogger(YamlPersister.class);
    private static final String ID_FIELD = "id";
    private static final String VERSION_FIELD = "version";
    private static final String OS_FIELD = "os";
    private static final String ARCH_FIELD = "arch";
    private static final String TYPE_FIELD = "type";
    private static final String SHA1_FIELD = "sha1";
    private static final String MODIFIABLE_FIELD = "modifiable";
    private static final String NAME_FIELD = "name";
    private static final String COPYRIGHT_PERIOD_FIELD = "copyright-period";
    private static final String INCLUSION_TYPE_FIELD = "inclusion-type";
    private static final String SIZE_FIELD = "size";
    private static final String COMPONENT_GROUP_ID_FIELD = "group";
    private static final String OWN_SIZE_FIELD = "own-size";
    private static final String LOGO_IMAGE_PATH = "logo-image-path";
    private static final String INSTALLED_AT_FIELD = "installed-at";
    private static final String REQUIRED_FIELD = "required";
    private static final String INVENTORY_ROOT_PATH_FIELD = "inventory-root-path";
    private static final String INVENTORY_VERSION_FIELD = "inventory-version";
    private static final String INVENTORY_LOCATION_STRUCT = "inventory-location";
    private static final String PRODUCTS_HOME_FIELD = "products-home";
    private static final String METADATA_FORMAT_VERSION_FIELD = "metadata-format-version";
    private static final String VERSION_CREATED_AT_FIELD = "version-created-at";
    private static final String VERSION_CREATED_BY_FIELD = "version-created-by";
    private static final String PATH_FIELD = "path";
    private static final String RING_MODULES_FIELD = "ring-modules";
    private static final String RING_MODULE_NAME = "name";
    private static final String RING_MODULE_FILE = "file";
    private static final String INVENTORY_STRUCT = "inventory";
    private static final String DISTROS_STRUCT = "distros";
    private static final String FEATURES_LIST = "features";
    private static final String INSTALLER_STRUCT = "installer";
    private static final String SOURCE_STRUCT = "source";
    private static final String INVENTORY_DESCRIPTION_STRUCT = "inventory-description";
    private static final String ATTRIBUTES_LIST = "attributes";
    private static final String PATHS_LIST = "paths";
    private static final String PRODUCTS_LIST = "products";
    private static final String COMPONENTS_LIST = "components";
    private static final String DEPENDENCIES_LIST = "dependencies";
    private static final String DISTROS_DESCRIPTION_LIST = "distros-description";
    private static final String PRODUCTS_DESCRIPTION_LIST = "products-description";
    private static final String COMPONENTS_DESCRIPTION_LIST = "components-description";
    private static final String INVENTORY_COMPONENT_FILES_LIST = "inventory-component-files";
    private static final String INVENTORY_PRODUCTS_FILES_LIST = "inventory-products-files";
    private static final String FILES_LIST = "files";
    private static final String SHORTCUTS_LIST = "shortcuts";
    private static final String SHORTCUT_KNOWN_FOLDER = "known-folder";
    private static final String SHORTCUT_PATH = "path";
    private static final String INVENTORY_LIST_LIST = "inventory-list";
    private static final int MAX_REPETITIONS_INVENTORY_LOCK_FILE_ATTEMPTS = 5;

    @Override
    @Nonnull
    public InventoryLocation loadInventoryLocation(Path inventoryLocDir) throws InventoryLocationLockedException, InventoryLocationReadInterruptedException, InventoryAccessDeniedException {
        Path inventoryLocFile = inventoryLocDir.resolve("inventory.loc");
        String content = this.readInventoryLocFileContent(inventoryLocFile);
        LOGGER.debug("before parsing YAML {}", (Object)inventoryLocFile.toString());
        Map<String, Object> map = this.loadAsYamlMap(content, inventoryLocFile);
        LOGGER.debug("YAML parsed");
        Map<String, Object> inventoryLoc = YamlPersister.getRequiredMap(inventoryLocFile, map, INVENTORY_LOCATION_STRUCT);
        InventoryLocation ret = new InventoryLocation();
        ret.setRootPath(YamlPersister.getRequiredPath(inventoryLocFile, inventoryLoc, INVENTORY_ROOT_PATH_FIELD));
        ret.setVersion(YamlPersister.getRequiredInt(inventoryLocFile, inventoryLoc, INVENTORY_VERSION_FIELD));
        return ret;
    }

    @Override
    public void saveInventoryLocationTransactionally(Path inventoryLocDir, InventoryLocation il) {
        LOGGER.debug("before serializing YAML inventory.loc");
        LinkedHashMap map = new LinkedHashMap();
        LinkedHashMap<String, String> inventoryLoc = new LinkedHashMap<String, String>();
        map.put(INVENTORY_LOCATION_STRUCT, inventoryLoc);
        inventoryLoc.put(INVENTORY_ROOT_PATH_FIELD, il.getRootPath().toAbsolutePath().normalize().toString());
        inventoryLoc.put(INVENTORY_VERSION_FIELD, String.valueOf(il.getVersion()));
        LOGGER.debug("before saving YAML inventory.loc");
        String yaml = YamlPersister.createYaml().dump(map);
        LOGGER.debug("YAML saved");
        TransactionalFileWriter tfr = TransactionalFileWriter.createFileForWriting(inventoryLocDir, "inventory.loc", yaml);
        try {
            tfr.write();
        }
        catch (AccessDeniedException e) {
            throw new InventoryAccessDeniedException(inventoryLocDir, (Throwable)e);
        }
        catch (IOException e) {
            throw new InventoryFileIoException(inventoryLocDir, e);
        }
    }

    @Override
    public void loadMeta(InventoryMeta im, Path file) {
        String content = this.readFileContent(file, 100000000);
        if (content == null) {
            throw new InventoryFileIsEmptyException(file);
        }
        LOGGER.debug("before parsing YAML {}", (Object)file.toString());
        Map<String, Object> map = this.loadAsYamlMap(content, file);
        LOGGER.debug("YAML parsed");
        Map<String, Object> inventory = YamlPersister.getRequiredMap(file, map, INVENTORY_STRUCT);
        Path productsHomePath = YamlPersister.getRequiredPath(file, inventory, PRODUCTS_HOME_FIELD);
        im.setProductsHome(productsHomePath);
        im.setMetadataFormatVersion(YamlPersister.getRequiredFormatVersion(file, inventory, METADATA_FORMAT_VERSION_FIELD));
        im.setCreatedAt(YamlPersister.getRequiredDate(file, inventory, VERSION_CREATED_AT_FIELD));
        im.setCreatedBy(YamlPersister.getRequiredString(file, inventory, VERSION_CREATED_BY_FIELD));
        Set<Feature> features = YamlPersister.getRequiredFeatures(file, inventory);
        im.setFeatures(features);
        Map<String, Object> i = YamlPersister.getOptionalMap(file, inventory, INSTALLER_STRUCT);
        if (i != null) {
            SemanticVersion version = YamlPersister.getRequiredSemanticVersion(file, i, VERSION_FIELD);
            OsType os = YamlPersister.getRequiredOs(file, i);
            Architecture arch = YamlPersister.getRequiredArch(file, i);
            im.setInstallerComponent(version, os, arch);
        }
        List<Map<String, Object>> distros = YamlPersister.getRequiredMapsList(file, inventory, DISTROS_STRUCT);
        for (Map<String, Object> distro : distros) {
            String id = YamlPersister.getRequiredString(file, distro, ID_FIELD);
            SemanticVersion version = YamlPersister.getRequiredSemanticVersion(file, distro, VERSION_FIELD);
            OsType os = YamlPersister.getRequiredOs(file, distro);
            Architecture arch = YamlPersister.getRequiredArch(file, distro);
            Distro d = im.addDistro(new DistroKey(id, version, os, arch));
            Map<String, Object> source = YamlPersister.getOptionalMap(file, distro, SOURCE_STRUCT);
            if (source != null) {
                IDistroSource.SourceType st = YamlPersister.getOptionalDistroSourceType(file, source);
                String path = YamlPersister.getOptionalString(file, source, "path");
                DistroSource ds = (DistroSource)DistroSource.of(st, path);
                d.setSource(ds);
            }
            List<Map<String, Object>> products = YamlPersister.getRequiredMapsList(file, distro, PRODUCTS_LIST);
            for (Map<String, Object> product : products) {
                id = YamlPersister.getRequiredString(file, product, ID_FIELD);
                version = YamlPersister.getRequiredSemanticVersion(file, product, VERSION_FIELD);
                os = YamlPersister.getRequiredOs(file, product);
                arch = YamlPersister.getRequiredArch(file, product);
                String cp = YamlPersister.getRequiredString(file, product, COPYRIGHT_PERIOD_FIELD);
                String productSize = YamlPersister.getRequiredString(file, product, OWN_SIZE_FIELD);
                IMutableProduct.IRequiredAttributes pattributes = IMutableProduct.attributesBuilder().copyrightPeriod(cp).ownSize(productSize).installedAt(YamlPersister.getRequiredDate(file, product, INSTALLED_AT_FIELD)).build();
                Product p = d.addProduct(new ProductKey(id, version, os, arch), pattributes);
                p.setLogoImagePath(YamlPersister.getOptionalString(file, product, LOGO_IMAGE_PATH));
                List<Map<String, Object>> components = YamlPersister.getRequiredMapsList(file, product, COMPONENTS_LIST);
                for (Map<String, Object> component : components) {
                    id = YamlPersister.getRequiredString(file, component, ID_FIELD);
                    version = YamlPersister.getRequiredSemanticVersion(file, component, VERSION_FIELD);
                    os = YamlPersister.getRequiredOs(file, component);
                    arch = YamlPersister.getRequiredArch(file, component);
                    InclusionType inclusionType = YamlPersister.getRequiredInclusionType(file, component);
                    boolean required = YamlPersister.getRequiredBoolean(file, component, REQUIRED_FIELD);
                    ByteSize size = YamlPersister.getRequiredSize(file, component);
                    String group = YamlPersister.getOptionalString(file, component, COMPONENT_GROUP_ID_FIELD);
                    IMutableComponent.IRequiredAttributes attributes = IMutableComponent.attributesBuilder().inclusionType(inclusionType).required(required).size(size).build();
                    Component cmp = p.addComponent(new ComponentKey(id, version, os, arch), attributes);
                    cmp.setGroupName(group);
                }
                for (Map<String, Object> component : components) {
                    id = YamlPersister.getRequiredString(file, component, ID_FIELD);
                    version = YamlPersister.getRequiredSemanticVersion(file, component, VERSION_FIELD);
                    os = YamlPersister.getRequiredOs(file, component);
                    arch = YamlPersister.getRequiredArch(file, component);
                    Optional<IComponent> oc = p.findComponent(new ComponentKey(id, version, os, arch));
                    Preconditions.checkArgument((boolean)oc.isPresent(), (Object)"Programmer error: c can not be null");
                    List<Map<String, Object>> dependencies = YamlPersister.getOptionalMapsList(file, component, DEPENDENCIES_LIST);
                    if (dependencies == null) continue;
                    for (Map<String, Object> dependency : dependencies) {
                        Architecture dArch;
                        OsType dOs;
                        SemanticVersion dVersion;
                        String dId = YamlPersister.getRequiredString(file, dependency, ID_FIELD);
                        Optional<IComponent> odc = p.findComponent(new ComponentKey(dId, dVersion = YamlPersister.getRequiredSemanticVersion(file, dependency, VERSION_FIELD), dOs = YamlPersister.getRequiredOs(file, dependency), dArch = YamlPersister.getRequiredArch(file, dependency)));
                        if (!odc.isPresent()) {
                            throw new BrokenComponentDependencyException(id, version, dId, dVersion);
                        }
                        ((Component)oc.get()).addDependencyIfAbsent((Component)odc.get());
                    }
                }
            }
        }
    }

    @Override
    public void loadMetaUninterruptibly(InventoryMeta im, Path file) {
        this.loadMeta(im, file);
    }

    @Override
    public void loadDescriptions(InventoryMeta im, Path file, String locale) {
        String content = this.readFileContent(file, 100000000);
        if (content == null) {
            return;
        }
        LOGGER.debug("before parsing YAML {}", (Object)file.toString());
        Map<String, Object> map = this.loadAsYamlMap(content, file);
        LOGGER.debug("YAML parsed");
        Map<String, Object> inventoryDescription = YamlPersister.getRequiredMap(file, map, INVENTORY_DESCRIPTION_STRUCT);
        List<Map<String, Object>> distros = YamlPersister.getRequiredMapsList(file, inventoryDescription, DISTROS_DESCRIPTION_LIST);
        for (Map<String, Object> distro : distros) {
            Architecture arch;
            OsType os;
            SemanticVersion version;
            String id = YamlPersister.getRequiredString(file, distro, ID_FIELD);
            Optional<IDistro> od = im.findDistro(new DistroKey(id, version = YamlPersister.getRequiredSemanticVersion(file, distro, VERSION_FIELD), os = YamlPersister.getRequiredOs(file, distro), arch = YamlPersister.getRequiredArch(file, distro)));
            if (!od.isPresent()) continue;
            IDistro d = od.get();
            String name = YamlPersister.getOptionalString(file, distro, "name");
            String description = YamlPersister.getOptionalString(file, distro, "description");
            String homeUrl = YamlPersister.getOptionalString(file, distro, "home-url");
            String vendor = YamlPersister.getOptionalString(file, distro, "vendor");
            ((Distro)d).addLocalization(locale, "name", name);
            ((Distro)d).addLocalization(locale, "description", description);
            ((Distro)d).addLocalization(locale, "home-url", homeUrl);
            ((Distro)d).addLocalization(locale, "vendor", vendor);
            List<Map<String, Object>> products = YamlPersister.getRequiredMapsList(file, distro, PRODUCTS_DESCRIPTION_LIST);
            for (Map<String, Object> product : products) {
                id = YamlPersister.getRequiredString(file, product, ID_FIELD);
                Optional<IProduct> op = d.findProduct(new ProductKey(id, version = YamlPersister.getRequiredSemanticVersion(file, product, VERSION_FIELD), os = YamlPersister.getRequiredOs(file, product), arch = YamlPersister.getRequiredArch(file, product)));
                if (!op.isPresent()) continue;
                IProduct p = op.get();
                name = YamlPersister.getOptionalString(file, product, "name");
                description = YamlPersister.getOptionalString(file, product, "description");
                homeUrl = YamlPersister.getOptionalString(file, product, "home-url");
                vendor = YamlPersister.getOptionalString(file, product, "vendor");
                ((Product)p).addLocalization(locale, "name", name);
                ((Product)p).addLocalization(locale, "description", description);
                ((Product)p).addLocalization(locale, "home-url", homeUrl);
                ((Product)p).addLocalization(locale, "vendor", vendor);
                List<Map<String, Object>> components = YamlPersister.getRequiredMapsList(file, product, COMPONENTS_DESCRIPTION_LIST);
                for (Map<String, Object> component : components) {
                    id = YamlPersister.getRequiredString(file, component, ID_FIELD);
                    Optional<IComponent> oc = p.findComponent(new ComponentKey(id, version = YamlPersister.getRequiredSemanticVersion(file, component, VERSION_FIELD), os = YamlPersister.getRequiredOs(file, component), arch = YamlPersister.getRequiredArch(file, component)));
                    if (!oc.isPresent()) continue;
                    Component c = (Component)oc.get();
                    name = YamlPersister.getOptionalString(file, component, "name");
                    description = YamlPersister.getOptionalString(file, component, "description");
                    homeUrl = YamlPersister.getOptionalString(file, component, "home-url");
                    vendor = YamlPersister.getOptionalString(file, component, "vendor");
                    String groupName = YamlPersister.getOptionalString(file, component, "group-name");
                    c.addLocalization(locale, "name", name);
                    c.addLocalization(locale, "description", description);
                    c.addLocalization(locale, "home-url", homeUrl);
                    c.addLocalization(locale, "vendor", vendor);
                    c.addLocalization(locale, "group-name", groupName);
                }
            }
        }
        im.registerLocale(locale);
    }

    @Override
    public void loadDescriptionsUninterruptibly(InventoryMeta im, Path file, String lang) {
        this.loadDescriptions(im, file, lang);
    }

    @Override
    public void loadComponentsAttributes(InventoryMeta im, Path file) {
        String content = this.readFileContent(file, 100000000);
        if (content == null) {
            return;
        }
        LOGGER.debug("before parsing YAML {}", (Object)file.toString());
        Map<String, Object> map = this.loadAsYamlMap(content, file);
        LOGGER.debug("YAML parsed");
        List<Map<String, Object>> components = YamlPersister.getRequiredMapsList(file, map, ATTRIBUTES_LIST);
        for (Map<String, Object> component : components) {
            String id = YamlPersister.getRequiredString(file, component, ID_FIELD);
            SemanticVersion version = YamlPersister.getRequiredSemanticVersion(file, component, VERSION_FIELD);
            OsType os = YamlPersister.getRequiredOs(file, component);
            Architecture arch = YamlPersister.getRequiredArch(file, component);
            ComponentKey componentKey = new ComponentKey(id, version, os, arch);
            this.setPaths(file, component, im, componentKey);
            this.setRingModules(file, component, im, componentKey);
        }
    }

    @Override
    public void loadComponentsAttributesUninterruptibly(InventoryMeta im, Path file) {
        this.loadComponentsAttributes(im, file);
    }

    @Override
    public void saveComponentsAttributes(Set<IComponent> components, InventoryMeta im) throws InterruptedException {
        this.saveComponentsAttributesInternal(components, im, true);
        this.checkInterruption(IMessagesList.Messages.componentsAttributesSaveInterrupted());
    }

    @Override
    public void saveComponentsAttributesUninterruptibly(Set<IComponent> components, InventoryMeta im) {
        this.saveComponentsAttributesInternal(components, im, false);
    }

    @Override
    public void saveMeta(InventoryMeta im) {
        LOGGER.debug("before serializing YAML inventory.yml");
        LinkedHashMap map = new LinkedHashMap();
        LinkedHashMap<String, Object> inventory = new LinkedHashMap<String, Object>();
        map.put(INVENTORY_STRUCT, inventory);
        inventory.put(METADATA_FORMAT_VERSION_FIELD, im.getMetadataFormatVersion().toString());
        inventory.put(VERSION_CREATED_AT_FIELD, im.getCreatedAt().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        inventory.put(VERSION_CREATED_BY_FIELD, im.getCreatedBy());
        inventory.put(PRODUCTS_HOME_FIELD, im.getProductsHome().toString());
        ArrayList features = im.getFeatures().stream().map(Feature::getName).collect(Collectors.toCollection(ArrayList::new));
        inventory.put(FEATURES_LIST, features);
        Optional<IInstallerComponent> inst = im.getInstallerComponent();
        if (inst.isPresent()) {
            LinkedHashMap<String, String> i = new LinkedHashMap<String, String>();
            i.put(VERSION_FIELD, inst.get().getVersion().toString());
            i.put(OS_FIELD, inst.get().getOs().name().toLowerCase());
            i.put(ARCH_FIELD, inst.get().getArch().getName().toLowerCase());
            inventory.put(INSTALLER_STRUCT, i);
        }
        ArrayList distros = new ArrayList();
        inventory.put(DISTROS_STRUCT, distros);
        for (IDistro distro : im.getDistros()) {
            LinkedHashMap<String, Object> d = new LinkedHashMap<String, Object>();
            distros.add(d);
            d.put(ID_FIELD, distro.getId());
            d.put(VERSION_FIELD, distro.getVersion().toString());
            d.put(OS_FIELD, distro.getOs().name().toLowerCase());
            d.put(ARCH_FIELD, distro.getArch().getName().toLowerCase());
            if (distro.getSource() != null) {
                LinkedHashMap<String, String> s = new LinkedHashMap<String, String>();
                s.put(TYPE_FIELD, distro.getSource().getType().toString().toLowerCase());
                s.put("path", distro.getSource().getPath());
                d.put(SOURCE_STRUCT, s);
            }
            ArrayList products = new ArrayList();
            d.put(PRODUCTS_LIST, products);
            for (IProduct product : distro.getProducts()) {
                LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>();
                products.add(p);
                p.put(ID_FIELD, product.getId());
                p.put(VERSION_FIELD, product.getVersion().toString());
                p.put(OS_FIELD, product.getOs().name().toLowerCase());
                p.put(ARCH_FIELD, product.getArch().getName().toLowerCase());
                p.put(COPYRIGHT_PERIOD_FIELD, CopyrightPeriod.toRangeString((CopyrightPeriod)product.getCopyrightPeriod()));
                p.put(OWN_SIZE_FIELD, product.getOwnSize().toString());
                if (!Strings.isNullOrEmpty((String)product.getLogoImagePath())) {
                    p.put(LOGO_IMAGE_PATH, product.getLogoImagePath());
                }
                p.put(INSTALLED_AT_FIELD, product.getInstalledAt().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
                ArrayList components = new ArrayList();
                p.put(COMPONENTS_LIST, components);
                for (IComponent component : product.getComponents()) {
                    LinkedHashMap<String, Object> c = new LinkedHashMap<String, Object>();
                    components.add(c);
                    c.put(ID_FIELD, component.getId());
                    c.put(VERSION_FIELD, component.getVersion().toString());
                    c.put(OS_FIELD, component.getOs().name().toLowerCase());
                    c.put(ARCH_FIELD, component.getArch().getName().toLowerCase());
                    c.put(INCLUSION_TYPE_FIELD, component.getInclusionType().toString().toLowerCase());
                    c.put(REQUIRED_FIELD, Boolean.toString(component.isRequired()));
                    c.put(SIZE_FIELD, component.getSize().toString());
                    component.getGroupId().ifPresent(gn -> c.put(COMPONENT_GROUP_ID_FIELD, gn));
                    ArrayList dependencies = new ArrayList();
                    for (IComponent dep : component.getDependencies()) {
                        LinkedHashMap<String, String> cd = new LinkedHashMap<String, String>();
                        dependencies.add(cd);
                        cd.put(ID_FIELD, dep.getId());
                        cd.put(VERSION_FIELD, dep.getVersion().toString());
                        cd.put(OS_FIELD, dep.getOs().name().toLowerCase());
                        cd.put(ARCH_FIELD, dep.getArch().getName().toLowerCase());
                    }
                    if (dependencies.isEmpty()) continue;
                    c.put(DEPENDENCIES_LIST, dependencies);
                }
            }
        }
        LOGGER.debug("before saving YAML inventory.yml");
        String yaml = YamlPersister.createYaml().dump(map);
        LOGGER.debug("YAML saved");
        InventoryVersion version = im.getVersion();
        Path file = version.getPath().resolve("installed").resolve("inventory.yml");
        this.saveYamlToFile(yaml, file);
    }

    @Override
    public void saveDescriptions(InventoryMeta im, String locale) {
        LinkedHashMap map = new LinkedHashMap();
        LinkedHashMap inventoryDescription = new LinkedHashMap();
        map.put(INVENTORY_DESCRIPTION_STRUCT, inventoryDescription);
        ArrayList<LinkedHashMap<String, Object>> distros = new ArrayList<LinkedHashMap<String, Object>>();
        inventoryDescription.put(DISTROS_DESCRIPTION_LIST, distros);
        for (IDistro distro : im.getDistros()) {
            LinkedHashMap<String, Object> d = new LinkedHashMap<String, Object>();
            distros.add(d);
            d.put(ID_FIELD, distro.getId());
            d.put(VERSION_FIELD, distro.getVersion().toString());
            d.put(OS_FIELD, distro.getOs().name().toLowerCase());
            d.put(ARCH_FIELD, distro.getArch().getName().toLowerCase());
            this.saveLocalizationAttrsForEntity(locale, d, ((Distro)distro).getLocalization());
            ArrayList<LinkedHashMap<String, Object>> products = new ArrayList<LinkedHashMap<String, Object>>();
            d.put(PRODUCTS_DESCRIPTION_LIST, products);
            for (IProduct product : distro.getProducts()) {
                LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>();
                products.add(p);
                p.put(ID_FIELD, product.getId());
                p.put(VERSION_FIELD, product.getVersion().toString());
                p.put(OS_FIELD, product.getOs().name().toLowerCase());
                p.put(ARCH_FIELD, product.getArch().getName().toLowerCase());
                this.saveLocalizationAttrsForEntity(locale, p, ((Product)product).getLocalization());
                ArrayList<LinkedHashMap<String, Object>> components = new ArrayList<LinkedHashMap<String, Object>>();
                p.put(COMPONENTS_DESCRIPTION_LIST, components);
                for (IComponent component : product.getComponents()) {
                    Localization localization = ((Component)component).getLocalization();
                    Map<String, String> lm = localization.getLocale(locale);
                    if (lm == null) continue;
                    LinkedHashMap<String, Object> c = new LinkedHashMap<String, Object>();
                    components.add(c);
                    c.put(ID_FIELD, component.getId());
                    c.put(VERSION_FIELD, component.getVersion().toString());
                    c.put(OS_FIELD, component.getOs().name().toLowerCase());
                    c.put(ARCH_FIELD, component.getArch().getName().toLowerCase());
                    this.saveLocalizationAttrsForEntity(locale, c, localization);
                }
            }
        }
        LOGGER.debug("before saving YAML description_" + locale + ".yml");
        String yaml = YamlPersister.createYaml().dump(map);
        LOGGER.debug("YAML saved");
        InventoryVersion version = im.getVersion();
        Path file = version.getPath().resolve("installed").resolve("descriptions").resolve("description_" + locale + ".yml");
        this.saveYamlToFile(yaml, file);
    }

    @Override
    public void saveComponentsSnapshot(Set<IComponent> components, InventoryMeta im) throws InterruptedException {
        this.saveComponentsSnapshotInternal(components, im, true);
        this.checkInterruption(IMessagesList.Messages.componentsSnapshotSaveInterrupted());
    }

    @Override
    public void saveComponentsSnapshotUninterruptibly(Set<IComponent> components, InventoryMeta im) {
        this.saveComponentsSnapshotInternal(components, im, false);
    }

    @Override
    public void saveInstallerComponentSnapshot(IInstallerComponent installerComponent, InventoryMeta meta) throws InterruptedException {
        this.saveInstallerComponentSnapshotInternal(installerComponent, meta, true);
        this.checkInterruption(IMessagesList.Messages.installerComponentSnapshotSaveInterrupted());
    }

    @Override
    public void saveInstallerComponentSnapshotUninterruptibly(IInstallerComponent installerComponent, InventoryMeta meta) {
        this.saveInstallerComponentSnapshotInternal(installerComponent, meta, false);
    }

    @Override
    public void saveInstallerComponentsAttributes(IInstallerComponent installerComponent, InventoryMeta meta) throws InterruptedException {
        this.saveInstallerComponentsAttributesInternal(installerComponent, meta);
        this.checkInterruption(IMessagesList.Messages.installerComponentsAttributesSaveInterrupted());
    }

    @Override
    public void saveInstallerComponentsAttributesUninterruptibly(IInstallerComponent installerComponent, InventoryMeta meta) {
        this.saveInstallerComponentsAttributesInternal(installerComponent, meta);
    }

    @Override
    public void loadComponentSnapshot(InventoryMeta im, Path file) {
        String content = this.readFileContent(file, 100000000);
        if (content == null) {
            return;
        }
        LOGGER.debug("before parsing YAML {}", (Object)file.toString());
        Map<String, Object> map = this.loadAsYamlMap(content, file);
        LOGGER.debug("YAML parsed");
        List<Map<String, Object>> inventoryComponentFiles = YamlPersister.getRequiredMapsList(file, map, INVENTORY_COMPONENT_FILES_LIST);
        for (Map<String, Object> ycomponent : inventoryComponentFiles) {
            String id = YamlPersister.getRequiredString(file, ycomponent, ID_FIELD);
            SemanticVersion version = YamlPersister.getRequiredSemanticVersion(file, ycomponent, VERSION_FIELD);
            OsType os = YamlPersister.getRequiredOs(file, ycomponent);
            Architecture arch = YamlPersister.getRequiredArch(file, ycomponent);
            ComponentKey componentKey = new ComponentKey(id, version, os, arch);
            List<IMutableInstalledFilesContainer> componentObjects = id.equals("1c-enterprise-installer") ? (List<IMutableInstalledFilesContainer>)im.getMutableInstallerComponent().map(ImmutableList::of).orElse(ImmutableList.of()) : im.componentsStream().filter(c -> c.getKey().equals((Object)componentKey)).map(IMutableComponent.class::cast).collect(Collectors.toList());
            List<Map<String, Object>> yfiles = YamlPersister.getRequiredMapsList(file, ycomponent, FILES_LIST);
            for (Map<String, Object> yfile : yfiles) {
                String name = YamlPersister.getRequiredString(file, yfile, "name");
                String sha1 = YamlPersister.getRequiredString(file, yfile, SHA1_FIELD);
                FileType type = YamlPersister.getRequiredFileType(file, yfile);
                boolean modified = YamlPersister.getRequiredBoolean(file, yfile, MODIFIABLE_FIELD);
                componentObjects.forEach(container -> container.addFileMeta(name, sha1, type, modified));
            }
            List<IMutableShortcutsContainer> components = id.equals("1c-enterprise-installer") ? (List<IMutableShortcutsContainer>)im.getMutableInstallerComponent().map(ImmutableList::of).orElse(ImmutableList.of()) : im.componentsStream().filter(c -> c.getKey().equals((Object)componentKey)).map(IMutableComponent.class::cast).collect(Collectors.toList());
            List<Map<String, Object>> yshortcuts = YamlPersister.getOptionalMapsList(file, ycomponent, SHORTCUTS_LIST);
            if (yshortcuts == null) continue;
            for (Map<String, Object> yshortcut : yshortcuts) {
                String knownFolder = YamlPersister.getRequiredString(file, yshortcut, SHORTCUT_KNOWN_FOLDER);
                String relativePath = YamlPersister.getRequiredString(file, yshortcut, "path");
                components.forEach(container -> container.addShortcutFileMeta(knownFolder, relativePath));
            }
        }
    }

    @Override
    public void loadComponentSnapshotUninterruptibly(InventoryMeta im, Path file) {
        this.loadComponentSnapshot(im, file);
    }

    @Override
    public void saveProductsSnapshot(Set<IProduct> products, Path file) throws InterruptedException {
        this.saveProductsSnapshotInternal(products, file, true);
        this.checkInterruption(IMessagesList.Messages.productSnapshotSaveInterrupted());
    }

    @Override
    public void saveProductsSnapshotUninterruptibly(Set<IProduct> products, Path file) {
        this.saveProductsSnapshotInternal(products, file, false);
    }

    @Override
    public void loadProductsSnapshot(InventoryMeta im, Path file) throws InventoryStructureException {
        String content = this.readFileContent(file, 100000000);
        if (content == null) {
            return;
        }
        LOGGER.debug("before parsing YAML {}", (Object)file.toString());
        Map<String, Object> map = this.loadAsYamlMap(content, file);
        LOGGER.debug("YAML parsed");
        List<Map<String, Object>> inventoryProductFiles = YamlPersister.getRequiredMapsList(file, map, INVENTORY_PRODUCTS_FILES_LIST);
        for (Map<String, Object> yproduct : inventoryProductFiles) {
            String id = YamlPersister.getRequiredString(file, yproduct, ID_FIELD);
            SemanticVersion version = YamlPersister.getRequiredSemanticVersion(file, yproduct, VERSION_FIELD);
            OsType os = YamlPersister.getRequiredOs(file, yproduct);
            Architecture arch = YamlPersister.getRequiredArch(file, yproduct);
            Optional<IProduct> product = im.productsStream().filter(p -> p.getId().equals(id) && p.getVersion().equals((Object)version) && p.getOs().equals((Object)os) && p.getArch().equals((Object)arch)).findAny();
            List<Map<String, Object>> yfiles = YamlPersister.getRequiredMapsList(file, yproduct, FILES_LIST);
            for (Map<String, Object> yfile : yfiles) {
                String name = YamlPersister.getRequiredString(file, yfile, "name");
                String sha1 = YamlPersister.getRequiredString(file, yfile, SHA1_FIELD);
                FileType type = YamlPersister.getRequiredFileType(file, yfile);
                boolean modified = YamlPersister.getRequiredBoolean(file, yfile, MODIFIABLE_FIELD);
                product.ifPresent(p -> ((IMutableProduct)((Object)p)).addFileMeta(name, sha1, type, modified));
            }
            List<Map<String, Object>> yshortcuts = YamlPersister.getOptionalMapsList(file, yproduct, SHORTCUTS_LIST);
            if (yshortcuts == null) continue;
            for (Map<String, Object> yshortcut : yshortcuts) {
                String knownFolderAbsolutePath = YamlPersister.getRequiredString(file, yshortcut, SHORTCUT_KNOWN_FOLDER);
                String relativePath = YamlPersister.getRequiredString(file, yshortcut, "path");
                product.ifPresent(p -> ((IMutableProduct)((Object)p)).addShortcutFileMeta(knownFolderAbsolutePath, relativePath));
            }
        }
    }

    @Override
    public void loadProductsSnapshotUninterruptibly(InventoryMeta im, Path file) {
        this.loadProductsSnapshot(im, file);
    }

    @Override
    public void saveInventorySnapshot(Map<Path, String> crcs, InventoryVersion iv) {
        if (crcs.isEmpty()) {
            return;
        }
        Path file = iv.getPath().resolve("inventory-list.yml");
        LinkedHashMap map = new LinkedHashMap();
        ArrayList ylist = new ArrayList();
        map.put(INVENTORY_LIST_LIST, ylist);
        for (Map.Entry<Path, String> crc : crcs.entrySet()) {
            LinkedHashMap<String, String> yf = new LinkedHashMap<String, String>();
            ylist.add(yf);
            yf.put("name", iv.getPath().relativize(crc.getKey()).toString());
            yf.put(SHA1_FIELD, crc.getValue());
        }
        LOGGER.debug("before saving YAML " + file.toString());
        String yaml = YamlPersister.createYaml().dump(map);
        LOGGER.debug("YAML saved");
        this.saveYamlToFile(yaml, file);
    }

    @Override
    public void loadInventorySnapshot(Path file, FilesSnapshot snapshot) {
        String content = this.readFileContent(file, 100000000);
        if (content == null) {
            throw new InventoryFileIsEmptyException(file);
        }
        LOGGER.debug("before parsing YAML {}", (Object)file.toString());
        Map<String, Object> map = this.loadAsYamlMap(content, file);
        LOGGER.debug("YAML parsed");
        List<Map<String, Object>> inventoryListFiles = YamlPersister.getRequiredMapsList(file, map, INVENTORY_LIST_LIST);
        for (Map<String, Object> yfile : inventoryListFiles) {
            String name = YamlPersister.getRequiredString(file, yfile, "name");
            String sha1 = YamlPersister.getRequiredString(file, yfile, SHA1_FIELD);
            snapshot.set(name, sha1);
        }
    }

    private String readInventoryLocFileContent(Path inventoryLocFile) {
        FileDigester digester = new FileDigester();
        Path path = inventoryLocFile.toAbsolutePath().normalize();
        for (int i = 0; i < 5; ++i) {
            try {
                String oldDigest = digester.digestFile(path);
                String content = this.readFileContent(path, 10000);
                String newDigest = digester.digestFile(path);
                if (oldDigest.equals(newDigest)) {
                    if (content == null) {
                        throw new InventoryFileIsEmptyException(path);
                    }
                    return content;
                }
            }
            catch (AccessDeniedException e) {
                throw new InventoryAccessDeniedException(path, (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InventoryLocationReadInterruptedException(path, (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.debug("Cannot read inventory file " + path, (Throwable)e);
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InventoryLocationReadInterruptedException(path, (Throwable)e);
            }
        }
        throw new InventoryLocationLockedException(path);
    }

    private void setPaths(Path file, Map<String, Object> component, InventoryMeta im, ComponentKey componentKey) {
        List<String> paths = YamlPersister.getOptionalStringList(file, component, PATHS_LIST);
        if (paths != null) {
            if (!componentKey.getId().equals("1c-enterprise-installer")) {
                Optional<IMutableComponent> compOpt = im.componentsStream().filter(c -> c.getKey().equals((Object)componentKey)).map(IMutableComponent.class::cast).findAny();
                Preconditions.checkState((boolean)compOpt.isPresent(), (String)"Not found component, key: %s", (Object)componentKey);
                IMutableComponent comp = compOpt.get();
                List<Path> resolvedPaths = paths.stream().map(path -> Paths.get(path, new String[0])).collect(Collectors.toList());
                comp.setPaths(resolvedPaths);
            } else {
                Optional<IMutableInstallerComponent> installer = im.getMutableInstallerComponent();
                Preconditions.checkState((boolean)installer.isPresent(), (Object)"Not found installer");
                List<Path> resolvedPaths = paths.stream().map(path -> Paths.get(path, new String[0])).collect(Collectors.toList());
                installer.get().setPaths(resolvedPaths);
            }
        }
    }

    private List<Map<String, Object>> convertRingModulesToMap(List<RingModuleInfo> ringModules) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (RingModuleInfo ringModule : ringModules) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("name", ringModule.getName());
            map.put(RING_MODULE_FILE, ringModule.getFile().toString().replace("\\", "/"));
            result.add(map);
        }
        return result;
    }

    private void setRingModules(Path file, Map<String, Object> component, InventoryMeta im, ComponentKey componentKey) {
        List<Map<String, Object>> ringModulesList = YamlPersister.getOptionalMapsList(file, component, RING_MODULES_FIELD);
        if (ringModulesList != null) {
            ArrayList<RingModuleInfo> ringModules = new ArrayList<RingModuleInfo>();
            for (Map<String, Object> ringModule : ringModulesList) {
                String moduleName = (String)ringModule.get("name");
                String modulePathStr = (String)ringModule.get(RING_MODULE_FILE);
                Path modulePath = Paths.get(modulePathStr, new String[0]);
                RingModuleInfo info = new RingModuleInfo(moduleName, modulePath);
                ringModules.add(info);
            }
            Optional<IMutableComponent> compOpt = im.componentsStream().filter(c -> c.getKey().equals((Object)componentKey)).map(IMutableComponent.class::cast).findAny();
            Preconditions.checkState((boolean)compOpt.isPresent(), (String)"Not found component, key: %s", (Object)componentKey);
            compOpt.get().setRingModules(ringModules);
        }
    }

    private void saveYamlToFile(String yaml, Path file) {
        try {
            com.google.common.io.Files.write((byte[])yaml.getBytes(StandardCharsets.UTF_8), (File)file.toFile());
        }
        catch (AccessDeniedException e) {
            throw new InventoryAccessDeniedException(file, (Throwable)e);
        }
        catch (IOException e) {
            throw new InventoryFileIoException(file, e);
        }
    }

    @Nullable
    private String readFileContent(Path file, int maxSize) {
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        try {
            long size = Files.size(file);
            if (size > (long)maxSize) {
                throw new InventoryFileTooBigException(file, size);
            }
            String content = com.google.common.io.Files.asCharSource((File)file.toFile(), (Charset)StandardCharsets.UTF_8).read();
            if (content.isEmpty()) {
                throw new InventoryFileIsEmptyException(file);
            }
            return content;
        }
        catch (AccessDeniedException e) {
            throw new InventoryAccessDeniedException(file, (Throwable)e);
        }
        catch (IOException e) {
            throw new InventoryFileIoException(file, e);
        }
    }

    private void saveLocalizationAttrsForEntity(String locale, Map<String, Object> target, Localization localization) {
        Map<String, String> lm = localization.getLocale(locale);
        if (lm != null) {
            String v = lm.get("name");
            if (v != null) {
                target.put("name", v);
            }
            if ((v = lm.get("description")) != null) {
                target.put("description", v);
            }
            if ((v = lm.get("home-url")) != null) {
                target.put("home-url", v);
            }
            if ((v = lm.get("vendor")) != null) {
                target.put("vendor", v);
            }
            if ((v = lm.get("group-name")) != null) {
                target.put("group-name", v);
            }
        }
    }

    private Map<String, Object> loadAsYamlMap(String content, Path file) {
        try {
            return (Map)YamlPersister.createYaml().loadAs(content, Map.class);
        }
        catch (Exception e) {
            String msg = IMessagesList.Messages.invalidFileFormat(file.toAbsolutePath().normalize().toString());
            throw new InventoryFileFormatException(file, msg, e);
        }
    }

    private void saveInstallerComponentSnapshotInternal(IInstallerComponent installerComponent, InventoryMeta meta, boolean interruptible) {
        InventoryVersion inventoryVersion = meta.getVersion();
        Path file = inventoryVersion.getComponentsDir().resolve(installerComponent.getId()).resolve("snapshot.yml");
        LinkedHashMap map = new LinkedHashMap();
        ArrayList ycomponents = new ArrayList();
        map.put(INVENTORY_COMPONENT_FILES_LIST, ycomponents);
        LinkedHashMap<String, Object> yc = new LinkedHashMap<String, Object>();
        ycomponents.add(yc);
        yc.put(ID_FIELD, installerComponent.getId());
        yc.put(VERSION_FIELD, installerComponent.getVersion().toString());
        yc.put(OS_FIELD, installerComponent.getOs().name().toLowerCase());
        yc.put(ARCH_FIELD, installerComponent.getArch().getName().toLowerCase());
        ArrayList<Map<String, Object>> files = new ArrayList<Map<String, Object>>();
        yc.put(FILES_LIST, files);
        if (interruptible) {
            try {
                installerComponent.snapshotAction(new InterruptiblePersistFilesListVisitor(files));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        } else {
            installerComponent.snapshotActionUninterruptibly(new UninterruptiblePersistFilesListVisitor(files));
        }
        ArrayList shortcuts = new ArrayList();
        yc.put(SHORTCUTS_LIST, shortcuts);
        installerComponent.forEachShortcut((knownFolderName, relativePath) -> {
            LinkedHashMap<String, String> s = new LinkedHashMap<String, String>();
            shortcuts.add(s);
            s.put(SHORTCUT_KNOWN_FOLDER, knownFolderName);
            s.put("path", relativePath);
        });
        String yaml = YamlPersister.createYaml().dump(map);
        LOGGER.trace("YAML saved: {}", (Object)file);
        this.saveYamlToFile(yaml, file);
    }

    private void saveProductsSnapshotInternal(Set<IProduct> products, Path file, boolean interruptible) {
        if (products.isEmpty()) {
            return;
        }
        LinkedHashMap map = new LinkedHashMap();
        ArrayList yproducts = new ArrayList();
        map.put(INVENTORY_PRODUCTS_FILES_LIST, yproducts);
        for (IProduct p : products) {
            LinkedHashMap<String, Object> yp = new LinkedHashMap<String, Object>();
            yproducts.add(yp);
            yp.put(ID_FIELD, p.getId());
            yp.put(VERSION_FIELD, p.getVersion().toString());
            yp.put(OS_FIELD, p.getOs().name().toLowerCase());
            yp.put(ARCH_FIELD, p.getArch().getName().toLowerCase());
            ArrayList<Map<String, Object>> files = new ArrayList<Map<String, Object>>();
            yp.put(FILES_LIST, files);
            if (interruptible) {
                try {
                    p.snapshotAction(new InterruptiblePersistFilesListVisitor(files));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            } else {
                p.snapshotActionUninterruptibly(new UninterruptiblePersistFilesListVisitor(files));
            }
            ArrayList shortcuts = new ArrayList();
            yp.put(SHORTCUTS_LIST, shortcuts);
            p.forEachShortcut((knownFolderName, relativePath) -> {
                LinkedHashMap<String, String> s = new LinkedHashMap<String, String>();
                shortcuts.add(s);
                s.put(SHORTCUT_KNOWN_FOLDER, knownFolderName);
                s.put("path", relativePath);
            });
        }
        LOGGER.debug("before saving YAML " + file.toString());
        String yaml = YamlPersister.createYaml().dump(map);
        LOGGER.debug("YAML saved");
        this.saveYamlToFile(yaml, file);
    }

    private void saveComponentsSnapshotInternal(Set<IComponent> components, InventoryMeta im, boolean interruptible) {
        if (components.isEmpty()) {
            return;
        }
        IComponent first = components.iterator().next();
        InventoryVersion inventoryVersion = im.getVersion();
        Path file = inventoryVersion.getComponentsDir().resolve(first.getId()).resolve("snapshot.yml");
        LinkedHashMap map = new LinkedHashMap();
        ArrayList ycomponents = new ArrayList();
        map.put(INVENTORY_COMPONENT_FILES_LIST, ycomponents);
        for (IComponent c : components) {
            LinkedHashMap<String, Object> yc = new LinkedHashMap<String, Object>();
            ycomponents.add(yc);
            yc.put(ID_FIELD, c.getId());
            yc.put(VERSION_FIELD, c.getVersion().toString());
            yc.put(OS_FIELD, c.getOs().name().toLowerCase());
            yc.put(ARCH_FIELD, c.getArch().getName().toLowerCase());
            ArrayList<Map<String, Object>> files = new ArrayList<Map<String, Object>>();
            yc.put(FILES_LIST, files);
            c.snapshotActionUninterruptibly(new UninterruptiblePersistFilesListVisitor(files));
            ArrayList shortcuts = new ArrayList();
            yc.put(SHORTCUTS_LIST, shortcuts);
            c.forEachShortcut((knownFolderName, relativePath) -> {
                LinkedHashMap<String, String> s = new LinkedHashMap<String, String>();
                shortcuts.add(s);
                s.put(SHORTCUT_KNOWN_FOLDER, knownFolderName);
                s.put("path", relativePath);
            });
            if (!interruptible || !Thread.currentThread().isInterrupted()) continue;
            return;
        }
        LOGGER.debug("before saving YAML " + file.toString());
        String yaml = YamlPersister.createYaml().dump(map);
        LOGGER.debug("YAML saved");
        this.saveYamlToFile(yaml, file);
    }

    private void saveComponentsAttributesInternal(Set<IComponent> components, InventoryMeta im, boolean interruptible) {
        if (components.isEmpty()) {
            return;
        }
        Set ids = components.stream().map(IComponent::getId).collect(Collectors.toSet());
        Preconditions.checkArgument((ids.size() == 1 ? 1 : 0) != 0, (String)"Components have different ids, %s", ids);
        IComponent first = components.iterator().next();
        InventoryVersion inventoryVersion = im.getVersion();
        Path file = inventoryVersion.getComponentsDir().resolve(first.getId()).resolve("attributes.yml");
        LinkedHashMap map = new LinkedHashMap();
        ArrayList ycomponents = new ArrayList();
        map.put(ATTRIBUTES_LIST, ycomponents);
        for (IComponent c : components) {
            LinkedHashMap<String, Object> yc = new LinkedHashMap<String, Object>();
            ycomponents.add(yc);
            yc.put(ID_FIELD, c.getId());
            yc.put(VERSION_FIELD, c.getVersion().toString());
            yc.put(OS_FIELD, c.getOs().name().toLowerCase());
            yc.put(ARCH_FIELD, c.getArch().getName().toLowerCase());
            if (!c.getPaths().isEmpty()) {
                List yPaths = c.getPaths().stream().map(path -> path.toString().replace("\\", "/")).collect(Collectors.toList());
                yc.put(PATHS_LIST, yPaths);
            }
            if (!c.getRingModules().isEmpty()) {
                yc.put(RING_MODULES_FIELD, this.convertRingModulesToMap(c.getRingModules()));
            }
            if (!interruptible || !Thread.currentThread().isInterrupted()) continue;
            return;
        }
        LOGGER.debug("before saving YAML " + file.toString());
        String yaml = YamlPersister.createYaml().dump(map);
        LOGGER.debug("YAML saved");
        this.saveYamlToFile(yaml, file);
    }

    private void saveInstallerComponentsAttributesInternal(IInstallerComponent installerComponent, InventoryMeta meta) {
        InventoryVersion inventoryVersion = meta.getVersion();
        Path file = inventoryVersion.getComponentsDir().resolve(installerComponent.getId()).resolve("attributes.yml");
        ArrayList ycomponents = new ArrayList();
        LinkedHashMap map = new LinkedHashMap();
        map.put(ATTRIBUTES_LIST, ycomponents);
        LinkedHashMap<String, Object> attrsMap = new LinkedHashMap<String, Object>();
        ycomponents.add(attrsMap);
        attrsMap.put(ID_FIELD, installerComponent.getId());
        attrsMap.put(VERSION_FIELD, installerComponent.getVersion().toString());
        attrsMap.put(OS_FIELD, installerComponent.getOs().name().toLowerCase());
        attrsMap.put(ARCH_FIELD, installerComponent.getArch().getName().toLowerCase());
        if (!installerComponent.getPaths().isEmpty()) {
            List yPaths = installerComponent.getPaths().stream().map(path -> path.toString().replace("\\", "/")).collect(Collectors.toList());
            attrsMap.put(PATHS_LIST, yPaths);
        }
        String yaml = YamlPersister.createYaml().dump(map);
        LOGGER.trace("YAML saved: {}", (Object)file);
        this.saveYamlToFile(yaml, file);
    }

    private void checkInterruption(String message) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException(message);
        }
    }

    private static SemanticVersion parseFormatVersion(String str) {
        try {
            return SemanticVersion.fromString((String)str);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidVersionFormatException(str);
        }
    }

    private static SemanticVersion parseSemanticVersion(String str) {
        return SemanticVersion.fromString((String)str);
    }

    private static ZonedDateTime parseDate(Path file, String str, String attrName) {
        try {
            return ZonedDateTime.parse(str);
        }
        catch (DateTimeParseException e) {
            throw new InvalidValueException(file, attrName, str, e);
        }
    }

    private static Architecture parseArch(Path file, String str) {
        return (Architecture)Architecture.findByName((String)str).orElseThrow(() -> new AttributeDoesNotExistException(file, str));
    }

    private static OsType parseOs(Path file, String str, String attrName) {
        try {
            return OsType.valueOf((String)str.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidValueException(file, attrName, str, e);
        }
    }

    private static FileType parseFileType(Path file, String str, String attrName) {
        try {
            return FileType.valueOf(str.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidValueException(file, attrName, str, e);
        }
    }

    private static IDistroSource.SourceType parseOptionalDistroSourceType(@Nullable String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return IDistroSource.SourceType.FILE;
        }
        try {
            return IDistroSource.SourceType.valueOf(str.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return IDistroSource.SourceType.FILE;
        }
    }

    private static InclusionType parseRequiredInclusionType(Path file, String str, String attrName) {
        try {
            return InclusionType.valueOf(str.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidValueException(file, attrName, str, e);
        }
    }

    private static ByteSize parseRequiredByteSize(Path file, String str, String attrName) {
        try {
            return ByteSize.fromString((String)str);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidValueException(file, attrName, str, e);
        }
    }

    private static List<Map<String, Object>> getRequiredMapsList(Path file, Map<String, Object> m, String attrName) {
        Object val = m.get(attrName);
        if (val == null) {
            throw new AttributeDoesNotExistException(file, attrName);
        }
        if (!(val instanceof List)) {
            throw new InvalidValueException(file, attrName, val.getClass().getName());
        }
        return (List)val;
    }

    @Nullable
    private static List<Map<String, Object>> getOptionalMapsList(Path file, Map<String, Object> m, String attrName) {
        Object val = m.get(attrName);
        if (val == null) {
            return null;
        }
        if (!(val instanceof List)) {
            throw new InvalidValueException(file, attrName, val.getClass().getName());
        }
        return (List)val;
    }

    @Nullable
    private static List<String> getOptionalStringList(Path file, Map<String, Object> m, String attrName) {
        Object val = m.get(attrName);
        if (val == null) {
            return null;
        }
        if (!(val instanceof List)) {
            throw new InvalidValueException(file, attrName, val.getClass().getName());
        }
        return (List)val;
    }

    @Nonnull
    private static List<String> getRequiredStringList(Path file, Map<String, Object> m, String attrName) {
        Object val = m.get(attrName);
        if (val == null) {
            throw new AttributeDoesNotExistException(file, attrName);
        }
        if (!(val instanceof List)) {
            throw new InvalidValueException(file, attrName, val.getClass().getName());
        }
        return (List)val;
    }

    private static Map<String, Object> getRequiredMap(Path file, Map<String, Object> m, String attrName) {
        Object val = m.get(attrName);
        if (val == null) {
            throw new AttributeDoesNotExistException(file, attrName);
        }
        if (!(val instanceof Map)) {
            throw new InvalidValueException(file, attrName, val.getClass().getName());
        }
        return (Map)val;
    }

    @Nullable
    private static Map<String, Object> getOptionalMap(Path file, Map<String, Object> m, String attrName) {
        Object val = m.get(attrName);
        if (val == null) {
            return null;
        }
        if (!(val instanceof Map)) {
            throw new InvalidValueException(file, attrName, val.getClass().getName());
        }
        return (Map)val;
    }

    private static Architecture getRequiredArch(Path file, Map<String, Object> m) {
        return YamlPersister.parseArch(file, YamlPersister.getRequiredString(file, m, ARCH_FIELD));
    }

    private static OsType getRequiredOs(Path file, Map<String, Object> m) {
        return YamlPersister.parseOs(file, YamlPersister.getRequiredString(file, m, OS_FIELD), OS_FIELD);
    }

    private static FileType getRequiredFileType(Path file, Map<String, Object> m) {
        return YamlPersister.parseFileType(file, YamlPersister.getRequiredString(file, m, TYPE_FIELD), TYPE_FIELD);
    }

    private static Path getRequiredPath(Path file, Map<String, Object> m, String attrName) {
        return Paths.get(YamlPersister.getRequiredString(file, m, attrName), new String[0]);
    }

    private static SemanticVersion getRequiredFormatVersion(Path file, Map<String, Object> m, String attrName) {
        return YamlPersister.parseFormatVersion(YamlPersister.getRequiredString(file, m, attrName));
    }

    private static SemanticVersion getRequiredSemanticVersion(Path file, Map<String, Object> m, String attrName) {
        return YamlPersister.parseSemanticVersion(YamlPersister.getRequiredString(file, m, attrName));
    }

    private static ZonedDateTime getRequiredDate(Path file, Map<String, Object> m, String attrName) {
        return YamlPersister.parseDate(file, YamlPersister.getRequiredString(file, m, attrName), attrName);
    }

    private static Set<Feature> getRequiredFeatures(Path file, Map<String, Object> m) {
        LinkedHashSet<Feature> result = new LinkedHashSet<Feature>();
        List<String> features = YamlPersister.getOptionalStringList(file, m, FEATURES_LIST);
        if (features == null) {
            return result;
        }
        for (String feature : features) {
            try {
                result.add(Feature.valueOf(feature.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new InvalidValueException(file, FEATURES_LIST, feature, e);
            }
        }
        return result;
    }

    private static IDistroSource.SourceType getOptionalDistroSourceType(Path file, Map<String, Object> m) {
        return YamlPersister.parseOptionalDistroSourceType(YamlPersister.getOptionalString(file, m, TYPE_FIELD));
    }

    private static InclusionType getRequiredInclusionType(Path file, Map<String, Object> m) {
        return YamlPersister.parseRequiredInclusionType(file, YamlPersister.getRequiredString(file, m, INCLUSION_TYPE_FIELD), INCLUSION_TYPE_FIELD);
    }

    private static ByteSize getRequiredSize(Path file, Map<String, Object> m) {
        return YamlPersister.parseRequiredByteSize(file, YamlPersister.getRequiredString(file, m, SIZE_FIELD), SIZE_FIELD);
    }

    private static String getRequiredString(Path file, Map<String, Object> m, String attrName) {
        Object val = m.get(attrName);
        if (val == null) {
            throw new AttributeDoesNotExistException(file, attrName);
        }
        if (!(val instanceof String)) {
            throw new InvalidValueException(file, attrName, val.getClass().getName());
        }
        if (((String)val).isEmpty()) {
            throw new AttributeDoesNotExistException(file, attrName);
        }
        return (String)val;
    }

    private static int getRequiredInt(Path file, Map<String, Object> m, String attrName) {
        String s = YamlPersister.getRequiredString(file, m, attrName);
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new InvalidValueException(file, attrName, s, e);
        }
    }

    private static boolean getRequiredBoolean(Path file, Map<String, Object> m, String attrName) {
        String s = YamlPersister.getRequiredString(file, m, attrName);
        return Boolean.parseBoolean(s);
    }

    @Nullable
    private static String getOptionalString(Path file, Map<String, Object> m, String attrName) throws InventoryFileFormatException {
        Object val = m.get(attrName);
        if (val == null) {
            return null;
        }
        if (!(val instanceof String)) {
            throw new InvalidValueException(file, attrName, val.getClass().getName());
        }
        if (((String)val).isEmpty()) {
            return null;
        }
        return (String)val;
    }

    private static Yaml createYaml() {
        return YamlPersister.createYaml(new Constructor());
    }

    private static Yaml createYaml(Constructor constructor) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        options.setPrettyFlow(true);
        options.setCanonical(false);
        options.setLineBreak(DumperOptions.LineBreak.getPlatformLineBreak());
        return new Yaml((BaseConstructor)constructor, (Representer)new ConfigRepresenter(), options, new Resolver(){

            public void addImplicitResolver(Tag tag, Pattern regexp, String first) {
                if (!NON_RESOLVED_TAGS.contains(tag.getValue())) {
                    super.addImplicitResolver(tag, regexp, first);
                }
            }
        });
    }

    private static class UninterruptiblePersistFilesListVisitor
    implements IUninterruptibleFileSnapshotVisitor {
        private final List<Map<String, Object>> files;

        UninterruptiblePersistFilesListVisitor(List<Map<String, Object>> files) {
            Preconditions.checkArgument((files != null ? 1 : 0) != 0, (Object)"files must not be null");
            this.files = files;
        }

        @Override
        public void visit(String pathName, IFileMeta meta) {
            LinkedHashMap<String, String> f = new LinkedHashMap<String, String>();
            this.files.add(f);
            f.put("name", pathName);
            f.put(YamlPersister.SHA1_FIELD, meta.getSha1());
            f.put(YamlPersister.TYPE_FIELD, meta.getType().name().toLowerCase());
            f.put(YamlPersister.MODIFIABLE_FIELD, Boolean.toString(meta.isModifiable()));
        }
    }

    private static class InterruptiblePersistFilesListVisitor
    implements IFileSnapshotVisitor {
        private final UninterruptiblePersistFilesListVisitor uninterruptibleVisitor;

        InterruptiblePersistFilesListVisitor(List<Map<String, Object>> files) {
            this.uninterruptibleVisitor = new UninterruptiblePersistFilesListVisitor(files);
        }

        @Override
        public void visit(String pathName, IFileMeta meta) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException(IMessagesList.Messages.filesProcessingInterrupted());
            }
            this.uninterruptibleVisitor.visit(pathName, meta);
        }
    }

    private static class ConfigRepresentNull
    implements Represent {
        private ConfigRepresentNull() {
        }

        public Node representData(Object data) {
            return new ScalarNode(Tag.NULL, "", null, null, DumperOptions.ScalarStyle.PLAIN);
        }
    }

    private static final class ConfigRepresenter
    extends Representer {
        private ConfigRepresenter() {
            this.nullRepresenter = new ConfigRepresentNull();
        }
    }
}

