/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.verify.internal;

public abstract class AbstractVerifySession
implements Runnable {
    private static int SESSION_ID = 0;
    private static boolean DEBUG = false;
    private int sessionId = SESSION_ID++;
    private boolean dead = false;
    private boolean sleeping = false;

    public abstract int getPolicy();

    public void kill() {
        this.dead = true;
        this.debug("kill");
    }

    public boolean isKilled() {
        return this.dead;
    }

    protected String getSessionName() {
        return String.valueOf(this.sessionId);
    }

    protected void debug(String string) {
        if (DEBUG) {
            System.out.println("[session:" + this.getSessionName() + "] " + string);
        }
    }

    protected void debug(Throwable throwable) {
        if (DEBUG) {
            System.out.println("[session: " + this.getSessionName() + "] Exception:");
            throwable.printStackTrace();
            System.out.println();
        }
    }

    public boolean isSleeping() {
        return this.sleeping;
    }

    protected void sleep(long l) {
        try {
            this.sleeping = true;
            Thread.sleep(DEBUG ? 30000L : l);
        }
        catch (InterruptedException interruptedException) {
            this.debug(interruptedException);
        }
        this.sleeping = false;
    }

    protected void sleepHalfHour() {
        this.sleep(1800000L);
    }

    protected void sleepOneHour() {
        this.sleep(3600000L);
    }
}

