/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.verify.internal;

import net.xmind.signin.ILicenseKeyHeader;

public class LicenseKeyHeader
implements ILicenseKeyHeader {
    private final String encoded;
    private final String type;
    private final String vendorName;
    private final int majorVersion;
    private final int minorVersion;
    private final String licenseeType;
    private final int yearsOfUpgrade;

    private LicenseKeyHeader(String string, String string2, String string3, int n, int n2, String string4, int n3) {
        this.encoded = string;
        this.type = string2;
        this.vendorName = string3;
        this.majorVersion = n;
        this.minorVersion = n2;
        this.licenseeType = string4;
        this.yearsOfUpgrade = n3;
    }

    public String getLicenseType() {
        return this.type;
    }

    public int getMajorVersionNumber() {
        return this.majorVersion;
    }

    public int getMinorVersionNumber() {
        return this.minorVersion;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public String getLicenseeType() {
        return this.licenseeType;
    }

    public int getYearsOfUpgrade() {
        return this.yearsOfUpgrade;
    }

    public String toEncoded() {
        return this.encoded;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append("LicenseKeyHeader{");
        stringBuilder.append(this.encoded);
        stringBuilder.append(",type=");
        stringBuilder.append(this.type);
        stringBuilder.append(",vendor=");
        stringBuilder.append(this.vendorName);
        stringBuilder.append(",version=");
        stringBuilder.append(this.majorVersion);
        stringBuilder.append('.');
        stringBuilder.append(this.minorVersion);
        stringBuilder.append(",licenseeType=");
        stringBuilder.append(this.licenseeType);
        stringBuilder.append(",yearsOfUpgrade=");
        stringBuilder.append(this.yearsOfUpgrade);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof LicenseKeyHeader)) {
            return false;
        }
        LicenseKeyHeader licenseKeyHeader = (LicenseKeyHeader)object;
        return this.encoded.equals(licenseKeyHeader.encoded);
    }

    public int hashCode() {
        return this.encoded.hashCode();
    }

    public static LicenseKeyHeader decode(String string) throws IllegalArgumentException {
        if (string.length() != 12) {
            throw new IllegalArgumentException("Invalid length of license key header: " + string.length());
        }
        String string2 = string.substring(0, 1);
        if (!"X".equals(string2)) {
            throw new IllegalArgumentException("Invalid license key header: " + string);
        }
        String string3 = string.substring(1, 2);
        String string4 = string.substring(2, 4);
        int n = Integer.parseInt(string.substring(4, 5), 36);
        int n2 = Integer.parseInt(string.substring(5, 6), 36);
        String string5 = string.substring(6, 7);
        int n3 = Integer.parseInt(string.substring(7, 9), 36);
        return new LicenseKeyHeader(string, string3, string4, n, n2, string5, n3);
    }
}

