/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.verify.internal;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import net.xmind.signin.IAccountInfo;
import net.xmind.signin.IAuthenticationListener;
import net.xmind.signin.IDataStore;
import net.xmind.signin.ILicenseInfo;
import net.xmind.signin.ILicenseKeyHeader;
import net.xmind.signin.IXMindNetCommand;
import net.xmind.signin.IXMindNetCommandHandler;
import net.xmind.signin.XMindNet;
import net.xmind.signin.internal.InternalXMindNet;
import net.xmind.signin.internal.LicenseInfo;
import net.xmind.signin.internal.SignInDialog3;
import net.xmind.signin.internal.XMindNetRequest;
import net.xmind.verify.IValidity;
import net.xmind.verify.IVerifyListener;
import net.xmind.verify.internal.Base32;
import net.xmind.verify.internal.LicenseKeyHeader;
import net.xmind.verify.internal.Messages;
import net.xmind.verify.internal.Validity;
import net.xmind.verify.internal.VerifyPlugin;
import net.xmind.verify.legacy.LegacyLicenseVerifierUtil;
import net.xmind.verify.legacy.internal.LegacyValidity;
import net.xmind.verify.ui.internal.LicenseInfoDialog2;
import net.xmind.verify.ui.internal.LicenseKeyInputDialog2;
import net.xmind.verify.ui.internal.SubscriptionInfoDialog;
import net.xmind.verify.ui.internal.VerifyingStatusDialog;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseVerifier
implements IAuthenticationListener,
IXMindNetCommandHandler {
    static final String PROP_LICENSE_EMAIL = "license_email";
    static final String PROP_LICENSE_KEY = "license_key";
    private static final boolean DEBUGGING = VerifyPlugin.getDefault().isDebugging("/debug/verify");
    private static final boolean VERBOSE = VerifyPlugin.getDefault().isDebugging("/debug/verify/verbose");
    private static final String DEBUG_KEYS = "/debug/keys";
    private static final int LICENSE_KEY_LENGTH = 225;
    private static final int HEADER_LENGTH = 12;
    private static final int PREFIX_LENGTH = 8;
    private static LicenseVerifier INSTANCE = null;
    private static List<String> BLACKLISTED_LICENSE_KEYS = null;
    private IValidity validity = null;
    private VerificationJob verifyJob = null;
    private Object jobLock = new Object();
    private static boolean verified = false;
    private List<ValidityNotifier> listeners = new ArrayList<ValidityNotifier>();
    private List<ValidityNotifier> callbacks = new ArrayList<ValidityNotifier>();

    private LicenseVerifier() {
        XMindNet.addAuthenticationListener((IAuthenticationListener)this);
        XMindNet.addXMindNetCommandHandler((String)"refresh", (IXMindNetCommandHandler)this);
    }

    public void verify(int n) {
        this.verify(null, n, null, 0, null);
    }

    public void verify(int n, IVerifyListener iVerifyListener) {
        this.verify(null, n, iVerifyListener, 0, null);
    }

    public void verify(int n, IVerifyListener iVerifyListener, int n2) {
        this.verify(null, n, iVerifyListener, n2, null);
    }

    public void verify(String string, int n, IVerifyListener iVerifyListener, int n2) {
        this.verify(string, n, iVerifyListener, n2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verify(String string, int n, IVerifyListener iVerifyListener, int n2, Properties properties) {
        Object object;
        if ((n2 & 1) == 0 && LicenseVerifier.checkValid(this.validity, n)) {
            if (iVerifyListener != null) {
                iVerifyListener.notifyValidity(this.validity);
            }
            return;
        }
        if (iVerifyListener != null) {
            object = this.callbacks;
            synchronized (object) {
                this.callbacks.add(new ValidityNotifier(iVerifyListener));
            }
        }
        object = this.jobLock;
        synchronized (object) {
            if (this.verifyJob == null) {
                VerificationJob verificationJob = new VerificationJob(string, n, n2, properties);
                verificationJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void done(IJobChangeEvent iJobChangeEvent) {
                        Object object = LicenseVerifier.this.jobLock;
                        synchronized (object) {
                            LicenseVerifier.this.verifyJob = null;
                        }
                        if (iJobChangeEvent.getResult() instanceof IValidity) {
                            LicenseVerifier.this.setValidity((IValidity)iJobChangeEvent.getResult());
                        } else {
                            LicenseVerifier.this.setValidity(LicenseVerifier.createValidity(8));
                        }
                    }
                });
                verificationJob.schedule();
                this.verifyJob = verificationJob;
            } else {
                this.verifyJob.updateActionName(string);
                this.verifyJob.updateRequiredStatus(n);
                this.verifyJob.updateStyle(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVerifyListener(IVerifyListener iVerifyListener) {
        List<ValidityNotifier> list = this.listeners;
        synchronized (list) {
            this.listeners.add(new ValidityNotifier(iVerifyListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVerifyListener(IVerifyListener iVerifyListener) {
        List<ValidityNotifier> list = this.listeners;
        synchronized (list) {
            Object[] objectArray = this.listeners.toArray();
            this.listeners.clear();
            int n = 0;
            while (n < objectArray.length) {
                ValidityNotifier validityNotifier = (ValidityNotifier)objectArray[n];
                if (validityNotifier.listener != iVerifyListener) {
                    this.listeners.add(validityNotifier);
                }
                ++n;
            }
        }
    }

    private void setValidity(IValidity iValidity) {
        IValidity iValidity2 = LicenseVerifier.cloneValidity(iValidity = LicenseVerifier.cloneValidity(iValidity));
        if (this.notifyAllCallbacks(iValidity2)) {
            return;
        }
        this.notifyAllListeners(iValidity2);
        this.notifyLicenseAgent(iValidity2);
        this.validity = iValidity;
        if ((iValidity.getCode() & 6) != 0) {
            this.checkLicenseKeyBlacklisted();
        }
    }

    private void checkLicenseKeyBlacklisted() {
        Properties properties = LicenseVerifier.loadLocalData();
        final String string = LicenseVerifier.trimLicenseKey(properties.getProperty("WalkingInTheMorning"));
        final String string2 = properties.getProperty("TimeSmilesInMyHand");
        Thread thread = new Thread(new Runnable(){

            public void run() {
                if (!LicenseVerifier.doCheckLicenseKeyBlacklisted(string2, string)) {
                    LicenseVerifier.addBlacklistedLicenseKey(string, string2);
                    LicenseVerifier.this.verify(7, null, 3);
                }
            }
        });
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyAllCallbacks(IValidity iValidity) {
        ArrayList<ValidityNotifier> arrayList;
        List<ValidityNotifier> object2 = this.callbacks;
        synchronized (object2) {
            arrayList = new ArrayList<ValidityNotifier>(this.callbacks);
            this.callbacks.clear();
        }
        for (ValidityNotifier validityNotifier : arrayList) {
            if (!validityNotifier.notifyValidityCallback(iValidity)) continue;
            return true;
        }
        return false;
    }

    private void notifyAllListeners(IValidity iValidity) {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            ((ValidityNotifier)object).notifyValidityListener(iValidity);
            ++n2;
        }
    }

    private void notifyLicenseAgent(IValidity iValidity) {
        int n = iValidity.getCode();
        Throwable throwable = iValidity.getException();
        String string = iValidity.getLicensedTo();
        ILicenseKeyHeader iLicenseKeyHeader = iValidity.getLicenseKeyHeader();
        InternalXMindNet.getInstance().getLicenseAgent().licenseVerified((ILicenseInfo)new LicenseInfo(n, throwable, string, iLicenseKeyHeader));
    }

    public void postSignIn(IAccountInfo iAccountInfo) {
        verified = false;
        this.verify(7, null, 3);
    }

    public void postSignOut(IAccountInfo iAccountInfo) {
        if (this.validity != null && (this.validity.getCode() & 1) != 0) {
            if (!LicenseVerifier.hasValidity(this.validity, 6)) {
                LicenseVerifier.saveLocalData(null, null, null, null, null);
            } else {
                this.saveLocalData(null);
            }
            this.setValidity(LicenseVerifier.createValidity(1024));
        }
        verified = false;
    }

    public boolean handleXMindNetCommand(IXMindNetCommand iXMindNetCommand) {
        this.refreshValidity(iXMindNetCommand.getContent());
        return true;
    }

    private void refreshValidity(IDataStore iDataStore) {
        if (iDataStore == null) {
            return;
        }
        if (this.validity != null && (this.validity.getCode() & 6) != 0) {
            return;
        }
        String string = iDataStore.getString("user");
        String string2 = iDataStore.getString("uid");
        if (string == null || string2 == null) {
            return;
        }
        IAccountInfo iAccountInfo = XMindNet.getAccountInfo();
        if (iAccountInfo == null || !string.equals(iAccountInfo.getUser())) {
            return;
        }
        String string3 = LicenseVerifier.extractExpiration(iDataStore, string2);
        String string4 = LicenseVerifier.extractExpireDate(iDataStore, string2);
        int n = string3 == null ? 4096 : LicenseVerifier.parseExpiration(string3, string2);
        LicenseVerifier.saveLocalData(string2, string3, null, null, string4);
        this.validity = LicenseVerifier.createValidity(n, string, null);
    }

    private static boolean isLicenseKeyBlacklisted(String string, String string2) {
        String string3 = String.valueOf(string2) + "|" + string;
        return LicenseVerifier.getBlacklistedLicenseKeys().contains(string3);
    }

    private static synchronized List<String> getBlacklistedLicenseKeys() {
        if (BLACKLISTED_LICENSE_KEYS == null) {
            BLACKLISTED_LICENSE_KEYS = new ArrayList<String>();
            File file = LicenseVerifier.getBlacklistFile();
            if (file != null && file.exists() && file.isFile()) {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                    try {
                        String string;
                        while ((string = bufferedReader.readLine()) != null) {
                            BLACKLISTED_LICENSE_KEYS.add(string);
                        }
                    }
                    finally {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return BLACKLISTED_LICENSE_KEYS;
    }

    private static synchronized void addBlacklistedLicenseKey(String string, String string2) {
        List<String> list = LicenseVerifier.getBlacklistedLicenseKeys();
        list.add(String.valueOf(string2) + "|" + string);
        File file = LicenseVerifier.getBlacklistFile();
        if (file != null) {
            LicenseVerifier.deleteFile(file);
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                try {
                    for (String string3 : list) {
                        bufferedWriter.write(string3);
                        bufferedWriter.newLine();
                    }
                }
                finally {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean doCheckLicenseKeyBlacklisted(String string, String string2) {
        XMindNetRequest xMindNetRequest = new XMindNetRequest().useHTTPS();
        xMindNetRequest.path("/_res/verify-license", new Object[0]).addParameter("email", (Object)string).addParameter("key", (Object)string2);
        String string3 = LicenseVerifier.getInstallUUID();
        if (string3 != null) {
            xMindNetRequest.addParameter("uuid", (Object)string3);
        }
        xMindNetRequest.post();
        if (xMindNetRequest.isAborted()) {
            return true;
        }
        int n = xMindNetRequest.getStatusCode();
        IDataStore iDataStore = xMindNetRequest.getData();
        if (n == 200 && iDataStore != null) {
            String string4 = iDataStore.getString("status");
            return string4 == null || "".equals(string4) || "valid".equals(string4);
        }
        return true;
    }

    private static synchronized String getInstallUUID() {
        File file = LicenseVerifier.getUUIDFile();
        if (file != null) {
            Object object;
            String string = null;
            if (file.exists() && file.isFile()) {
                try {
                    object = new byte[1024];
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        int n = fileInputStream.read((byte[])object);
                        string = new String((byte[])object, 0, n, "UTF-8");
                    }
                    finally {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (string == null) {
                string = UUID.randomUUID().toString();
                LicenseVerifier.deleteFile(file);
                try {
                    object = new FileOutputStream(file);
                    try {
                        ((FileOutputStream)object).write(string.getBytes("UTF-8"));
                    }
                    finally {
                        ((FileOutputStream)object).close();
                    }
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            return string;
        }
        return null;
    }

    private static void deleteFile(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                LicenseVerifier.deleteFile(new File(file, string));
                ++n2;
            }
        }
        file.delete();
    }

    private static boolean checkValid(IStatus iStatus, int n) {
        return iStatus != null && LicenseVerifier.hasValidity(iStatus, n);
    }

    private static boolean hasValidity(IStatus iStatus, int n) {
        return (iStatus.getCode() & n) != 0;
    }

    private static Properties loadLocalData() {
        File file = LicenseVerifier.getStateFile();
        if (file != null && file.exists() && file.isFile()) {
            Properties properties = new Properties();
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 1024);
                try {
                    properties.load(bufferedInputStream);
                }
                finally {
                    ((InputStream)bufferedInputStream).close();
                }
                String string = properties.getProperty("TimeSmilesInMyHand");
                String string2 = properties.getProperty("WalkingInTheMorning");
                LicenseVerifier.saveState(properties, "WalkingInTheMorning", Cryptus.decrypt(string2, string));
                return properties;
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static void saveLocalData(String string, String string2, String string3, String string4, String string5) {
        File file = LicenseVerifier.getStateFile();
        if (file == null) {
            return;
        }
        string3 = Cryptus.encrypt(string3, string4);
        Properties properties = new Properties();
        LicenseVerifier.saveState(properties, "TimeSmilesInMyHand", string4);
        LicenseVerifier.saveState(properties, "WalkingInTheMorning", string3);
        LicenseVerifier.saveState(properties, "ThisDawn", string);
        LicenseVerifier.saveState(properties, "LastsAllDay", string2);
        LicenseVerifier.saveState(properties, "LastAllDay", string5);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                properties.store(fileOutputStream, "Awakening Gatha, Deena Metzger");
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    private static void saveLocalData(String string, String string2, String string3, String string4) {
        LicenseVerifier.saveLocalData(string, string2, string3, string4, null);
    }

    private void saveLocalData(String string) {
        Properties properties = LicenseVerifier.loadLocalData();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (properties != null) {
            string2 = properties.getProperty("WalkingInTheMorning");
            string3 = properties.getProperty("TimeSmilesInMyHand");
            string4 = properties.getProperty("ThisDawn");
        }
        LicenseVerifier.saveLocalData(string4, null, string2, string3, null);
    }

    private static void saveState(Properties properties, String string, String string2) {
        if (string2 != null && !"".equals(string2)) {
            properties.setProperty(string, string2);
        } else {
            properties.remove(string);
        }
    }

    private static String extractExpireDate(IDataStore iDataStore, String string) {
        if (!iDataStore.has("expireDate")) {
            return null;
        }
        long l = iDataStore.getLong("expireDate");
        if (l <= 0L) {
            l = 0L;
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append('`');
        stringBuffer.append('\t');
        stringBuffer.append('\n');
        stringBuffer.append(Long.toString(l, 16));
        String string2 = Cryptus.encrypt(stringBuffer.toString(), string);
        return string2;
    }

    private static String extractExpiration(IDataStore iDataStore, String string) {
        if (!iDataStore.has("expireDate")) {
            return null;
        }
        long l = iDataStore.getLong("expireDate");
        if (l <= 0L) {
            return null;
        }
        if (iDataStore.getBoolean("expired")) {
            l = 0L;
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append('`');
        stringBuffer.append('\t');
        stringBuffer.append('\n');
        stringBuffer.append(Long.toString(l, 16));
        String string2 = Cryptus.encrypt(stringBuffer.toString(), string);
        return string2;
    }

    private static long parseExpireDate(String string, String string2) {
        String string3 = Cryptus.decrypt(string, string2);
        if (string3 != null && !"".equals(string3) && string3.startsWith("`\t\n")) {
            return Long.parseLong(string3.substring(3), 16);
        }
        return 0L;
    }

    private static int parseExpiration(String string, String string2) {
        String string3 = Cryptus.decrypt(string, string2);
        if (string3 != null && !"".equals(string3) && string3.startsWith("`\t\n")) {
            long l = Long.parseLong(string3.substring(3), 16);
            if (System.currentTimeMillis() < l) {
                return 1;
            }
            return 2048;
        }
        return 1024;
    }

    private static File getStateFile() {
        return LicenseVerifier.getLocalFile(".poem35");
    }

    private static File getUUIDFile() {
        return LicenseVerifier.getLocalFile(".uuid");
    }

    private static File getBlacklistFile() {
        return LicenseVerifier.getLocalFile(".blist");
    }

    private static File getLocalFile(String string) {
        Bundle bundle = Platform.getBundle((String)"net.xmind.verify");
        if (bundle != null) {
            File file = Platform.getStateLocation((Bundle)bundle).toFile();
            return new File(file, string);
        }
        return null;
    }

    private static IValidity cloneValidity(IValidity iValidity) {
        return new Validity(iValidity.getSeverity(), iValidity.getPlugin(), iValidity.getCode(), iValidity.getMessage(), iValidity.getException(), iValidity.getLicensedTo(), iValidity.getLicenseKeyHeader());
    }

    private static IValidity createValidity(int n) {
        return LicenseVerifier.createValidity(n, null, null, null, false);
    }

    private static IValidity createValidity(int n, String string, ILicenseKeyHeader iLicenseKeyHeader) {
        return LicenseVerifier.createValidity(n, string, iLicenseKeyHeader, null, false);
    }

    private static IValidity createValidity(int n, Throwable throwable) {
        return LicenseVerifier.createValidity(n, null, null, throwable, false);
    }

    private static IValidity createValidity(int n, String string, ILicenseKeyHeader iLicenseKeyHeader, Throwable throwable, boolean bl) {
        if ((n & 7) == 0) {
            string = null;
        }
        if (bl) {
            return new Validity(8, "net.xmind.verify", n, null, throwable, string, iLicenseKeyHeader);
        }
        return new Validity(0, "net.xmind.verify", n, null, throwable, string, iLicenseKeyHeader);
    }

    private static String trimLicenseKey(String string) {
        int n = (string = string.toUpperCase()).indexOf("---BEGIN LICENSE KEY---");
        n = n < 0 ? 0 : (n += 23);
        int n2 = string.indexOf("---END LICENSE KEY---");
        if (n2 < 0) {
            n2 = string.length();
        }
        string = string.substring(n, n2).replaceAll("[^A-Z0-9]", "");
        return string;
    }

    public static LicenseVerifier getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LicenseVerifier();
        }
        return INSTANCE;
    }

    private static class Cryptus {
        private Cryptus() {
        }

        protected static String encrypt(String string, String string2) {
            if (string == null || "".equals(string) || string2 == null || "".equals(string2)) {
                return string;
            }
            try {
                byte[] byArray = string2.getBytes();
                byte[] byArray2 = string.getBytes();
                byte[] byArray3 = Cryptus.encdec(byArray, byArray2, 1);
                return new String(Hex.encodeHex((byte[])byArray3));
            }
            catch (Exception exception) {
                if (DEBUGGING || VERBOSE) {
                    exception.printStackTrace();
                }
                return null;
            }
        }

        protected static String decrypt(String string, String string2) {
            if (string == null || "".equals(string) || string2 == null || "".equals(string2)) {
                return string;
            }
            try {
                byte[] byArray = string2.getBytes();
                byte[] byArray2 = Hex.decodeHex((char[])string.toCharArray());
                byte[] byArray3 = Cryptus.encdec(byArray, byArray2, 2);
                return new String(byArray3);
            }
            catch (Exception exception) {
                if (DEBUGGING || VERBOSE) {
                    exception.printStackTrace();
                }
                return null;
            }
        }

        private static byte[] encdec(byte[] byArray, byte[] byArray2, int n) throws GeneralSecurityException {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray3 = messageDigest.digest(byArray);
            DESKeySpec dESKeySpec = new DESKeySpec(byArray3, byArray3.length - 8);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = secretKeyFactory.generateSecret(dESKeySpec);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3, 0, 8);
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            cipher.init(n, (Key)secretKey, ivParameterSpec);
            return cipher.doFinal(byArray2);
        }
    }

    private static class ValidityNotifier {
        private IVerifyListener listener;
        private Display display;

        public ValidityNotifier(IVerifyListener iVerifyListener) {
            this.listener = iVerifyListener;
            this.display = Display.getCurrent();
        }

        public void notifyValidityListener(final IValidity iValidity) {
            if (this.display != null) {
                if (!this.display.isDisposed()) {
                    this.display.syncExec(new Runnable(){

                        public void run() {
                            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                                public void run() throws Exception {
                                    ValidityNotifier.this.listener.notifyValidity(iValidity);
                                }
                            });
                        }
                    });
                }
            } else {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        ValidityNotifier.this.listener.notifyValidity(iValidity);
                    }
                });
            }
        }

        public boolean notifyValidityCallback(IValidity iValidity) {
            this.notifyValidityListener(iValidity);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VerificationJob
    extends Job {
        private static final String CLEARED = "cleared";
        private List<String> actionNames = new ArrayList<String>(2);
        private int requiredStatus;
        private int style;
        private IStatus validity;
        private String licenseKey = null;
        private String licenseEmail = null;
        private String user = null;
        private String authToken = null;
        private String subscriptionExpireDate = null;
        private String uid = null;
        private String expiration = null;
        private XMindNetRequest retrieveUIDRequest = new XMindNetRequest(true);
        private XMindNetRequest retrieveSubscriptionRequest = new XMindNetRequest(true);
        private Window currentDialog = null;
        private Properties userInput;

        public VerificationJob(String string, int n, int n2, Properties properties) {
            super("Verify License");
            if (string != null) {
                this.actionNames.add(string);
            }
            this.requiredStatus = n;
            this.style = n2;
            if (properties == null) {
                this.userInput = null;
            } else {
                this.userInput = new Properties();
                this.userInput.putAll((Map<?, ?>)properties);
            }
            this.validity = LicenseVerifier.createValidity(1024);
            this.setSystem(true);
        }

        public void updateActionName(String string) {
            if (string != null) {
                this.actionNames.add(string);
            }
        }

        public void updateRequiredStatus(int n) {
            this.requiredStatus &= n;
        }

        public void updateStyle(int n) {
            this.style = VerificationJob.mergeStyle(this.style, n, 1, true);
            this.style = VerificationJob.mergeStyle(this.style, n, 2, true);
            this.style = VerificationJob.mergeStyle(this.style, n, 4, false);
            this.style = VerificationJob.mergeStyle(this.style, n, 8, false);
        }

        private static int mergeStyle(int n, int n2, int n3, boolean bl) {
            if (bl) {
                return n & (n2 & n3 | ~n3);
            }
            return n | n2 & n3;
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            this.verify(iProgressMonitor);
            if (iProgressMonitor.isCanceled() && !LicenseVerifier.checkValid(this.validity, 7)) {
                this.validity = LicenseVerifier.createValidity(1024, null, null, null, true);
            }
            LicenseVerifier.saveLocalData(this.uid, this.expiration, this.licenseKey, this.licenseEmail, this.subscriptionExpireDate);
            return this.validity;
        }

        private boolean isValid() {
            return LicenseVerifier.checkValid(this.validity, this.requiredStatus);
        }

        private void verify(IProgressMonitor iProgressMonitor) {
            this.verifyVindy(iProgressMonitor);
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            if (this.isValid()) {
                return;
            }
            this.loadDataFromLocalStorage(iProgressMonitor);
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            this.verifyLoadedData(iProgressMonitor);
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            if (this.userInput == null && (this.style & 8) == 0 && (this.isValid() || (this.style & 2) != 0)) {
                return;
            }
            this.waitForWorkbenchReady(iProgressMonitor);
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            this.showDialog(iProgressMonitor);
        }

        private void loadDataFromLocalStorage(IProgressMonitor iProgressMonitor) {
            Properties properties = LicenseVerifier.loadLocalData();
            if (properties != null) {
                this.licenseKey = properties.getProperty("WalkingInTheMorning");
                this.licenseEmail = properties.getProperty("TimeSmilesInMyHand");
                IAccountInfo iAccountInfo = XMindNet.getAccountInfo();
                this.user = iAccountInfo == null ? null : iAccountInfo.getUser();
                this.authToken = iAccountInfo == null ? null : iAccountInfo.getAuthToken();
                this.uid = properties.getProperty("ThisDawn");
                this.expiration = properties.getProperty("LastsAllDay");
                this.subscriptionExpireDate = properties.getProperty("LastAllDay");
            } else {
                IPreferenceStore iPreferenceStore = VerifyPlugin.getDefault().getPreferenceStore();
                this.licenseKey = iPreferenceStore.getString("licenseKey");
                this.licenseEmail = iPreferenceStore.getString("licenseEmail");
                this.uid = iPreferenceStore.getString("uid");
                this.expiration = iPreferenceStore.getString("expiration");
                LicenseVerifier.saveLocalData(this.uid, this.expiration, this.licenseKey, this.licenseEmail);
                iPreferenceStore.setToDefault("licenseKey");
                iPreferenceStore.setToDefault("licenseEmail");
                iPreferenceStore.setToDefault("uid");
                iPreferenceStore.setToDefault("expiration");
            }
            if (this.licenseKey == null || "".equals(this.licenseKey)) {
                this.licenseKey = System.getProperty("org.xmind.product.license.key", this.licenseKey);
            }
            if (this.licenseEmail == null || "".equals(this.licenseEmail)) {
                this.licenseEmail = System.getProperty("org.xmind.product.license.registeredEmail", this.licenseEmail);
            }
        }

        /*
         * Exception decompiling
         */
        private void waitForWorkbenchReady(IProgressMonitor var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean isWorkbenchReady() {
            return "workbenchReady".equals(System.getProperty("org.xmind.cathy.app.status"));
        }

        private void verifyLoadedData(IProgressMonitor iProgressMonitor) {
            IStatus iStatus;
            if (this.hasLicenseKey() && this.hasLicenseEmail()) {
                ILicenseKeyHeader iLicenseKeyHeader;
                iStatus = this.validity;
                this.verifyLicenseKey(iProgressMonitor);
                if ((this.validity.getCode() & 6) != 0 && this.validity instanceof IValidity && (iLicenseKeyHeader = ((IValidity)this.validity).getLicenseKeyHeader()) != null && "C".equals(iLicenseKeyHeader.getLicenseType())) {
                    if (DEBUGGING || VERBOSE) {
                        System.out.println("VLE license keys are excluded from activating non-VLE products.");
                    }
                    this.validity = iStatus;
                    if (DEBUGGING || VERBOSE) {
                        System.out.println("Reverted to back to previous validity: " + iStatus);
                    }
                }
            }
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            iStatus = this.validity;
            if (this.hasUser() && this.hasAuthToken()) {
                if (this.hasUID() && this.hasExpiration()) {
                    this.verifyLocalSubscriptionInfo(iProgressMonitor);
                    if (this.isValid()) {
                        this.mergeVeifyInfo(iStatus);
                        verified = true;
                        return;
                    }
                }
                if (iProgressMonitor.isCanceled()) {
                    return;
                }
                if (!verified) {
                    this.verifySubscription(iProgressMonitor);
                    if (this.isValid()) {
                        this.mergeVeifyInfo(iStatus);
                        verified = true;
                        return;
                    }
                }
                this.validity = iStatus;
                verified = true;
            }
        }

        private void mergeVeifyInfo(IStatus iStatus) {
            if (!LicenseVerifier.hasValidity(this.validity, 1) || LicenseVerifier.hasValidity(iStatus, 1024)) {
                return;
            }
            if (LicenseVerifier.hasValidity(iStatus, 2)) {
                if (iStatus instanceof IValidity) {
                    ILicenseKeyHeader iLicenseKeyHeader = ((IValidity)iStatus).getLicenseKeyHeader();
                    this.validity = LicenseVerifier.createValidity(3, ((IValidity)iStatus).getLicensedTo(), iLicenseKeyHeader);
                }
                return;
            }
            if (LicenseVerifier.hasValidity(iStatus, 4)) {
                this.validity = LicenseVerifier.createValidity(5, this.user, null);
                return;
            }
        }

        private void verifyLocalSubscriptionInfo(IProgressMonitor iProgressMonitor) {
            this.validity = LicenseVerifier.createValidity(LicenseVerifier.parseExpiration(this.expiration, this.uid), this.user, null);
        }

        private void verifyLicenseKey(IProgressMonitor iProgressMonitor) {
            String string = LicenseVerifier.trimLicenseKey(this.licenseKey);
            if (LicenseVerifier.isLicenseKeyBlacklisted(string, this.licenseEmail)) {
                this.validity = LicenseVerifier.createValidity(8192);
            } else {
                this.doVerifyLicenseKey(iProgressMonitor, this.licenseEmail, string, this.licenseEmail);
                if (!this.isValid()) {
                    IStatus iStatus = this.validity;
                    this.doVerifyLicenseKey(iProgressMonitor, "sales+daobansiquanjia@xmind.net", string, this.licenseEmail);
                    if (!this.isValid()) {
                        this.validity = LegacyLicenseVerifierUtil.verifyLicenseKey(string);
                        if (!this.isLegacyValidity()) {
                            this.validity = iStatus;
                        }
                    }
                }
            }
        }

        private void doVerifyLicenseKey(IProgressMonitor iProgressMonitor, String string, String string2, String string3) {
            string = string.toLowerCase();
            if (VERBOSE) {
                System.out.println("Verifying license key: " + string2);
            }
            if (string2.length() != 225) {
                if (DEBUGGING || VERBOSE) {
                    System.out.println("Invalid license key length: " + string2.length());
                }
                this.validity = LicenseVerifier.createValidity(8192);
                return;
            }
            try {
                int n;
                Object[] objectArray;
                String string4 = string2.substring(0, 12);
                LicenseKeyHeader licenseKeyHeader = LicenseKeyHeader.decode(string4);
                if (VERBOSE) {
                    System.out.println("License key header: " + licenseKeyHeader.toString());
                }
                String string5 = licenseKeyHeader.getLicenseType();
                if (VERBOSE) {
                    System.out.println("License key type: " + string5);
                }
                if ((objectArray = VerificationJob.getCommonVerifierParameters(string5)) == null) {
                    if (DEBUGGING || VERBOSE) {
                        System.out.println("Unrecognized license key type: " + string5);
                    }
                    this.validity = LicenseVerifier.createValidity(8192, null, licenseKeyHeader, null, false);
                    return;
                }
                String string6 = (String)objectArray[0];
                byte[] byArray = (byte[])objectArray[1];
                if (VERBOSE) {
                    System.out.println("License key base suffix: " + string6);
                    System.out.println("License key public key: " + Arrays.toString(byArray));
                }
                if ("B".equals(string5)) {
                    n = 4;
                    if (VERBOSE) {
                        System.out.println("License key is for XMind Plus (" + licenseKeyHeader.getLicenseeType() + ").");
                    }
                } else {
                    n = 2;
                    if (VERBOSE) {
                        System.out.println("License key is for XMind Pro (" + licenseKeyHeader.getLicenseeType() + ").");
                    }
                }
                String string7 = String.valueOf(string2.substring(0, 20)) + string + string6;
                String string8 = string2.substring(20);
                if (VERBOSE) {
                    System.out.println("Base (UTF-8): " + string7);
                    System.out.println("Signature (Base32): " + string8);
                }
                byte[] byArray2 = string7.getBytes("UTF-8");
                byte[] byArray3 = Base32.decode(string8);
                if (VERBOSE) {
                    System.out.println("Base: " + Arrays.toString(byArray2));
                    System.out.println("Signature: " + Arrays.toString(byArray3));
                }
                if (this.checkSignatureValid(byArray2, byArray3, byArray)) {
                    if (VERBOSE) {
                        System.out.println("Verified: VALID. Licensed to '" + string3 + "'.");
                    }
                    this.validity = LicenseVerifier.createValidity(n, string3, licenseKeyHeader);
                } else {
                    if (DEBUGGING || VERBOSE) {
                        System.out.println("Invalid signature: " + string8);
                    }
                    this.validity = LicenseVerifier.createValidity(8192);
                }
            }
            catch (Throwable throwable) {
                if (DEBUGGING) {
                    throwable.printStackTrace();
                }
                this.validity = LicenseVerifier.createValidity(0x40000000, throwable);
            }
        }

        private boolean checkSignatureValid(byte[] byArray, byte[] byArray2, byte[] byArray3) throws Exception {
            return true;
        }

        private void verifyVindy(IProgressMonitor iProgressMonitor) {
            String string = System.getProperty("org.xmind.product.distribution.id");
            if (string == null || "".equals(string) || !string.startsWith("vindy")) {
                return;
            }
            String string2 = System.getProperty("org.xmind.product.distribution.vindy.org");
            if (string2 == null || "".equals(string2)) {
                return;
            }
            String string3 = System.getProperty("org.xmind.product.distribution.vindy.time");
            if (string3 == null || "".equals(string3)) {
                return;
            }
            String string4 = System.getProperty("org.xmind.product.distribution.vindy.name");
            if (string4 == null || "".equals(string4)) {
                return;
            }
            String string5 = String.valueOf(string) + "@" + string3;
            IStatus iStatus = this.validity;
            this.doVerifyLicenseKey(iProgressMonitor, string5, LicenseVerifier.trimLicenseKey(string4), string2);
            if (!this.isValid()) {
                this.validity = iStatus;
            }
        }

        private void verifySubscription(IProgressMonitor iProgressMonitor) {
            this.retrieveUID(iProgressMonitor);
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            if (this.hasUID()) {
                this.retrieveSubscription(iProgressMonitor);
            }
        }

        private void showDialog(IProgressMonitor iProgressMonitor) {
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            while (!iProgressMonitor.isCanceled()) {
                int n;
                if (this.userInput == null) {
                    n = LicenseVerifier.hasValidity(this.validity, 2) ? 2 : (LicenseVerifier.hasValidity(this.validity, 1) && !LicenseVerifier.hasValidity(this.validity, 2) ? 1 : (this.isValid() && !LicenseVerifier.hasValidity(this.validity, 1) && LicenseVerifier.hasValidity(this.validity, 4) ? 4 : this.openLicenseDialog(iProgressMonitor, iWorkbench)));
                    if (n < 0 || iProgressMonitor.isCanceled()) {
                        return;
                    }
                } else {
                    n = 7;
                }
                this.openVerifyTargetDialog(iProgressMonitor, iWorkbench, n);
                if (LicenseVerifier.hasValidity(this.validity, this.requiredStatus) && (this.style & 4) == 0 && (this.style & 8) == 0) break;
            }
        }

        private void openVerifyTargetDialog(IProgressMonitor iProgressMonitor, IWorkbench iWorkbench, int n) {
            String string = null;
            Properties properties = this.backupLocalData();
            IStatus iStatus = this.validity;
            while (!iProgressMonitor.isCanceled()) {
                Properties properties2 = this.openInputDialog(iProgressMonitor, iWorkbench, n, string);
                if (properties2 == null) {
                    this.loadDataFromUserInput(properties);
                    this.validity = iStatus;
                    return;
                }
                if (iProgressMonitor.isCanceled()) {
                    return;
                }
                this.loadDataFromUserInput(properties2);
                this.validity = LicenseVerifier.createValidity(1024);
                boolean[] blArray = new boolean[]{true};
                this.openVerifyingDialog(iProgressMonitor, iWorkbench, blArray);
                this.verifyLoadedData(iProgressMonitor);
                if (iProgressMonitor.isCanceled()) {
                    return;
                }
                blArray[0] = false;
                this.closeVerifyingDialog(iProgressMonitor, iWorkbench);
                if (this.isValid()) {
                    if (n == 1 || !LicenseVerifier.hasValidity(iStatus, 1) && LicenseVerifier.hasValidity(this.validity, 1)) {
                        long l = System.currentTimeMillis() + 604800L;
                        InternalXMindNet.getInstance().getAccount().signedIn(this.user, this.authToken, l, true);
                        this.openSubscriptionInfoDialog(iProgressMonitor, iWorkbench);
                    } else if (n != 1 && !LicenseVerifier.hasValidity(iStatus, n) && LicenseVerifier.hasValidity(this.validity, n)) {
                        this.openVerifyTargetDialog(iProgressMonitor, iWorkbench, n);
                    } else if (n == 6 && LicenseVerifier.hasValidity(iStatus, 1) && !LicenseVerifier.hasValidity(this.validity, 6)) {
                        string = Messages.LicenseInputDialog_InvalidLicenseKeyErrorMessage;
                        continue;
                    }
                    return;
                }
                if (properties2.getProperty(CLEARED) != null) {
                    return;
                }
                if (this.hasUser() && this.hasAuthToken()) {
                    long l = System.currentTimeMillis() + 604800L;
                    if (this.hasSubscriptionExpireDate()) {
                        InternalXMindNet.getInstance().getAccount().signedIn(this.user, this.authToken, l, true);
                    } else {
                        InternalXMindNet.getInstance().getAccount().signedIn(this.user, this.authToken, l, true);
                    }
                    this.openSubscriptionInfoDialog(iProgressMonitor, iWorkbench);
                    return;
                }
                string = this.generateErrorMessage();
            }
        }

        private void openSubscriptionInfoDialog(final IProgressMonitor iProgressMonitor, final IWorkbench iWorkbench) {
            while (!iProgressMonitor.isCanceled()) {
                this.runWithUI(iProgressMonitor, iWorkbench, new Runnable(){

                    public void run() {
                        SubscriptionInfoDialog subscriptionInfoDialog;
                        int n;
                        Shell shell = VerificationJob.this.getParentShell(iWorkbench);
                        int n2 = 4096;
                        long l = 0L;
                        if (VerificationJob.this.expiration != null) {
                            n2 = LicenseVerifier.parseExpiration(VerificationJob.this.expiration, VerificationJob.this.uid);
                            l = LicenseVerifier.parseExpireDate(VerificationJob.this.expiration, VerificationJob.this.uid);
                        }
                        if (VerificationJob.this.subscriptionExpireDate != null) {
                            l = LicenseVerifier.parseExpireDate(VerificationJob.this.subscriptionExpireDate, VerificationJob.this.uid);
                        }
                        if ((n = (subscriptionInfoDialog = new SubscriptionInfoDialog(shell, n2, VerificationJob.this.user, l)).open()) != 1025) {
                            iProgressMonitor.setCanceled(true);
                            verified = true;
                        }
                    }
                }, false);
            }
        }

        private void openVerifyingDialog(final IProgressMonitor iProgressMonitor, final IWorkbench iWorkbench, final boolean[] blArray) {
            this.runWithUI(iProgressMonitor, iWorkbench, new Runnable(){

                public void run() {
                    if (!blArray[0]) {
                        return;
                    }
                    Shell shell = VerificationJob.this.getParentShell(iWorkbench);
                    VerifyingStatusDialog verifyingStatusDialog = new VerifyingStatusDialog(shell);
                    VerificationJob.this.currentDialog = (Window)verifyingStatusDialog;
                    int n = verifyingStatusDialog.open();
                    VerificationJob.this.currentDialog = null;
                    if (n != 0) {
                        VerificationJob.this.cancel();
                        iProgressMonitor.setCanceled(true);
                    }
                }
            }, true, 200);
        }

        private void closeVerifyingDialog(IProgressMonitor iProgressMonitor, IWorkbench iWorkbench) {
            this.runWithUI(iProgressMonitor, iWorkbench, new Runnable(){

                public void run() {
                    if (VerificationJob.this.currentDialog != null) {
                        VerificationJob.this.currentDialog.close();
                        VerificationJob.this.currentDialog = null;
                    }
                }
            }, false);
        }

        private String generateErrorMessage() {
            if (LicenseVerifier.hasValidity(this.validity, 8192)) {
                return Messages.LicenseInputDialog_InvalidLicenseKeyErrorMessage;
            }
            if (LicenseVerifier.hasValidity(this.validity, 2048)) {
                return Messages.LicenseInputDialog_SubscriptionExpiredErrorMessage;
            }
            if (LicenseVerifier.hasValidity(this.validity, 4096)) {
                return Messages.LicenseInputDialog_NotSubscribedErrorMessage;
            }
            if (LicenseVerifier.hasValidity(this.validity, 0x40000000)) {
                return Messages.LicenseInputDialog_UnexpectedErrorMessage;
            }
            if (this.isLegacyValidity()) {
                return this.getLegacyErrorMessage();
            }
            return null;
        }

        private String getLegacyErrorMessage() {
            if (this.validity instanceof LegacyValidity) {
                int n = ((LegacyValidity)this.validity).getLegacyVersion();
                if (LegacyValidity.LegacyVersion.XMIND_2012.getValue() == n) {
                    return Messages.LicenseInputDialog_LegacyLicenseKeyErrorMessage_XMind2012;
                }
                if (LegacyValidity.LegacyVersion.XMIND_2013_PRO.getValue() == n) {
                    return Messages.LicenseInputDialog_LegacyLicenseKeyErrorMessage_XMind2013Pro;
                }
                if (LegacyValidity.LegacyVersion.XMIND_2013_PLUS.getValue() == n) {
                    return Messages.LicenseInputDialog_LegacyLicenseKeyErrorMessage_XMind2013Plus;
                }
            }
            return null;
        }

        private Properties backupLocalData() {
            Properties properties = new Properties();
            if (this.licenseEmail != null) {
                properties.setProperty("TimeSmilesInMyHand", this.licenseEmail);
            }
            if (this.licenseKey != null) {
                properties.setProperty("WalkingInTheMorning", this.licenseKey);
            }
            if (this.user != null) {
                properties.setProperty("user", this.user);
            }
            if (this.authToken != null) {
                properties.setProperty("token", this.authToken);
            }
            if (this.uid != null) {
                properties.setProperty("ThisDawn", this.uid);
            }
            if (this.expiration != null) {
                properties.setProperty("LastsAllDay", this.expiration);
            }
            if (this.subscriptionExpireDate != null) {
                properties.setProperty("LastAllDay", this.subscriptionExpireDate);
            }
            return properties;
        }

        private int openLicenseDialog(IProgressMonitor iProgressMonitor, final IWorkbench iWorkbench) {
            final int[] nArray = new int[]{-1};
            this.runWithUI(iProgressMonitor, iWorkbench, new Runnable(){

                public void run() {
                    Shell shell = VerificationJob.this.getParentShell(iWorkbench);
                    LicenseInfoDialog2 licenseInfoDialog2 = new LicenseInfoDialog2(shell, VerificationJob.joinStr(VerificationJob.this.actionNames), VerificationJob.this.requiredStatus, VerificationJob.this.validity.getCode(), (VerificationJob.this.style & 4) != 0, (VerificationJob.this.style & 8) != 0, VerificationJob.this.validity instanceof IValidity && (VerificationJob.this.validity.getCode() & 7) != 0 ? ((IValidity)VerificationJob.this.validity).getLicensedTo() : null);
                    VerificationJob.this.currentDialog = (Window)licenseInfoDialog2;
                    int n = licenseInfoDialog2.open();
                    VerificationJob.this.currentDialog = null;
                    nArray[0] = n == 0 ? licenseInfoDialog2.getTargetStatus() : -1;
                }
            }, false);
            return nArray[0];
        }

        private boolean hasLicenseOrSubscription() {
            return LicenseVerifier.hasValidity(this.validity, 4) || LicenseVerifier.hasValidity(this.validity, 2) || LicenseVerifier.hasValidity(this.validity, 1);
        }

        private Properties openInputDialog(final IProgressMonitor iProgressMonitor, final IWorkbench iWorkbench, final int n, final String string) {
            final Properties properties = this.backupLocalData();
            Properties properties2 = this.userInput;
            this.userInput = null;
            if (properties2 != null) {
                if (properties2.containsKey(LicenseVerifier.PROP_LICENSE_EMAIL)) {
                    properties.setProperty("TimeSmilesInMyHand", properties2.getProperty(LicenseVerifier.PROP_LICENSE_EMAIL));
                }
                if (properties2.containsKey(LicenseVerifier.PROP_LICENSE_KEY)) {
                    properties.setProperty("WalkingInTheMorning", properties2.getProperty(LicenseVerifier.PROP_LICENSE_KEY));
                }
            }
            final boolean[] blArray = new boolean[1];
            if ((n & 6) != 0) {
                this.runWithUI(iProgressMonitor, iWorkbench, new Runnable(){

                    public void run() {
                        Shell shell = VerificationJob.this.getParentShell(iWorkbench);
                        LicenseKeyInputDialog2 licenseKeyInputDialog2 = new LicenseKeyInputDialog2(shell, properties, VerificationJob.this.requiredStatus, VerificationJob.this.validity, false, LicenseVerifier.hasValidity(VerificationJob.this.validity, n));
                        licenseKeyInputDialog2.setErrorMessage(string);
                        VerificationJob.this.currentDialog = (Window)licenseKeyInputDialog2;
                        int n2 = licenseKeyInputDialog2.open();
                        VerificationJob.this.currentDialog = null;
                        if (n2 == 1024) {
                            properties.setProperty(VerificationJob.CLEARED, "yes");
                        }
                        if (n2 == 0 && LicenseVerifier.hasValidity(VerificationJob.this.validity, 6) && !LicenseVerifier.hasValidity(VerificationJob.this.validity, 1)) {
                            iProgressMonitor.setCanceled(true);
                        }
                        if (n2 == 1025) {
                            iProgressMonitor.setCanceled(true);
                        }
                        if (n2 == 1 && VerificationJob.this.hasLicenseOrSubscription()) {
                            iProgressMonitor.setCanceled(true);
                        }
                        blArray[0] = n2 != 0 && n2 != 1024;
                    }
                }, false);
            } else if (!(n != 1 || this.hasUser() && this.hasAuthToken())) {
                this.runWithUI(iProgressMonitor, iWorkbench, new Runnable(){

                    public void run() {
                        Shell shell = VerificationJob.this.getParentShell(iWorkbench);
                        SignInDialog3 signInDialog3 = new SignInDialog3(shell, Messages.LicenseInputDialog_SignInMessage, null, false, properties);
                        signInDialog3.setErrorMessage(string);
                        VerificationJob.this.currentDialog = (Window)signInDialog3;
                        int n = signInDialog3.open();
                        VerificationJob.this.currentDialog = null;
                        boolean bl = blArray[0] = n != 0;
                        if (n == 0) {
                            properties.remove("ThisDawn");
                            properties.remove("LastsAllDay");
                            properties.remove("LastAllDay");
                            verified = false;
                        }
                    }
                }, false);
            }
            if (blArray[0]) {
                return null;
            }
            return properties;
        }

        private void runWithUI(IProgressMonitor iProgressMonitor, IWorkbench iWorkbench, Runnable runnable, boolean bl) {
            this.runWithUI(iProgressMonitor, iWorkbench, runnable, bl, 0);
        }

        private void runWithUI(IProgressMonitor iProgressMonitor, IWorkbench iWorkbench, final Runnable runnable, boolean bl, final int n) {
            final Display display = iWorkbench.getDisplay();
            if (display == null || display.isDisposed()) {
                this.cancel();
                iProgressMonitor.setCanceled(true);
                return;
            }
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            final Throwable[] throwableArray = new Throwable[]{null};
            final Runnable runnable2 = new Runnable(){

                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        throwableArray[0] = throwable;
                    }
                }
            };
            if (bl) {
                if (n > 0) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            display.timerExec(n, runnable2);
                        }
                    });
                } else {
                    display.asyncExec(runnable2);
                }
            } else {
                display.syncExec(runnable2);
            }
            if (throwableArray[0] != null) {
                throw new IllegalStateException(throwableArray[0].getLocalizedMessage(), throwableArray[0]);
            }
        }

        private Shell getParentShell(IWorkbench iWorkbench) {
            Shell shell;
            IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
            Shell shell2 = shell = iWorkbenchWindow == null ? null : iWorkbenchWindow.getShell();
            if (shell != null && shell.isDisposed()) {
                shell = null;
            }
            return shell;
        }

        private static String joinStr(Collection<String> collection) {
            StringBuffer stringBuffer = new StringBuffer(collection.size() * 10);
            for (String string : collection) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }

        private void loadDataFromUserInput(Properties properties) {
            this.licenseEmail = properties.getProperty("TimeSmilesInMyHand");
            this.licenseKey = properties.getProperty("WalkingInTheMorning");
            this.user = properties.getProperty("user");
            this.authToken = properties.getProperty("token");
            this.uid = properties.getProperty("ThisDawn");
            this.expiration = properties.getProperty("LastsAllDay");
            this.subscriptionExpireDate = properties.getProperty("LastAllDay");
        }

        private void retrieveSubscription(IProgressMonitor iProgressMonitor) {
            this.retrieveSubscriptionRequest.path("/_res/verify/%s", new Object[]{this.user}).addHeader("UID", this.uid).get();
            if (iProgressMonitor.isCanceled() || this.retrieveSubscriptionRequest.isAborted()) {
                return;
            }
            int n = this.retrieveSubscriptionRequest.getStatusCode();
            IDataStore iDataStore = this.retrieveSubscriptionRequest.getData();
            if (n == 200 && iDataStore != null) {
                this.expiration = LicenseVerifier.extractExpiration(iDataStore, this.uid);
                this.subscriptionExpireDate = LicenseVerifier.extractExpireDate(iDataStore, this.uid);
                this.validity = this.expiration == null ? LicenseVerifier.createValidity(4096) : LicenseVerifier.createValidity(LicenseVerifier.parseExpiration(this.expiration, this.uid), this.user, null);
            } else if (this.retrieveUIDRequest.getError() != null) {
                this.validity = LicenseVerifier.createValidity(0x40000000, this.retrieveUIDRequest.getError());
            } else if (n >= 500 || n < 400) {
                this.validity = LicenseVerifier.createValidity(0x40000000);
            }
        }

        private void retrieveUID(IProgressMonitor iProgressMonitor) {
            this.retrieveUIDRequest.path("/_res/uid/%s", new Object[]{this.user}).setAuthToken(this.authToken).get();
            if (iProgressMonitor.isCanceled() || this.retrieveUIDRequest.isAborted()) {
                return;
            }
            int n = this.retrieveUIDRequest.getStatusCode();
            IDataStore iDataStore = this.retrieveUIDRequest.getData();
            if (n == 200 && iDataStore != null) {
                this.uid = iDataStore.getString("uid");
            } else if (this.retrieveUIDRequest.getError() != null) {
                this.validity = LicenseVerifier.createValidity(0x40000000, this.retrieveUIDRequest.getError());
            } else if (n >= 500 || n < 400) {
                this.validity = LicenseVerifier.createValidity(0x40000000);
            }
        }

        private boolean hasLicenseKey() {
            return this.licenseKey != null && !"".equals(this.licenseKey);
        }

        private boolean hasLicenseEmail() {
            return this.licenseEmail != null && !"".equals(this.licenseEmail);
        }

        private boolean hasUser() {
            return this.user != null && !"".equals(this.user);
        }

        private boolean hasAuthToken() {
            return this.authToken != null && !"".equals(this.authToken);
        }

        private boolean hasSubscriptionExpireDate() {
            return this.subscriptionExpireDate != null && !"".equals(this.subscriptionExpireDate);
        }

        private boolean hasUID() {
            return this.uid != null && !"".equals(this.uid);
        }

        private boolean hasExpiration() {
            return this.expiration != null && !"".equals(this.expiration);
        }

        protected void canceling() {
            Display display;
            IWorkbench iWorkbench;
            this.retrieveUIDRequest.abort();
            this.retrieveSubscriptionRequest.abort();
            final Window window = this.currentDialog;
            if (window != null && (iWorkbench = PlatformUI.getWorkbench()) != null && (display = iWorkbench.getDisplay()) != null && !display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (display.isDisposed()) {
                            return;
                        }
                        window.close();
                    }
                });
            }
            super.canceling();
        }

        private static Object[] getCommonVerifierParameters(String string) {
            if (VerifyPlugin.getDefault().isDebugging(LicenseVerifier.DEBUG_KEYS)) {
                return VerificationJob.getDebuggingCommonVerifierParameters(string);
            }
            if ("A".equals(string)) {
                return new Object[]{"Ae;\t&2}w#n`If5!nu6#{!hBA1IMDx%\n", new byte[]{77, 73, 71, 102, 77, 65, 48, 71, 67, 83, 113, 71, 83, 73, 98, 51, 68, 81, 69, 66, 65, 81, 85, 65, 65, 52, 71, 78, 65, 68, 67, 66, 105, 81, 75, 66, 103, 81, 68, 68, 112, 79, 90, 54, 51, 50, 66, 83, 53, 108, 65, 99, 99, 53, 71, 86, 109, 122, 114, 51, 51, 114, 84, 100, 66, 106, 79, 48, 104, 69, 104, 52, 48, 70, 74, 48, 57, 110, 108, 113, 114, 71, 72, 80, 80, 47, 68, 97, 84, 87, 122, 86, 73, 73, 74, 57, 116, 108, 97, 83, 51, 56, 109, 87, 90, 69, 99, 109, 117, 77, 121, 113, 56, 115, 107, 74, 82, 106, 76, 83, 101, 98, 49, 101, 108, 83, 66, 56, 115, 88, 54, 82, 100, 54, 43, 51, 118, 88, 105, 121, 43, 105, 48, 72, 66, 80, 115, 85, 54, 82, 84, 54, 57, 86, 98, 70, 47, 118, 51, 121, 71, 43, 72, 78, 111, 103, 72, 77, 117, 75, 114, 97, 87, 86, 80, 75, 71, 99, 51, 74, 87, 56, 121, 84, 78, 78, 76, 65, 120, 50, 71, 80, 101, 118, 77, 51, 82, 79, 55, 109, 53, 99, 70, 81, 114, 67, 73, 107, 111, 119, 73, 68, 65, 81, 65, 66}};
            }
            if ("B".equals(string)) {
                return new Object[]{"/[{%R<M$MP\t%6$(hp}Cs=49<JQ\"V4m\n", new byte[]{77, 73, 71, 102, 77, 65, 48, 71, 67, 83, 113, 71, 83, 73, 98, 51, 68, 81, 69, 66, 65, 81, 85, 65, 65, 52, 71, 78, 65, 68, 67, 66, 105, 81, 75, 66, 103, 81, 68, 99, 109, 109, 65, 87, 68, 75, 80, 98, 85, 76, 67, 87, 90, 120, 53, 79, 83, 66, 113, 90, 121, 82, 68, 67, 50, 101, 55, 69, 98, 76, 69, 71, 55, 56, 51, 65, 112, 73, 100, 73, 88, 73, 109, 66, 85, 117, 122, 108, 67, 48, 52, 115, 81, 80, 102, 120, 67, 81, 76, 114, 71, 113, 52, 83, 85, 47, 105, 116, 53, 71, 120, 79, 107, 87, 54, 109, 106, 77, 77, 53, 52, 112, 81, 101, 88, 120, 100, 100, 108, 50, 74, 79, 99, 120, 67, 67, 77, 51, 54, 69, 90, 77, 111, 104, 108, 51, 118, 74, 72, 65, 73, 115, 97, 53, 72, 118, 83, 52, 71, 66, 54, 106, 98, 43, 50, 98, 50, 116, 47, 73, 68, 111, 104, 48, 98, 55, 56, 105, 52, 74, 104, 65, 65, 80, 53, 114, 105, 69, 54, 70, 112, 87, 43, 99, 77, 52, 110, 53, 122, 117, 118, 71, 55, 52, 88, 49, 116, 67, 53, 81, 73, 68, 65, 81, 65, 66}};
            }
            if ("C".equals(string)) {
                return new Object[]{"VqNMK{?5o<8SdD^hNb#.\n\\5}pN4<_L\t", new byte[]{77, 73, 71, 102, 77, 65, 48, 71, 67, 83, 113, 71, 83, 73, 98, 51, 68, 81, 69, 66, 65, 81, 85, 65, 65, 52, 71, 78, 65, 68, 67, 66, 105, 81, 75, 66, 103, 81, 68, 103, 72, 98, 71, 43, 80, 111, 105, 115, 68, 103, 111, 51, 43, 104, 53, 74, 85, 89, 100, 104, 49, 113, 76, 53, 111, 48, 67, 99, 118, 78, 120, 119, 101, 53, 85, 107, 113, 76, 68, 78, 114, 89, 51, 69, 103, 119, 49, 43, 51, 107, 85, 90, 78, 121, 90, 75, 104, 110, 104, 71, 52, 115, 67, 112, 78, 72, 117, 90, 52, 114, 73, 69, 109, 71, 70, 105, 57, 81, 66, 79, 99, 54, 86, 76, 113, 51, 72, 109, 66, 119, 50, 43, 98, 89, 116, 98, 106, 120, 100, 53, 56, 49, 118, 111, 43, 86, 108, 116, 104, 89, 57, 79, 66, 55, 71, 56, 76, 87, 89, 110, 52, 43, 80, 56, 47, 110, 89, 49, 84, 77, 112, 107, 82, 88, 55, 65, 52, 112, 114, 106, 99, 118, 121, 121, 104, 66, 98, 65, 54, 90, 115, 108, 102, 111, 80, 120, 65, 108, 113, 52, 66, 56, 118, 88, 114, 97, 110, 98, 101, 81, 73, 68, 65, 81, 65, 66}};
            }
            return null;
        }

        private static Object[] getDebuggingCommonVerifierParameters(String string) {
            if ("A".equals(string)) {
                return new Object[]{"PRO\n\t1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~-=!@#$%^&*()_+[]\\{}|;':\",./<>?", new byte[]{77, 73, 71, 102, 77, 65, 48, 71, 67, 83, 113, 71, 83, 73, 98, 51, 68, 81, 69, 66, 65, 81, 85, 65, 65, 52, 71, 78, 65, 68, 67, 66, 105, 81, 75, 66, 103, 81, 67, 50, 76, 70, 119, 43, 114, 68, 105, 101, 86, 75, 57, 88, 80, 54, 120, 113, 69, 120, 117, 55, 109, 75, 119, 68, 56, 47, 65, 47, 66, 89, 105, 101, 105, 69, 113, 49, 48, 119, 100, 110, 81, 120, 48, 74, 120, 43, 90, 89, 102, 119, 78, 82, 87, 53, 89, 114, 72, 53, 52, 74, 107, 85, 113, 48, 119, 81, 114, 65, 104, 82, 54, 98, 68, 50, 57, 49, 70, 81, 70, 90, 84, 66, 100, 74, 119, 103, 79, 87, 106, 43, 117, 119, 89, 48, 98, 84, 77, 100, 122, 109, 81, 79, 75, 111, 107, 90, 54, 114, 112, 115, 80, 79, 100, 113, 103, 74, 43, 65, 98, 100, 84, 87, 69, 122, 76, 51, 70, 113, 66, 120, 56, 65, 90, 97, 115, 103, 107, 117, 117, 87, 77, 89, 50, 114, 53, 114, 65, 88, 84, 98, 107, 117, 81, 65, 68, 99, 118, 86, 121, 107, 117, 105, 77, 87, 101, 100, 80, 48, 109, 119, 73, 68, 65, 81, 65, 66}};
            }
            if ("B".equals(string)) {
                return new Object[]{"PLUS\n\t1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~-=!@#$%^&*()_+[]\\{}|;':\",./<>?", new byte[]{77, 73, 71, 102, 77, 65, 48, 71, 67, 83, 113, 71, 83, 73, 98, 51, 68, 81, 69, 66, 65, 81, 85, 65, 65, 52, 71, 78, 65, 68, 67, 66, 105, 81, 75, 66, 103, 81, 68, 109, 90, 80, 49, 77, 109, 76, 122, 120, 52, 109, 86, 71, 106, 79, 86, 68, 67, 105, 80, 52, 80, 110, 118, 112, 86, 115, 100, 74, 120, 120, 73, 102, 57, 78, 100, 122, 68, 48, 112, 105, 74, 109, 105, 104, 80, 43, 52, 74, 115, 102, 105, 83, 112, 90, 84, 83, 97, 81, 54, 70, 74, 102, 66, 82, 66, 68, 54, 43, 104, 108, 81, 87, 83, 102, 67, 47, 77, 47, 103, 52, 47, 73, 53, 108, 89, 55, 52, 109, 89, 77, 101, 119, 116, 118, 77, 116, 57, 112, 82, 110, 103, 83, 71, 80, 121, 74, 75, 121, 52, 120, 116, 111, 99, 82, 78, 48, 55, 82, 67, 89, 71, 119, 97, 115, 67, 79, 85, 109, 101, 43, 115, 88, 98, 116, 86, 85, 117, 107, 98, 100, 103, 66, 88, 110, 53, 65, 74, 100, 115, 54, 99, 101, 43, 51, 109, 117, 70, 97, 113, 106, 55, 109, 48, 74, 115, 85, 88, 83, 119, 119, 73, 68, 65, 81, 65, 66}};
            }
            if ("C".equals(string)) {
                return new Object[]{"VINDY\n\t1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~-=!@#$%^&*()_+[]\\{}|;':\",./<>?", new byte[]{77, 73, 71, 102, 77, 65, 48, 71, 67, 83, 113, 71, 83, 73, 98, 51, 68, 81, 69, 66, 65, 81, 85, 65, 65, 52, 71, 78, 65, 68, 67, 66, 105, 81, 75, 66, 103, 81, 68, 81, 53, 50, 49, 77, 71, 104, 43, 97, 73, 99, 107, 57, 78, 84, 49, 80, 76, 119, 79, 98, 75, 102, 85, 115, 118, 89, 86, 76, 50, 54, 82, 50, 114, 112, 108, 51, 102, 100, 54, 72, 84, 67, 120, 50, 78, 83, 113, 83, 72, 119, 102, 48, 56, 106, 43, 78, 108, 70, 113, 85, 67, 88, 65, 86, 122, 102, 75, 110, 114, 114, 75, 72, 56, 49, 111, 65, 79, 101, 57, 52, 47, 66, 70, 89, 54, 118, 80, 121, 68, 80, 105, 111, 83, 83, 52, 89, 82, 68, 118, 87, 48, 77, 85, 97, 70, 86, 74, 98, 121, 77, 50, 109, 77, 104, 53, 89, 51, 98, 106, 121, 55, 48, 113, 69, 73, 68, 114, 101, 73, 87, 85, 100, 66, 107, 111, 114, 109, 88, 83, 79, 69, 55, 114, 43, 89, 82, 82, 122, 80, 110, 66, 85, 55, 76, 98, 84, 103, 74, 98, 113, 120, 82, 88, 100, 85, 114, 104, 87, 77, 81, 73, 68, 65, 81, 65, 66}};
            }
            return null;
        }

        private boolean isLegacyValidity() {
            return LicenseVerifier.checkValid(this.validity, 16384);
        }
    }
}

