/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.verify.legacy;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import net.xmind.signin.XMindNet;
import net.xmind.verify.internal.Messages;
import net.xmind.verify.internal.Validity;
import net.xmind.verify.legacy.internal.LegacyValidity;
import net.xmind.verify.legacy.internal.XMind2012LicenseVerifier;
import net.xmind.verify.legacy.internal.XMind2013LicenseVerifier;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.xmind.ui.dialogs.Notification;

public class LegacyLicenseVerifierUtil {
    public static final String PREF_SHOW_LEGACY_TIP = "Legacy";

    private LegacyLicenseVerifierUtil() {
    }

    public static IStatus verifyLicenseKey(String string) {
        int n = new XMind2012LicenseVerifier().verifiyLicenseKey(string);
        if (LegacyValidity.LegacyVersion.isLegacyVersion(n)) {
            return LegacyLicenseVerifierUtil.createLegacyValidity(n);
        }
        n = new XMind2013LicenseVerifier().verifyLicenseKey(string);
        if (LegacyValidity.LegacyVersion.isLegacyVersion(n)) {
            return LegacyLicenseVerifierUtil.createLegacyValidity(n);
        }
        return LegacyLicenseVerifierUtil.createInvalidValidity();
    }

    private static IStatus createInvalidValidity() {
        return new Validity(0, "net.xmind.verify", 8192, null, null, null, null);
    }

    private static IStatus createLegacyValidity(int n) {
        return new LegacyValidity(n);
    }

    public static void checkLicenseKey() {
        Properties properties = LegacyLicenseVerifierUtil.loadLocalData();
        if (properties == null || !LegacyLicenseVerifierUtil.showLegacyTip()) {
            return;
        }
        String string = properties.getProperty("WalkingInTheMorning");
        IStatus iStatus = LegacyLicenseVerifierUtil.verifyLicenseKey(string);
        if (LegacyLicenseVerifierUtil.checkValid(iStatus, 16384) && iStatus instanceof LegacyValidity) {
            int n = ((LegacyValidity)iStatus).getLegacyVersion();
            LegacyLicenseVerifierUtil.doShowNotification(n);
        }
    }

    private static Properties loadLocalData() {
        File file = LegacyLicenseVerifierUtil.getStateFile();
        if (file != null && file.exists() && file.isFile()) {
            Properties properties = new Properties();
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 1024);
                try {
                    properties.load(bufferedInputStream);
                }
                finally {
                    ((InputStream)bufferedInputStream).close();
                }
                String string = properties.getProperty("TimeSmilesInMyHand");
                String string2 = properties.getProperty("WalkingInTheMorning");
                LegacyLicenseVerifierUtil.saveState(properties, "WalkingInTheMorning", Cryptus.decrypt(string2, string));
                return properties;
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static boolean showLegacyTip() {
        Properties properties = LegacyLicenseVerifierUtil.loadLegacyFile();
        if (properties == null) {
            return true;
        }
        return !"false".equals(properties.getProperty(PREF_SHOW_LEGACY_TIP));
    }

    private static Properties loadLegacyFile() {
        File file = LegacyLicenseVerifierUtil.getLegacyFile();
        if (file != null && file.exists() && file.isFile()) {
            Properties properties = new Properties();
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 1024);
                try {
                    properties.load(bufferedInputStream);
                }
                finally {
                    ((InputStream)bufferedInputStream).close();
                }
                return properties;
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static File getLegacyFile() {
        return LegacyLicenseVerifierUtil.getLocalFile(".legacy");
    }

    private static File getStateFile() {
        return LegacyLicenseVerifierUtil.getLocalFile(".poem");
    }

    private static File getLocalFile(String string) {
        Bundle bundle = Platform.getBundle((String)"net.xmind.verify");
        if (bundle != null) {
            File file = Platform.getStateLocation((Bundle)bundle).toFile();
            return new File(file, string);
        }
        return null;
    }

    private static void saveState(Properties properties, String string, String string2) {
        if (string2 != null && !"".equals(string2)) {
            properties.setProperty(string, string2);
        } else {
            properties.remove(string);
        }
    }

    private static void saveLegacyState(boolean bl) {
        File file = LegacyLicenseVerifierUtil.getLegacyFile();
        if (file == null) {
            return;
        }
        Properties properties = new Properties();
        LegacyLicenseVerifierUtil.saveState(properties, PREF_SHOW_LEGACY_TIP, bl ? "true" : "false");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                properties.store(fileOutputStream, "Awakening Gatha, Deena Metzger");
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    private static boolean checkValid(IStatus iStatus, int n) {
        return iStatus != null && LegacyLicenseVerifierUtil.hasValidity(iStatus, n);
    }

    private static boolean hasValidity(IStatus iStatus, int n) {
        return (iStatus.getCode() & n) != 0;
    }

    private static void doShowNotification(final int n) {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        if (iWorkbench == null) {
            return;
        }
        final IWorkbench iWorkbench2 = iWorkbench;
        Display display = iWorkbench2.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow iWorkbenchWindow = iWorkbench2.getActiveWorkbenchWindow();
                if (iWorkbenchWindow == null) {
                    return;
                }
                Shell shell = iWorkbenchWindow.getShell();
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                Action action = new Action(){

                    public void run() {
                        LegacyLicenseVerifierUtil.saveLegacyState(false);
                        XMindNet.gotoURL((boolean)true, (String)"https://www.xmind.net/pricing", (Object[])new Object[0]);
                    }
                };
                action.setText(Messages.LegacyNotification_OK_text);
                String string = LegacyLicenseVerifierUtil.getNotificationText(n);
                if (string == null) {
                    return;
                }
                Notification notification = new Notification(shell, null, string, (IAction)action, null);
                notification.setGroupId("net.xmind.verify");
                notification.setCenterPopUp(true);
                notification.setDuration(-1);
                notification.popUp();
                notification.setCloseButtonListener(4, new Listener(){

                    public void handleEvent(Event event) {
                        LegacyLicenseVerifierUtil.saveLegacyState(false);
                    }
                });
            }
        });
    }

    private static String getNotificationText(int n) {
        if (LegacyValidity.LegacyVersion.XMIND_2012.getValue() == n) {
            return Messages.LicenseInputDialog_LegacyLicenseKeyErrorMessage_XMind2012;
        }
        if (LegacyValidity.LegacyVersion.XMIND_2013_PRO.getValue() == n) {
            return Messages.LicenseInputDialog_LegacyLicenseKeyErrorMessage_XMind2013Pro;
        }
        if (LegacyValidity.LegacyVersion.XMIND_2013_PLUS.getValue() == n) {
            return Messages.LicenseInputDialog_LegacyLicenseKeyErrorMessage_XMind2013Plus;
        }
        return null;
    }

    private static class Cryptus {
        private Cryptus() {
        }

        protected static String decrypt(String string, String string2) {
            if (string == null || "".equals(string) || string2 == null || "".equals(string2)) {
                return string;
            }
            try {
                byte[] byArray = string2.getBytes();
                byte[] byArray2 = Hex.decodeHex((char[])string.toCharArray());
                byte[] byArray3 = Cryptus.encdec(byArray, byArray2, 2);
                return new String(byArray3);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private static byte[] encdec(byte[] byArray, byte[] byArray2, int n) throws GeneralSecurityException {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray3 = messageDigest.digest(byArray);
            DESKeySpec dESKeySpec = new DESKeySpec(byArray3, byArray3.length - 8);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = secretKeyFactory.generateSecret(dESKeySpec);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3, 0, 8);
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            cipher.init(n, (Key)secretKey, ivParameterSpec);
            return cipher.doFinal(byArray2);
        }
    }
}

