/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.verify.legacy.internal;

import net.xmind.verify.internal.LicenseKeyHeader;
import net.xmind.verify.legacy.internal.LegacyValidity;

public class XMind2013LicenseVerifier {
    private static final int LICENSE_KEY_LENGTH = 225;
    private static final int HEADER_LENGTH = 12;

    public int verifyLicenseKey(String string) {
        String string2 = XMind2013LicenseVerifier.trimLicenseKey(string);
        if (string2.length() == 225) {
            String string3 = string2.substring(0, 12);
            LicenseKeyHeader licenseKeyHeader = LicenseKeyHeader.decode(string3);
            String string4 = licenseKeyHeader.getLicenseType();
            if ("A".equals(string4)) {
                return LegacyValidity.LegacyVersion.XMIND_2013_PRO.getValue();
            }
            if ("B".equals(string4)) {
                return LegacyValidity.LegacyVersion.XMIND_2013_PLUS.getValue();
            }
        }
        return 0;
    }

    private static String trimLicenseKey(String string) {
        int n = (string = string.toUpperCase()).indexOf("---BEGIN LICENSE KEY---");
        n = n < 0 ? 0 : (n += 23);
        int n2 = string.indexOf("---END LICENSE KEY---");
        if (n2 < 0) {
            n2 = string.length();
        }
        string = string.substring(n, n2).replaceAll("[^A-Z0-9]", "");
        return string;
    }
}

