/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.verify.ui.internal;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.xmind.signin.XMindNet;
import net.xmind.verify.internal.Messages;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.AbstractHyperlink;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.ui.resources.FontUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseInfoDialog
extends Dialog {
    private static final String DEFAULT_COLOR_KEY = "net.xmind.verify.ActivateProDialog.defaultColor";
    private static final String ICON_VALID = "icons/valid.png";
    private String actionName;
    private int requiredStatus;
    private int currentStatus;
    private boolean startup;
    private boolean update;
    private int targetStatus = 0;
    private String licensedTo;
    private Map<Integer, Control> licenseGroups = new HashMap<Integer, Control>();

    public LicenseInfoDialog(Shell shell, String string, int n, int n2, boolean bl, boolean bl2, String string2) {
        super(shell);
        this.actionName = string;
        this.requiredStatus = n;
        this.currentStatus = n2;
        this.startup = bl;
        this.update = bl2;
        this.licensedTo = string2;
        this.setBlockOnOpen(true);
        this.setReturnCode(1);
    }

    private String getMessage() {
        if (this.startup) {
            return Messages.LicenseInputDialog_StartupMessage;
        }
        if (this.update) {
            String string = System.getProperty("org.xmind.product.brandingVersion", "");
            String string2 = (this.currentStatus & 2) != 0 ? NLS.bind((String)Messages.LicenseInputDialog_LicenseName_XMindProLicense, (Object)string) : ((this.currentStatus & 1) != 0 ? Messages.LicenseInputDialog_LicenseName_XMindProSubscription : ((this.currentStatus & 4) != 0 ? NLS.bind((String)Messages.LicenseInputDialog_LicenseName_XMindPlusLicense, (Object)string) : null));
            if (string2 == null) {
                return Messages.LicenseInputDialog_UpdateMessage;
            }
            return NLS.bind((String)Messages.LicenseInputDialog_LicensedMessage, (Object)string2, (Object)(this.licensedTo == null ? Messages.LicenseInputDialog_UnknownLicensee : this.licensedTo));
        }
        if (this.actionName != null && !"".equals(this.actionName)) {
            this.actionName = String.valueOf(this.actionName.substring(0, 1).toUpperCase()) + this.actionName.substring(1);
            if ((this.requiredStatus & 4) == 0) {
                return NLS.bind((String)Messages.LicenseInputDialog_OnDemandProActionMessage, (Object)this.actionName);
            }
            return NLS.bind((String)Messages.LicenseInputDialog_OnDemandActionMessage, (Object)this.actionName);
        }
        if ((this.requiredStatus & 4) == 0) {
            return Messages.LicenseInputDialog_OnDemandProMessage;
        }
        return Messages.LicenseInputDialog_OnDemandMessage;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.LicenseInputDialog_windowTitle);
    }

    protected Control createDialogArea(Composite composite) {
        this.createMessageArea(composite);
        new Label(composite, 258).setLayoutData((Object)new GridData(4, 4, true, false));
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createLicenseChoiceArea(composite2);
        this.createLicenseInfoArea(composite2);
        this.createSubscriptionArea(composite2);
        return composite2;
    }

    private void createMessageArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 15;
        gridLayout.marginHeight = 15;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, false);
        composite2.setLayoutData((Object)gridData);
        if ((this.currentStatus & 7) != 0 && (this.requiredStatus & this.currentStatus) != 0) {
            composite2.setBackground(composite.getDisplay().getSystemColor(29));
        } else {
            composite2.setBackground(composite.getDisplay().getSystemColor(25));
        }
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
        this.setImage(label, composite);
        label.setBackground(composite2.getBackground());
        Label label2 = new Label(composite2, 64);
        label2.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        ((GridData)label2.getLayoutData()).widthHint = 400;
        label2.setText(this.getMessage());
        label2.setBackground(composite2.getBackground());
        label2.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-1));
    }

    protected void createLicenseChoiceArea(Composite composite) {
        Point point;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        ArrayList<Control> arrayList = new ArrayList<Control>();
        String string = System.getProperty("org.xmind.product.brandingVersion", "");
        this.createLicenseChoice(composite2, 4, NLS.bind((String)Messages.LicenseInputDialog_PlusFeatureTitle, (Object)string), false, Messages.LicenseInputDialog_PlusFeatureList, arrayList, Messages.LicenseInputDialog_BuyButton_text, new Runnable(){

            public void run() {
                LicenseInfoDialog.this.buyPlusLicense();
            }
        });
        this.createLicenseSeparator(composite2);
        this.createLicenseChoice(composite2, 2, NLS.bind((String)Messages.LicenseInputDialog_ProFeatureTitle, (Object)string), true, Messages.LicenseInputDialog_ProFeatureList, arrayList, Messages.LicenseInputDialog_BuyButton_text, new Runnable(){

            public void run() {
                LicenseInfoDialog.this.buyProLicense();
            }
        });
        int n = 0;
        int n2 = 0;
        for (Control control : arrayList) {
            point = control.computeSize(-1, -1);
            n = Math.max(n, point.x);
            n2 = Math.max(n2, point.y);
        }
        for (Control control : arrayList) {
            point = (GridData)control.getLayoutData();
            point.widthHint = n;
            point.minimumWidth = n;
            point.heightHint = n2;
            point.minimumHeight = n2;
        }
        this.updateLicenseGroups(this.requiredStatus);
    }

    private Control createLicenseChoice(Composite composite, int n, String string, boolean bl, String string2, List<Control> list, String string3, final Runnable runnable) {
        Label label;
        String string4;
        GridLayout gridLayout;
        Color color;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout2 = new GridLayout(1, false);
        gridLayout2.marginWidth = 40;
        gridLayout2.marginHeight = 5;
        gridLayout2.verticalSpacing = 5;
        gridLayout2.horizontalSpacing = 5;
        composite2.setLayout((Layout)gridLayout2);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout3 = new GridLayout(1, false);
        gridLayout3.marginWidth = 0;
        gridLayout3.marginHeight = 0;
        gridLayout3.verticalSpacing = 2;
        gridLayout3.horizontalSpacing = 0;
        composite3.setLayout((Layout)gridLayout3);
        composite3.setLayoutData((Object)new GridData(4, 4, true, false));
        String[] stringArray = string.split("\n");
        Label label2 = new Label(composite3, 0x1000000);
        label2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        label2.setText(stringArray[0]);
        label2.setFont(FontUtils.getBoldRelative((String)"org.eclipse.jface.defaultfont", (int)1));
        if (bl) {
            color = label2.getDisplay().getSystemColor(3);
            label2.setForeground(color);
            label2.setData(DEFAULT_COLOR_KEY, (Object)color);
        }
        if (stringArray.length > 1) {
            color = new Label(composite3, 0x1000000);
            color.setText(stringArray[1]);
            color.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
            color.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-2));
            if (bl) {
                gridLayout = color.getDisplay().getSystemColor(3);
                color.setForeground((Color)gridLayout);
                color.setData(DEFAULT_COLOR_KEY, (Object)gridLayout);
            }
        }
        color = new Composite(composite2, 0);
        color.setLayoutData((Object)new GridData(4, 4, true, true));
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 15;
        gridLayout.marginBottom = 5;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 5;
        color.setLayout((Layout)gridLayout);
        list.add((Control)color);
        Font font = FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-2);
        String[] stringArray2 = string2.split("\n");
        int n2 = 0;
        while (n2 < stringArray2.length) {
            string4 = stringArray2[n2];
            label = new Label((Composite)color, 0x1000000);
            label.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
            label.setText(string4);
            label.setFont(font);
            ++n2;
        }
        Composite composite4 = new Composite(composite2, 0);
        string4 = new GridLayout(1, false);
        ((GridLayout)string4).marginWidth = 5;
        ((GridLayout)string4).marginHeight = 0;
        ((GridLayout)string4).verticalSpacing = 0;
        ((GridLayout)string4).horizontalSpacing = 0;
        composite4.setLayout((Layout)string4);
        composite4.setLayoutData((Object)new GridData(4, 4, true, false));
        label = new Button(composite4, 8);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)label.getLayoutData()).minimumWidth = 120;
        ((GridData)label.getLayoutData()).widthHint = 120;
        label.setText(string3);
        label.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                runnable.run();
            }
        });
        this.licenseGroups.put(n, (Control)composite2);
        return composite2;
    }

    private void createLicenseSeparator(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(0x1000000, 4, false, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 3;
        gridLayout.marginHeight = 20;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 514);
        label.setLayoutData((Object)new GridData(0x1000000, 4, false, true));
    }

    private void targetSelected(int n) {
        this.targetStatus = n;
        this.setReturnCode(0);
        this.close();
    }

    public int getTargetStatus() {
        return this.targetStatus;
    }

    private void createMoreInfoArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 15;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 3;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        label.setText("*");
        label.setForeground(label.getDisplay().getSystemColor(16));
        label.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-2));
        Hyperlink hyperlink = new Hyperlink(composite2, 0);
        hyperlink.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        hyperlink.setText(Messages.LicenseInputDialog_MoreInfoLink_text);
        hyperlink.setForeground(hyperlink.getDisplay().getSystemColor(16));
        hyperlink.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-2));
        hyperlink.setUnderlined(true);
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                XMindNet.gotoURL((boolean)true, (String)"http://www.xmind.net/xmind/buy/moreinfo/", (Object[])new Object[0]);
            }
        });
    }

    private void createLicenseInfoArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        Hyperlink hyperlink = new Hyperlink(composite2, 0);
        try {
            Field field = AbstractHyperlink.class.getDeclaredField("paintFocus");
            field.setAccessible(true);
            field.set(hyperlink, false);
        }
        catch (Throwable throwable) {}
        hyperlink.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        if ((this.currentStatus & 4) != 0 || (this.currentStatus & 2) != 0) {
            hyperlink.setText(Messages.LicenseInfoDialog_ViewChangeLink_Text);
        } else {
            hyperlink.setText(Messages.LicenseInfoDialog_EnterLicenseLink_Text);
        }
        hyperlink.setForeground(hyperlink.getDisplay().getSystemColor(9));
        hyperlink.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)1));
        hyperlink.setUnderlined(true);
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                LicenseInfoDialog.this.targetSelected(6);
            }
        });
    }

    private void createSubscriptionArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 30;
        gridLayout.marginBottom = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        Hyperlink hyperlink = new Hyperlink(composite2, 0);
        hyperlink.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        hyperlink.setText(Messages.LicenseInfoDialog_SubscriptionLink_Text);
        hyperlink.setForeground(hyperlink.getDisplay().getSystemColor(9));
        hyperlink.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-1));
        hyperlink.setUnderlined(true);
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                LicenseInfoDialog.this.targetSelected(1);
            }
        });
    }

    protected void createButtonsForButtonBar(Composite composite) {
        Button button = this.createButton(composite, 1, this.update || this.startup || (this.currentStatus & 7) != 0 ? IDialogConstants.CLOSE_LABEL : IDialogConstants.CANCEL_LABEL, false);
        button.setFocus();
    }

    private void updateLicenseGroups(int n) {
        for (Integer n2 : this.licenseGroups.keySet()) {
            this.updateEnablement(this.licenseGroups.get(n2), (n & n2) != 0);
        }
    }

    private void updateEnablement(Control control, boolean bl) {
        control.setEnabled(bl);
        if (control instanceof Label) {
            control.setForeground(bl ? this.getDefaultColor(control) : control.getDisplay().getSystemColor(15));
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = 0;
            while (n < controlArray.length) {
                this.updateEnablement(controlArray[n], bl);
                ++n;
            }
        }
    }

    private Color getDefaultColor(Control control) {
        Object object = control.getData(DEFAULT_COLOR_KEY);
        if (object != null && object instanceof Color) {
            return (Color)object;
        }
        return null;
    }

    private void buyProLicense() {
        XMindNet.gotoURL((boolean)true, (String)"http://www.xmind.net/xmind/buy/pro/", (Object[])new Object[0]);
    }

    private void buyPlusLicense() {
        XMindNet.gotoURL((boolean)true, (String)"http://www.xmind.net/xmind/buy/plus/", (Object[])new Object[0]);
    }

    private void buyProSubscription() {
        XMindNet.gotoURL((boolean)true, (String)"http://www.xmind.net/xmind/buy/subscription/", (Object[])new Object[0]);
    }

    private void setImage(Label label, Composite composite) {
        URL uRL;
        if ((this.currentStatus & 7) != 0 && (this.requiredStatus & this.currentStatus) != 0 && (uRL = Platform.getBundle((String)"net.xmind.verify").getEntry(ICON_VALID)) != null) {
            try {
                label.setImage(new Image(null, uRL.openStream()));
                return;
            }
            catch (IOException iOException) {}
        }
        label.setImage(composite.getDisplay().getSystemImage(2));
    }
}

