/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.verify.ui.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import net.xmind.verify.internal.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.viewers.SWTUtils;

public class LicenseKeyInputDialog
extends Dialog {
    private static final String ICON_VALID = "icons/valid.png";
    private static final int CLEAR_ID = 1024;
    public static final int CLEARED = 1024;
    private Properties data;
    private int requiredStatus;
    private IStatus validity;
    private boolean sheet;
    private boolean showClear;
    private String errorMessage = null;
    private Composite messageArea;
    private Composite errorMessageArea;
    private Label errorLabel;
    private static String __PLACEHOLDER_TEXT__ = null;

    public LicenseKeyInputDialog(Shell shell, Properties properties, int n, IStatus iStatus, boolean bl, boolean bl2) {
        super(shell);
        Assert.isNotNull((Object)properties);
        this.data = properties;
        this.validity = iStatus;
        this.requiredStatus = n;
        this.sheet = bl;
        this.showClear = bl2;
        if (bl) {
            this.setShellStyle(this.getShellStyle() | 0x10000000);
        }
    }

    public Properties getData() {
        return this.data;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
        if (this.errorLabel == null || this.errorLabel.isDisposed()) {
            return;
        }
        Composite composite = this.messageArea.getParent();
        StackLayout stackLayout = (StackLayout)composite.getLayout();
        if (string == null) {
            stackLayout.topControl = this.messageArea;
            this.messageArea.setVisible(true);
            this.errorMessageArea.setVisible(false);
        } else {
            this.errorLabel.setText(string);
            stackLayout.topControl = this.errorMessageArea;
            this.messageArea.setVisible(false);
            this.errorMessageArea.setVisible(true);
        }
        composite.layout();
    }

    private String getDialogMessage() {
        String string;
        String string2 = System.getProperty("org.xmind.product.brandingVersion", "");
        if ((this.validity.getCode() & 2) != 0) {
            string = NLS.bind((String)Messages.LicenseInputDialog_LicenseName_XMindProLicense, (Object)string2);
        } else if ((this.validity.getCode() & 4) != 0 && (this.validity.getCode() & 2) == 0) {
            string = NLS.bind((String)Messages.LicenseInputDialog_LicenseName_XMindPlusLicense, (Object)string2);
        } else {
            String string3 = "Pro/Plus";
            return NLS.bind((String)Messages.LicenseKeyInputDialog_DialogMessage, (Object)string3, (Object)string2);
        }
        return NLS.bind((String)Messages.LicenseInputDialog_LicensedMessage, (Object)string, (Object)(this.getLicenseTo() == null ? Messages.LicenseInputDialog_UnknownLicensee : this.getLicenseTo()));
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.sheet) {
            shell.setText(this.getParentShell().getText());
        } else {
            shell.setText(Messages.LicenseInputDialog_windowTitle);
        }
    }

    protected Control createDialogArea(Composite composite) {
        this.createMessageArea(composite);
        new Label(composite, 258).setLayoutData((Object)new GridData(4, 4, true, false));
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createInputs(composite2);
        return composite2;
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.updateButtonStatus();
        return control;
    }

    private void createMessageArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        StackLayout stackLayout = new StackLayout();
        stackLayout.marginHeight = 0;
        stackLayout.marginWidth = 0;
        composite2.setLayout((Layout)stackLayout);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 480;
        gridData.heightHint = -1;
        composite2.setLayoutData((Object)gridData);
        if (this.showClear) {
            composite2.setBackground(composite.getDisplay().getSystemColor(29));
        } else {
            composite2.setBackground(composite.getDisplay().getSystemColor(25));
        }
        this.messageArea = this.createMessagePage(composite2);
        this.messageArea.setBackground(composite2.getBackground());
        this.createMessageIcon(this.messageArea, 2);
        this.createMessageLabel(this.messageArea, this.getDialogMessage());
        this.errorMessageArea = this.createMessagePage(composite2);
        this.createMessageIcon(this.errorMessageArea, 8);
        this.errorLabel = this.createMessageLabel(this.errorMessageArea, this.errorMessage);
        this.setErrorMessage(this.errorMessage);
    }

    private Composite createMessagePage(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 15;
        gridLayout.marginHeight = 10;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        composite2.setBackground(composite.getDisplay().getSystemColor(25));
        return composite2;
    }

    private Label createMessageIcon(Composite composite, int n) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(1, 0x1000000, false, true);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        label.setLayoutData((Object)gridData);
        label.setBackground(composite.getBackground());
        this.setImage(label, composite);
        return label;
    }

    private Label createMessageLabel(Composite composite, String string) {
        Label label = new Label(composite, 64);
        GridData gridData = new GridData(4, 0x1000000, true, true);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        label.setLayoutData((Object)gridData);
        label.setBackground(composite.getBackground());
        label.setForeground(composite.getDisplay().getSystemColor(24));
        label.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-1));
        if (string != null) {
            label.setText(string);
        }
        return label;
    }

    private void createInputs(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createInputLabel(composite2, Messages.LicenseKeyInputDialog_License_label);
        this.createInput(composite2, "TimeSmilesInMyHand", false, -1, -1);
        this.createInputLabel(composite2, Messages.LicenseKeyInputDialog_LicenseKey_label);
        this.createInput(composite2, "WalkingInTheMorning", true, 130, 12);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int calcFontSize(int n, int n2, int n3) {
        int n4 = n;
        GC gC = new GC((Drawable)this.getShell());
        try {
            block7: {
                Point point;
                block6: {
                    point = null;
                    if (!true) break block6;
                    if (point != null) return n4;
                    if (n4 <= 0) break block7;
                }
                do {
                    gC.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)n4));
                    point = gC.textExtent(LicenseKeyInputDialog.getPlaceholderText(), 2);
                    if (point.x > n2 || point.y > n3) {
                        --n4;
                        point = null;
                    }
                    if (point != null) return n4;
                } while (n4 > 0);
            }
            return n4;
        }
        finally {
            gC.dispose();
        }
    }

    private Control createInputLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
        label.setLayoutData((Object)new GridData(0x1000008, 1, false, false));
        label.setFont(FontUtils.getBold((String)"org.eclipse.jface.defaultfont"));
        return label;
    }

    private Control createInput(Composite composite, final String string, boolean bl, int n, final int n2) {
        int n3 = 2048;
        n3 = bl ? (n3 |= 0x40) : (n3 |= 4);
        final Text text = new Text(composite, n3);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.minimumWidth = 320;
        gridData.widthHint = 320;
        gridData.heightHint = n;
        text.setLayoutData((Object)gridData);
        String string2 = this.data.getProperty(string);
        if (string2 != null) {
            text.setText(string2);
        }
        if (n2 > 0) {
            text.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)n2));
            text.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    Rectangle rectangle = text.getClientArea();
                    int n = LicenseKeyInputDialog.this.calcFontSize(n2, rectangle.width - 10, rectangle.height - 10);
                    if (n != n2) {
                        text.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)n));
                    }
                }
            });
        }
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                LicenseKeyInputDialog.this.setErrorMessage(null);
                String string2 = ((Text)modifyEvent.widget).getText();
                LicenseKeyInputDialog.this.data.setProperty(string, string2);
                LicenseKeyInputDialog.this.updateButtonStatus();
            }
        });
        if (bl) {
            text.addListener(1, new Listener(){

                public void handleEvent(Event event) {
                    if (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)0, (int)13)) {
                        LicenseKeyInputDialog.this.buttonPressed(0);
                        event.doit = false;
                    }
                }
            });
        }
        return text;
    }

    protected Control createButtonBar(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 0;
        gridLayout2.makeColumnsEqualWidth = true;
        gridLayout2.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout2.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout2.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout2.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite3.setLayout((Layout)gridLayout2);
        GridData gridData2 = new GridData(1, 0x1000000, true, false);
        gridData2.widthHint = -1;
        gridData2.heightHint = -1;
        composite3.setLayoutData((Object)gridData2);
        composite3.setFont(composite.getFont());
        this.createButtonsFroLeftButtonBar(composite3);
        Composite composite4 = (Composite)super.createButtonBar(composite2);
        Control[] controlArray = composite4.getChildren();
        if (controlArray.length == 2) {
            Button button = (Button)controlArray[0];
            Button button2 = (Button)controlArray[1];
            if (!this.showClear) {
                button.setText(Messages.LicenseKeyInputDialog_VerifyButton_Text);
            }
            button2.setText(Messages.LicenseKeyInputDialog_BackButton_Text);
        }
        return composite4;
    }

    protected void createButtonsFroLeftButtonBar(Composite composite) {
        if (this.showClear) {
            this.createButton(composite, 1024, Messages.LicenseKeyInputDialog_Clear_buttonText, false);
        }
    }

    protected void buttonPressed(int n) {
        if (1024 == n) {
            this.clearPressed();
        } else {
            super.buttonPressed(n);
        }
    }

    private void clearPressed() {
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.LicenseKeyInputDialog_ClearDialog_title, (String)Messages.LicenseKeyInputDialog_ClearDialog_message)) {
            this.data.remove("TimeSmilesInMyHand");
            this.data.remove("WalkingInTheMorning");
            this.setReturnCode(1024);
            this.close();
        }
    }

    private void updateButtonStatus() {
        Button button = this.getButton(0);
        if (button != null && !button.isDisposed()) {
            button.setEnabled(this.canFinish());
        }
        if ((button = this.getButton(1024)) != null && !button.isDisposed()) {
            button.setEnabled(this.hasValue("WalkingInTheMorning") || this.hasValue("TimeSmilesInMyHand"));
        }
    }

    private boolean canFinish() {
        return this.hasValue("TimeSmilesInMyHand") && this.hasValue("WalkingInTheMorning");
    }

    private boolean hasValue(String string) {
        String string2 = this.data.getProperty(string);
        return string2 != null && !"".equals(string2);
    }

    private static synchronized String getPlaceholderText() {
        if (__PLACEHOLDER_TEXT__ == null) {
            StringBuilder stringBuilder = new StringBuilder(315);
            int n = 0;
            while (n < 7) {
                int n2 = 0;
                while (n2 < 9) {
                    if (n2 > 0) {
                        stringBuilder.append('-');
                    }
                    stringBuilder.append("XXXXX");
                    ++n2;
                }
                stringBuilder.append(System.getProperty("line.separator"));
                ++n;
            }
            __PLACEHOLDER_TEXT__ = stringBuilder.toString();
        }
        return __PLACEHOLDER_TEXT__;
    }

    private void setImage(Label label, Composite composite) {
        URL uRL;
        if (this.showClear && (uRL = Platform.getBundle((String)"net.xmind.verify").getEntry(ICON_VALID)) != null) {
            try {
                label.setImage(new Image(null, uRL.openStream()));
                return;
            }
            catch (IOException iOException) {}
        }
        label.setImage(composite.getDisplay().getSystemImage(2));
    }

    private String getLicenseTo() {
        return this.data.getProperty("TimeSmilesInMyHand");
    }
}

