/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.verify.ui.internal;

import java.util.Properties;
import net.xmind.signin.XMindNet;
import net.xmind.verify.internal.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.viewers.SWTUtils;

public class LicenseKeyInputDialog2
extends TitleAreaDialog {
    public static final int CLEARED = 1024;
    public static final int CLOSE = 1025;
    private Properties data;
    private IStatus validity;
    private boolean sheet;
    private boolean showClear;
    private String errorMessage = null;
    private Image titleImage;
    private static String __PLACEHOLDER_TEXT__ = null;

    public LicenseKeyInputDialog2(Shell shell, Properties properties, int n, IStatus iStatus, boolean bl, boolean bl2) {
        super(shell);
        Assert.isNotNull((Object)properties);
        this.data = properties;
        this.validity = iStatus;
        this.sheet = bl;
        this.showClear = bl2;
        if (bl) {
            this.setShellStyle(this.getShellStyle() | 0x10000000);
        }
    }

    public Properties getData() {
        return this.data;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.sheet) {
            shell.setText(this.getParentShell().getText());
        } else {
            shell.setText(Messages.LicenseKeyInputDialog_LicenseKey_Title);
        }
    }

    public void create() {
        super.create();
        this.setTitle(this.getTitleMessage());
        if (this.titleImage == null) {
            this.titleImage = XMindNet.createBannerLogo();
        }
        if (this.titleImage != null) {
            this.setTitleImage(this.titleImage);
        }
        if (this.errorMessage == null) {
            this.setMessage(this.getDialogMessage());
        } else {
            this.setMessage(this.errorMessage, 2);
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 15;
        gridLayout.marginWidth = 13;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(1808));
        this.createInputs(composite3);
        return composite2;
    }

    private String getTitleMessage() {
        String string;
        String string2 = System.getProperty("org.xmind.product.brandingVersion", "");
        if ((this.validity.getCode() & 2) != 0) {
            string = NLS.bind((String)Messages.LicenseInputDialog_proTitle, (Object)string2);
        } else if ((this.validity.getCode() & 4) != 0 && (this.validity.getCode() & 2) == 0) {
            string = NLS.bind((String)Messages.LicenseInputDialog_plusTitle, (Object)string2);
        } else {
            return Messages.LicenseKeyInputDialog_LicenseKey_Title;
        }
        return string;
    }

    private String getDialogMessage() {
        String string;
        String string2 = System.getProperty("org.xmind.product.brandingVersion", "");
        if ((this.validity.getCode() & 2) != 0) {
            string = NLS.bind((String)Messages.LicenseInputDialog_LicenseName_XMindProLicense, (Object)string2);
        } else if ((this.validity.getCode() & 4) != 0 && (this.validity.getCode() & 2) == 0) {
            string = NLS.bind((String)Messages.LicenseInputDialog_LicenseName_XMindPlusLicense, (Object)string2);
        } else {
            String string3 = "Pro/Plus";
            return NLS.bind((String)Messages.LicenseKeyInputDialog_DialogMessage, (Object)string3, (Object)string2);
        }
        return NLS.bind((String)Messages.LicenseInputDialog_LicensedMessage, (Object)string, (Object)(this.getLicenseTo() == null ? Messages.LicenseInputDialog_UnknownLicensee : this.getLicenseTo()));
    }

    private String getLicenseTo() {
        return this.data.getProperty("TimeSmilesInMyHand");
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.updateButtonStatus();
        return control;
    }

    private void createInputs(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        this.createInputLabel(composite2, Messages.LicenseKeyInputDialog_License_label);
        this.createInput(composite2, "TimeSmilesInMyHand", false, -1, -1);
        this.createInputLabel(composite2, Messages.LicenseKeyInputDialog_LicenseKey_label);
        this.createInput(composite2, "WalkingInTheMorning", true, 130, 12);
        this.createInputLabel(composite2, "");
        if (this.data.getProperty("TimeSmilesInMyHand") != null && this.showClear) {
            this.createClearLink(composite2);
        }
    }

    private Control createInputLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
        label.setLayoutData((Object)new GridData(0x1000008, 1, false, false));
        label.setFont(FontUtils.getBold((String)"org.eclipse.jface.defaultfont"));
        return label;
    }

    private Control createInput(Composite composite, final String string, boolean bl, int n, int n2) {
        String string2 = this.data.getProperty(string);
        if (!this.showClear) {
            int n3 = 2048;
            n3 = bl ? (n3 |= 0x40) : (n3 |= 4);
            Text text = new Text(composite, n3);
            GridData gridData = new GridData(4, 4, true, false);
            gridData.minimumWidth = 320;
            gridData.widthHint = 320;
            gridData.heightHint = n;
            text.setLayoutData((Object)gridData);
            this.setFont((Control)text, n2);
            if (string2 != null) {
                text.setText(string2);
            }
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    LicenseKeyInputDialog2.this.setErrorMessage(null);
                    String string2 = ((Text)modifyEvent.widget).getText();
                    LicenseKeyInputDialog2.this.data.setProperty(string, string2);
                    LicenseKeyInputDialog2.this.updateButtonStatus();
                }
            });
            if (bl) {
                text.addListener(1, new Listener(){

                    public void handleEvent(Event event) {
                        if (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)0, (int)13)) {
                            LicenseKeyInputDialog2.this.buttonPressed(0);
                            event.doit = false;
                        }
                    }
                });
            }
            return text;
        }
        Label label = new Label(composite, 64);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.minimumWidth = 320;
        gridData.widthHint = 320;
        gridData.heightHint = n;
        label.setLayoutData((Object)gridData);
        this.setFont((Control)label, n2);
        label.setText(string2);
        return label;
    }

    private void setFont(final Control control, final int n) {
        if (n > 0) {
            control.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)n));
            control.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    Rectangle rectangle = control.getBounds();
                    int n2 = LicenseKeyInputDialog2.this.calcFontSize(n, rectangle.width - 10, rectangle.height - 10);
                    if (n2 != n) {
                        control.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)n2));
                    }
                }
            });
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int calcFontSize(int n, int n2, int n3) {
        int n4 = n;
        GC gC = new GC((Drawable)this.getShell());
        try {
            block7: {
                Point point;
                block6: {
                    point = null;
                    if (!true) break block6;
                    if (point != null) return n4;
                    if (n4 <= 0) break block7;
                }
                do {
                    gC.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)n4));
                    point = gC.textExtent(LicenseKeyInputDialog2.getPlaceholderText(), 2);
                    if (point.x > n2 || point.y > n3) {
                        --n4;
                        point = null;
                    }
                    if (point != null) return n4;
                } while (n4 > 0);
            }
            return n4;
        }
        finally {
            gC.dispose();
        }
    }

    private void createClearLink(Composite composite) {
        Hyperlink hyperlink = new Hyperlink(composite, 0);
        composite.setFocus();
        hyperlink.setText(Messages.LicenseKeyInputDialog_Clear_linkText);
        hyperlink.setForeground(composite.getDisplay().getSystemColor(9));
        hyperlink.setUnderlined(true);
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                LicenseKeyInputDialog2.this.clearPressed();
            }
        });
    }

    private void clearPressed() {
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.LicenseKeyInputDialog_ClearDialog_title, (String)Messages.LicenseKeyInputDialog_ClearDialog_message)) {
            this.data.remove("TimeSmilesInMyHand");
            this.data.remove("WalkingInTheMorning");
            this.setReturnCode(1024);
            this.close();
        }
    }

    protected Control createButtonBar(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 0;
        gridLayout2.makeColumnsEqualWidth = true;
        gridLayout2.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout2.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout2.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout2.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite3.setLayout((Layout)gridLayout2);
        GridData gridData2 = new GridData(1, 0x1000000, true, false);
        gridData2.widthHint = -1;
        gridData2.heightHint = -1;
        composite3.setLayoutData((Object)gridData2);
        composite3.setFont(composite.getFont());
        if (!this.showClear) {
            this.createButtonsFroLeftButtonBar(composite3);
        }
        Composite composite4 = (Composite)super.createButtonBar(composite2);
        return composite4;
    }

    protected void createButtonsFroLeftButtonBar(Composite composite) {
        this.createButton(composite, 1, Messages.LicenseKeyInputDialog_BackButton_Text, false);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        if (!this.showClear) {
            this.createButton(composite, 0, Messages.LicenseKeyInputDialog_VerifyButton_Text, true);
        }
        this.createButton(composite, 12, Messages.LicenseKeyInputDialog_CloseButton_Text, this.showClear);
    }

    protected void buttonPressed(int n) {
        if (n == 12) {
            this.closeDialog();
        }
        if (n == 1) {
            if (this.showClear) {
                this.closeDialog();
            } else {
                super.cancelPressed();
            }
        }
        if (n == 0) {
            super.okPressed();
        }
    }

    private void closeDialog() {
        this.setReturnCode(1025);
        this.close();
    }

    private void updateButtonStatus() {
        Button button = this.getButton(0);
        if (button != null && !button.isDisposed()) {
            button.setEnabled(this.canFinish() && !this.showClear);
        }
        if ((button = this.getButton(1)) != null && !button.isDisposed()) {
            button.setEnabled(!this.showClear);
        }
    }

    private boolean canFinish() {
        return this.hasValue("TimeSmilesInMyHand") && this.hasValue("WalkingInTheMorning");
    }

    private boolean hasValue(String string) {
        String string2 = this.data.getProperty(string);
        return string2 != null && !"".equals(string2);
    }

    private static synchronized String getPlaceholderText() {
        if (__PLACEHOLDER_TEXT__ == null) {
            StringBuilder stringBuilder = new StringBuilder(315);
            int n = 0;
            while (n < 7) {
                int n2 = 0;
                while (n2 < 9) {
                    if (n2 > 0) {
                        stringBuilder.append('-');
                    }
                    stringBuilder.append("XXXXX");
                    ++n2;
                }
                stringBuilder.append(System.getProperty("line.separator"));
                ++n;
            }
            __PLACEHOLDER_TEXT__ = stringBuilder.toString();
        }
        return __PLACEHOLDER_TEXT__;
    }

    public boolean close() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        return super.close();
    }
}

