/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.verify.ui.internal;

import java.lang.reflect.Field;
import net.xmind.signin.XMindNet;
import net.xmind.verify.internal.Messages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.AbstractHyperlink;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.ui.resources.FontUtils;

public class SubscriptionInfoDialog
extends TitleAreaDialog {
    public static final int REDEEM_ID = 1025;
    private int validityStatus = 0;
    private String user;
    private long expireDate;
    private Image titleImage;

    public SubscriptionInfoDialog(Shell shell, int n, String string, long l) {
        super(shell);
        this.validityStatus = n;
        this.user = string;
        this.expireDate = l;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.SubscriptionInfoDialog_DialogTitle_Text);
    }

    public void create() {
        super.create();
        this.setTitle(Messages.SubscriptionInfoDialog_DialogTitle_Text);
        if (this.titleImage == null) {
            this.titleImage = XMindNet.createBannerLogo();
        }
        if (this.titleImage != null) {
            this.setTitleImage(this.titleImage);
        }
        this.setMessage(this.getInfo());
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createInfoArea(composite2);
        return composite2;
    }

    private void createInfoArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        if (this.validityStatus == 4096) {
            this.createInfoLabel(composite2, Messages.SubscriptionInfoDialog_NotSubscribed_Label, 0x1000008);
        } else {
            this.createInfoLabel(composite2, Messages.SubscriptionInfoDialog_XMindID_Label, 0x1000008);
            this.createInfoLabel(composite2, this.user, 1);
            String string = this.getExpireDate();
            if (string != null) {
                this.createInfoLabel(composite2, Messages.SubscriptionInfoDialog_ExpiryDate_Label, 0x1000008);
                this.createInfoLabel(composite2, string, 1);
            }
            this.createInfoLabel(composite2, Messages.SubscriptionInfoDialog_StatusLabel, 0x1000008);
            this.createInfoLabel(composite2, this.getStatusMessage(), 1);
        }
    }

    private Control createInfoLabel(Composite composite, String string, int n) {
        Label label = new Label(composite, 0);
        label.setText(string);
        label.setLayoutData((Object)new GridData(n, 1, false, false));
        return label;
    }

    protected Control createButtonBar(Composite composite) {
        GridLayout gridLayout;
        Composite composite2;
        Composite composite3 = new Composite(composite, 0);
        GridLayout gridLayout2 = new GridLayout(2, false);
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        gridLayout2.verticalSpacing = 0;
        gridLayout2.horizontalSpacing = 0;
        composite3.setLayout((Layout)gridLayout2);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        composite3.setLayoutData((Object)gridData);
        if (this.validityStatus != 4096) {
            composite2 = new Composite(composite3, 0);
            gridLayout = new GridLayout(1, false);
            gridLayout.numColumns = 1;
            gridLayout.makeColumnsEqualWidth = true;
            gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
            gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            composite2.setLayout((Layout)gridLayout);
            GridData gridData2 = new GridData(1, 0x1000000, true, false);
            gridData2.widthHint = -1;
            gridData2.heightHint = -1;
            composite2.setLayoutData((Object)gridData2);
            composite2.setFont(composite.getFont());
            this.createButtonsForLeftButtonBar(composite2);
        }
        composite2 = new Composite(composite3, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 0;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
        composite2.setFont(composite.getFont());
        this.createButtonsForButtonBar(composite2);
        return composite3;
    }

    private void createButtonsForLeftButtonBar(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 3;
        composite2.setLayout((Layout)gridLayout);
        Hyperlink hyperlink = new Hyperlink(composite2, 0);
        try {
            Field field = AbstractHyperlink.class.getDeclaredField("paintFocus");
            field.setAccessible(true);
            field.set(hyperlink, false);
        }
        catch (Throwable throwable) {}
        hyperlink.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        hyperlink.setText(Messages.SubscriptionInfoDialog_RedeemHistoryLink_Text);
        hyperlink.setForeground(hyperlink.getDisplay().getSystemColor(9));
        hyperlink.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)0));
        hyperlink.setUnderlined(true);
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                XMindNet.gotoURL((boolean)true, (String)"https://www.xmind.net/account/subscription/", (Object[])new Object[0]);
            }
        });
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1025, Messages.SubscriptionInfoDialog_RedeemButton_Label, true);
        Button button = this.createButton(composite, 0, Messages.SubscriptionInfoDialog_OKButton_Label, true);
        button.setFocus();
    }

    protected void buttonPressed(int n) {
        if (n == 1025) {
            XMindNet.gotoURL((boolean)true, (String)"http://www.xmind.net/xmind/buy/subscription/", (Object[])new Object[0]);
            return;
        }
        super.buttonPressed(n);
    }

    private String getExpireDate() {
        if (this.expireDate == 0L) {
            return null;
        }
        return String.format("%tF", this.expireDate);
    }

    private String getStatusMessage() {
        if (this.validityStatus == 1) {
            return Messages.SubscriptionInfoDialog_AvailableText;
        }
        if (this.validityStatus == 2048) {
            return Messages.SubscriptionInfoDialog_ExpiredText;
        }
        return "";
    }

    private String getInfo() {
        if (this.validityStatus == 1) {
            return Messages.SubscriptionInfoDialog_MessageArea_ActivedLabel;
        }
        return Messages.SubscriptionInfoDialog_MessageAreaRedeemLabel;
    }

    public boolean close() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        return super.close();
    }
}

